/* TList.h  ---  Double-linked list class 
   
   Copyright (C) 1993  A.Matthias
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#ifndef _TList_h
#define _TList_h

#include <fnmatch.h>

#include "globals.h"
#include "TElem.h"

class TList   // List which holds the directory filenames
{
private:
  TElem *first, *last, *act;
  int nextnum;
  
public:
  TList()
  {
    TElem *item = new TElem;
    nextnum = 0;
    first = item;
    first->fname[0] = '\0';
    first->uname[0] = '\0';
    first->gname[0] = '\0';
    first->fmode[0] = '\0';
    first->fsize = 0L;
    first->num = 0;
    first->status = INVALID;
    first->truename[0] = '\0';
    first->next = NULL;
    first->prev = NULL;
    last = first;
    act = first;
  }
  
  void add( TElem *item  ) 
  { 
    TElem *next = new TElem;
    
    if ( next==NULL )
    { endwin(); cerr << "Panic: malloc() failed\n"; exit(1); }
    
    // We make a real copy of the values, not just the reference, so
    // that the caller can overwrite the referenced data	
    
    strcpy( last->fname, item->fname );
    strcpy( last->uname, item->uname );
    strcpy( last->gname, item->gname );
    strcpy( last->fmode, item->fmode );
    last->fsize = item->fsize;
    last->next = next;
    last->num = nextnum;
    last->status = NONE;
    strcpy( last->truename, item->truename );
    last->next->next = NULL;
    last->next->prev = last;
    last = last->next;
    nextnum++;
  }
  
  TElem* getelem( void )
    // At end of list, NULL is repeatedly returned, until the list is rewinded.
  {
    static TElem *retval; // return value
    
    if ( act->next==last )  
      return (TElem*)NULL;      
    retval=act;
    
    return retval;
  }
  
  int getnum( void )
    // Returns the field act->num, but does *not* change act itself
  {
    return( act->num );
  }
  
  char* getfname( char* retval )
    // Returns the field act->fname
  {
    strcpy( retval, act->fname );
    return( retval );
  }
  
  char *getfname( int num )
  {
    TElem *tmp;
    tmp=first;
    do
    {
      if ( tmp->num == num ) return( tmp->fname );
      tmp = tmp->next;
    } 
    while ( tmp->next != last );
    
    return( NULL );
  }
  
  
  char *getfmode( int num )
  {
    TElem *tmp;
    tmp=first;
    do
    {
      if ( tmp->num == num ) return( tmp->fmode );
      tmp = tmp->next;
    } 
    while ( tmp->next != last );
    
    return( NULL );
  }
  
  char *getuname( int num )
  {
    TElem *tmp;
    tmp=first;
    do
    {
      if ( tmp->num == num ) return( tmp->uname );
      tmp = tmp->next;
    } 
    while ( tmp->next != last );
    
    return( NULL );
  }
  
  char *getgname( int num )
  {
    TElem *tmp;
    tmp=first;
    do
    {
      if ( tmp->num == num ) return( tmp->gname );
      tmp = tmp->next;
    } 
    while ( tmp->next != last );
    
    return( NULL );
  }
  
  
  STATUS getstatus( int num )
  {
    TElem *tmp;
    tmp=first;
    do
    {
      if ( tmp->num == num ) return( tmp->status );
      tmp = tmp->next;
    } 
    while ( tmp->next != last );
    
    return( INVALID );
  }
  
  void mark( int num )
  {
    TElem *tmp;
    tmp=first;
    do
    {
      if ( tmp->num == num ) tmp->status=MARK;
      tmp = tmp->next;
    } 
    while ( tmp->next != last );
  }
  
  void unmark( int num )
  {
    TElem *tmp;
    tmp=first;
    do
    {
      if ( tmp->num == num ) tmp->status=NONE;
      tmp = tmp->next;
    } 
    while ( tmp->next != last );
  }


  void markpattern( char *pattern )
  {
    TElem *tmp;
    
    tmp=first;
    do
    {
      if ( ( fnmatch( pattern, tmp->fname, FNM_PERIOD ) == 0 )
	  && ( tmp->fmode[0] != 'd' ) )
	tmp->status = MARK;
      tmp = tmp->next;
    } 
    while ( tmp->next != last );
  }

  
  void unmarkpattern( char *pattern )
  {
    TElem *tmp;
    
    tmp=first;
    do
    {
      if ( ( fnmatch( pattern, tmp->fname, FNM_PERIOD ) == 0 )
	  && ( tmp->fmode[0] != 'd' ) )
	tmp->status = NONE;
      tmp = tmp->next;
    } 
    while ( tmp->next != last );
  }

  
  void rewind( void )
  {
    act=first;
  }
  
  void next( void )
  {
    if ( (act->next!=last) && (act->next != NULL ) )
      act = act->next;
  }
  
  void prev( void )
  {
    if ( (act!=first) && (act->prev != NULL ) )
      act = act->prev;
  }
  
  void wipe( void )
  {
    act=last;
    while ( act != first )
    {
      act=act->prev;
      delete act->next;
      act->next=NULL;
    }
    act->status = INVALID;
    last=act;
    nextnum = 0;
  }
  
};

#endif





