/* TMsgDlg.h --- The message dialog box class  
   
   Copyright (C) 1994  A.Matthias
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#ifndef _TMsgDlg_h
#define _TMsgDlg_h

extern "C" {
#include <ncurses/ncurses.h>
}
#include "globals.h"
#include "config.h"
#include "lineedit.h"

#define DLGHT 5
#define DLGWT 60

class TMsgDlg
{
private:

#define OK_TEXT  "[Return=OK]"
#define ESC_TEXT "[ESC=Cancel]"

  WINDOW *wptr, *frameptr;
  char title[PATH_MAX];
  int x1, y1, x2, y2;
  bool shown;
  int hascolor;
  bool expectinput;

public:
  TMsgDlg( char* title, bool expectinput )
  {
    x1 = (SCR_X/2)-(DLGWT/2);
    x2 = (SCR_X/2)+(DLGWT/2);
    y1 = (SCR_Y/2)-(DLGHT/2);
    if (expectinput==TRUE)
      y2 = (SCR_Y/2)+(DLGHT/2)+3;
    else
      y2 = (SCR_Y/2)+(DLGHT/2)+1;

    this->expectinput=expectinput;
    frameptr = newwin( y2-y1, x2-x1, y1, x1 );
    box( frameptr, FRAME_CHAR_V, FRAME_CHAR_H );
    y1++; x1++; y2--; x2--;
    wptr=newwin( y2-y1, x2-x1, y1, x1 );

    //    hascolor = has_colors();
    hascolor=0;  // Because of repaint problems if color is set

    if ( hascolor )
    {
      start_color();
      init_pair( 1, COLOR_WHITE, COLOR_BLUE );
      wattron( wptr, COLOR_PAIR( 1 ) );
      touchwin( wptr );
    }      
    leaveok( wptr, FALSE );
    leaveok( frameptr, FALSE );
    shown=FALSE;
    settitle( title );
    cbreak();
    werase( wptr );

    // Write the title
    wmove( wptr, 0, ((x2-x1)/2)-(strlen(title)/2)-1 );
    waddstr( wptr, title );
    
    if (expectinput==TRUE)
    {
      // Write the OK and CANCEL buttons
      wmove( wptr, y2-y1-1, ((x2-x1)/2)-((x2-x1)/4)-(strlen(OK_TEXT)/2)-1 );
      waddstr( wptr, OK_TEXT );
      wmove( wptr, y2-y1-1, ((x2-x1)/2)+((x2-x1)/4)-(strlen(ESC_TEXT)/2)-1 );
      waddstr( wptr, ESC_TEXT );
    }

    // Write the inverted output line
    wmove( wptr, 2, 0 );
    wstandout( wptr );
    wclrtoeol( wptr );
    wmove( wptr, 2, 0 );
    show();
  }
  
  ~TMsgDlg()
  {
    shown = FALSE;
    delwin( wptr );
  }
  
  void show( void )
  { 
    if ( shown == FALSE )
    {
      shown=TRUE;
    }
    touchwin( frameptr ); 
    wrefresh( frameptr ); 
    touchwin( wptr ); 
    wrefresh( wptr ); 
  }
  
  void print( char *text )
  { 
    wmove( wptr, 2, 0 );
    wstandout( wptr );
    wclrtoeol( wptr );
    mvwaddstr( wptr, 2, 0, text ); 
    wclrtoeol( wptr ); 
    show(); 
  }
  
  // settitle()
  void settitle( char *title )
  {
    sprintf( this->title, "%s\n", title );
  }


  // Returns TRUE if user pressed OK, FALSE if CANCEL

  bool getinput( void )
  {
    int ch=0;
    keypad( wptr, TRUE );
    meta( wptr, TRUE );
    noecho();
      
    do
      ch = wgetch( wptr );
    while ( (ch != ESCAPE_CHAR) && (ch != 10 ) );
    
    if ( ch == ESCAPE_CHAR )
      return( FALSE );
    else
      return( TRUE );
  }
  
  WINDOW* getwptr( void )
  { return( wptr ); }
  
};


#endif


