/* globals.h  ---  Global definitions for nc 

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _globals_h
#define _globals_h

extern "C" {
#include <ncurses/ncurses.h>
}

#define VERSION "0.74 alpha"

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

#define USER_MAX 256     /* Max. length of user & group names */
#define GROUP_MAX 256

enum WHICH { LEFT, RIGHT };  // identity of file window
enum STATUS { NONE, MARK, INVALID }; // state of entries in TList
char homedir[PATH_MAX];     // Home directory of user
char localtmpdir[PATH_MAX]; // User subdirectory in /tmp
char EDITOR[PATH_MAX];      // The editor to use
int  SCR_X, SCR_Y;          // Initialized in inithome.cc
int  FNAME_LEN;             // Initialized in inithome.cc

#define DL debug2( __FILE__, __LINE__ );

void debug( char *s );
void debug2( char *s1, int i );
void inithome( void );

// Action script management
struct action_t
  {
  bool defined;      // Is this key defined ?
  char label[11];    // Key label
  char prefix;       // Meta- or Control-Key
  char key;          // Selection key (preceded by prefix)
  char script[PATH_MAX];   // Name of script to call
  int  doit;         // 1 = Execute script immediately,
                     // 0 = Wait for return key
  int  wait;         // 1 = Wait for key press after script
                     //         execution,
		     // 0 = Return to nc immediately
  int  needarg;      // 1 = prompt user for a string parameter,
                     // 0 = no extra parameter needed
  char arg[PATH_MAX];    // Argument got from user
  char prompt[PATH_MAX]; // String used to prompt user for arg
  int defaults;      // 1 = Supply a default value,
                     // 0 = no default value
  char params[3];    // Parameter passing code (see comment in KEYFILE)
  } action[256];

#endif








