/* lineedit.cc --- Misc. stuff for line editing  
   
   Copyright (C) 1994  A.Matthias
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#include <string.h>

extern "C" {
#include <ncurses/ncurses.h>
}
#include "globals.h"
#include "config.h"
#include "lineedit.h"


// wputline() puts userline to window wptr and creates a
// softcursor at position ulpos

void wputline( WINDOW* wptr, char* userline, int ulpos, DISPTYPE disptype )
{
  char tmp[PATH_MAX];
  strncpy( tmp, userline, ulpos );
  tmp[ulpos]='\0';
  wprintw( wptr, "%s", tmp );
  if ( disptype == NORMAL ) 
    wstandout( wptr );
  else
    wstandend( wptr );
  wprintw( wptr, "%c", userline[ulpos] );
  if ( disptype == NORMAL )
    wstandend( wptr );
  else 
    wstandout( wptr );
  if ( userline[ulpos]!='\0' )
    wprintw( wptr, "%s", &userline[ulpos+1] );
  
}

// strinsch() inserts the character ch into string str at position pos
// str must be a valid, null-terminated string. No checking is made
// on pos, the caller has to keep it within range
void strinsch( char *str, char ch, int pos )
{
  int len=strlen( str );
  for ( char* p=&str[len]; p!=&str[pos]; p-- )
    *p=*(p-1);
  str[pos]=(char)ch;
  str[len+1]='\0';
}

