.\" $nc.man,v 0.1 $
.TH  "NORTHERN COMMANDER" N
.SH NAME
nc \- Northern Commander for Linux
.SH SYNOPSIS
.B nc

.SH DESCRIPTION
The \fInc\fP program lets you view directories and files in
two separate windows, copy files between these windows and launch 
programs by selecting them with the cursor keys. 
You may even use \fInc\fP as a frontend to \fIftp\fP, since it
allows you to access remote directories on the Internet transparently.
It uses the \fIncurses\fP library for display and should be portable
to other Unix environments. 
.PP
To keep \fInc\fP small, many operations were implemented as shell
commands, which are executed via the \fIsystem()\fP system call. A \fIbash\fP
shell was used for testing, I don't know if \fIsh\fP works too, but perhaps
it will. Some (small) changes in the sources are necessary to make \fInc\fP 
work with shells other than \fIbash\fP and \fIsh\fP. 

.SH INVOKING
Type \fInc\fP. There are no command line options. 

.SH KEYS
\fIWarning\fP
The operations which are marked with (*) start background processes
that take some time to complete. Don't use any commands that need
the results of those operations until the background processes
terminate. 
.PP
\fIMovement\fP
.nf
Cursor up, Cursor down
Page up, Page down     : Move selection bar
Cursor left            : Go to first entry
Cursor right           : Go to last entry
TAB key                : Go to other window
.PP
\fIFiles and directories\fP
RETURN key             : (Bar on program)   Execute program
                       : (Bar on directory) Change directory
                       : (Command line)     Execute line
SPACE                  : Mark/Unmark highlighted entry
+                      : Mark files that match a shell pattern
-                      : Unmark files that match a pattern
ESC                    : Meta-key for menu selection
F1 or ESC 1            : Show this manpage
F2 or ESC 2            : not used
F3 or ESC 3            : View file under selection bar
F4 or ESC 4            : Edit file under selection bar
F5 or ESC 5            : Copy marked files
F6 or ESC 6            : Rename/Move marked files
F7 or ESC 7            : Make directory
F8 or ESC 8            : Delete file(s) (Undelete possible)
F9 or ESC 9            : Remove file(s) or empty directory
                         (for safety reasons you can't remove
                         non-empty directories - undelete not
                         possible)
F10 or ESC 0           : Quit nc
.PP
ESC C                  : Compile C/C++ program under selection bar
ESC L                  : Call LaTeX
ESC ESC                : Start program to process hilighted data
                         file (file type sensitive program launching)
.PP
Ctrl-X                 : Meta-key for other built-in commands
Ctrl-X-1               : Toggle executable only mode
                         An (E) appears in the summary line of
                         the file window if this is turned on
Ctrl-X-2               : Read in tree structure (*)
Ctrl-X-3               : View file under selection bar in hex format
Ctrl-X-0               : Show directory tree (not implemented yet!)
.PP
\fICommand line\fP
RETURN key             : Execute command line
BACKSPACE key          : Erase one character to the left
DELETE key             : Erase one character to the right
Ctrl-U                 : Delete the line
ESC RETURN             : Insert name under selection bar into
                         command line
ESC SPACE              : Insert a space into command line
                         (This is the only way to enter a leading space)
Cursor left            : Move soft cursor to the left
Cursor right           : Move soft cursor to the right
Ctrl-P                 : Previous history entry
Ctrl-N                 : Next history entry
Any other character    : Add this character to command line
@hostname              : Display a directory of host "hostname" in 
                         the active window
@                      : Close the connection to the remote host 
                         and return to the local file system
.PP
\fIDialog boxes\fP
RETURN                 : OK button
ESC                    : CANCEL button
Other special keys     : see the command line keys (above)
.ft
.fi

.SH BEHAVIOUR OF MULTIFUNCTION KEYS
Some keys, e.g. the cursor keys <right> and <left> have been assigned more 
than one function. When applied to the command line, they move the cursor 
to the right or left resp.; when applied to a file window, they move the
selection bar as described above. Which one of the assigned functions is
used, mostly depends on the length of the command line at the moment the
key is pressed. If there is a command line with some text in it, then
the key is applied to the command line. If the command line is empty, the
key is applied to the file window. That is, the command line has the input
focus if it contains some text already. Otherwise, the input focus is on
the file window.

.SH ENTERING ADDITIONAL PARAMETERS
If you already have invoked a command that prompts you for an additional
parameter (e.g. MakeDir) , you can abort it by typing <ESC> somewhere
in the input line for the parameter. You don't see any immediate reaction
but the command will not be executed when you leave the input line with
<RETURN>. 

.SH FAST CHANGE DIRECTORY
\fInc\fP implements a fast CD function, that is only available if you
have before built a tree file with Ctrl-X-2. The tree file must only be
built once every time you make major changes to your directory tree
structure. Invoke it by typing \fIncd\fP at the command prompt, followed
by a target directory specification, e.g. \fIncd X386\fP. \fIncd\fP
will search for the specified directory in the tree file and change to
it. You may also use the \fIncd\fP utility from the shell command line, 
but then you must begin the command with a period, e.g. \fI. ncd X386\fP.
If you forget the period, \fIncd\fP will be executed in a subshell and 
your working directory will not be changed. 
.PP
You may avoid typing the period before the ncd command, if you create
a shell alias for it. If you use BASH as a shell, type:
.PP
alias ncd='. ncd '
.PP
If you use TCSH, you may use this:
.PP
alias ncd 'cd `<path-to-ncds> \\!^`'
.PP
where <path-to-ncds> must be replaced by the full pathname of the ncds
command in the NC/Linux executables directory (the tcsh alias is from
Dietrich Schmidt).
.PP
In any case, \fIncd\fP will
print out the name of the directory it would change to. The period is
*not* necessary if you invoke \fIncd\fP from the \fInc\fP command line.
Do never rename \fIncd\fP, because \fInc\fP recognizes this command
by its name and executes it in a special way.

.SH DELETE AND UNDELETE
.PP
\fIThe undelete code was removed from version 0.6, because it had too
many bugs. It will be part of version 0.8 again.\fP
.PP
The \fInc\fP package provides a safe file delete command, \fIdel\fP, and
a command to restore deleted files, \fIundel\fP. Only files deleted 
with \fIdel\fP may be undeleted, files removed with \fIrm\fP are lost
forever. \fIdel\fP does not really remove files, it only copies them 
in a compressed format to a special directory. The directory name can
be specified in "config.h", default is /tmp/ncdel.$(UID), so each user
has his or her own directory with deleted files. The maximum size of this
directory can be specified in "config.h" (#define DELMAX). The default is
500k bytes, but since the files are stored in a compressed format you 
can undelete more than that, perhaps twice the value of DELMAX. This,
of course, depends on your compressing program (default is \fIgzip\fP)
and the deleted files.
.PP
Files can be deleted with the command "del <expr>", where <expr> can
be a filename, a list of files, or an expression that the shell can 
expand to filenames. \fIdel\fP checks the files to be deleted and will
ignore device special files and directory names. It is unclear what will
happen if you try to delete links to files (be careful with links).
Of course, \fIdel\fP is much slower than \fIrm\fP, because of the
compression performed. You can speed \fIdel\fP up by specifying a faster
compression program in "config.h" or a dummy program (it is not possible
to leave the ZIPCMD and UNZIPCMD entries blank) if you don't want any
compression. \fIdel\fP first checks the free space in the undelete
directory and removes the oldest deleted files found, if there is not 
enough space to store the specified files. If one single file you try
to delete is (compressed) bigger than DELMAX, you get an error message
and can choose to skip it or to remove it forever. 
If you delete files with the same name, the older file
will be overwritten, even if there is enough free space to hold them both.
The \fIdel\fP command
is a stand-alone program, you can call it from the shell, from the built-in
\fInc\fP command line or with an action key (default is ESC-8). The real 
\fIrm\fP can be called with the default ESC-9, which does not appear in
the bottom label line.
.PP
Deleted files may be undeleted with \fIundel\fP, which is also a 
stand-alone program. There is no default action key for this one. If
\fIundel\fP is called without any parameters, it prints the names of
all the files that can be undeleted. You can also call \fIundel\fP with
an <expr> parameter, where <expr> is an "ls"-compatible pattern containing
wildcards. These wildcards are processed directly by \fIundel\fP. Since
\fIdel\fP stores only the files without full path information, \fIundel\fP
will always put undeleted files into the current working directory.
Undeleted files are \fInot\fP removed from the deleted files directory, so
that they can be undeleted more than once (perhaps into different target
directories). If you have deleted more than one file with the same name,
\fIundel\fP will report that it can undelete more than one file with
the same name, but this is not possible (this is a bug in the \fIundel\fP
output). It will always undelete the last deleted file with a given name.
Since \fIundel\fP doesn't remove the deleted files, your directory of
deleted files will always contain files with a total size near DELMAX. If
you run into space problems on the filesystem where this directory resides,
you may remove the compressed files by hand (using \fIrm\fP). To avoid
wrong reports from \fIundel\fP, delete also the \fIundel\fP information
file in your home directory (\fI.nc.undel\fP by default, see "config.h").
.PP
\fISecurity considerations\fP
.PP
\fIdel\fP deletes files into a directory it creates using your default
permissions mask. Thus, if the created subdirectory in /tmp is created
world-readable, everyone will be able to read at least the names
of the deleted files. File permissions are preserved, anyway. There is
no need for the directory of the deleted files to be world-readable, so
you can change the permissions by hand if you like. Another thing you might
want to consider, is the fact, that most systems clean the /tmp directory
up sometimes and your deleted files will then be lost forever. You may
change the directory where deleted files will be stored by editing
"config.h" (#define DELBASEDIR).   

.SH ACCESSING REMOTE DIRECTORIES
With \fInc\fP you can access directories on remote hosts in the
same way you access files and directories on your local machine.
.PP
To establish a connection to a remote system, you MUST have an
entry for this system in your \fI~/.netrc\fP file. \fInc\fP uses
\fIftp\fP to perform remote file operations, but it can't currently
deal with the way \fIftp\fP prompts the user for a password.
\fInc\fP will terminate or hang (at its option) if you try to
access a system that is not listed in your .netrc file. You should
also try to type the host name correctly, because the "unknown host"
message from ftp is currently not intercepted and terminates \fInc\fP.
.PP
You can display a directory of a remote host in your active file
window by typing
.PP
.nf

@hostname , e.g.

@ftp.gwdg.de

.ft
.fi

at the command line. \fInc\fP will invoke ftp and try to connect to
the specified host. This can take a while. If your name and password
are set correctly in .netrc, you will see a directory listing of the
remote host in the same format that is used for the local display
too. You may now use the usual keys to navigate through the remote
file system. Note that part of the hostname is shown in the bottom
line of each file window. If you are not connected to a remote host,
this entry will read "[local]".
.PP
To close a connection and return to local operation, type '@' followed
by <RETURN> at the command line. The connection is really closed in
this case to save your money, but this also means that all information
about your current directory and settings at the remote host are lost
if you close the connection.
.PP
It is currently *NOT* possible to use the command line as a remote 
command line. Even when you are connected to a remote host, the
command line will still talk to your local shell, but you may
use the \fInc\fP predefined action keys to perform remote operations.
In future versions, the command line will be connected to the remote
host, too (perhaps via telnet).
.PP
\fIPossible errors:\fP
.PP
You will get a message saying "writedir: Unexpected ftp output", if you
forget to list the host you are trying to connect to in your .netrc
file. It is currently *not* possible to connect to hosts not listed
in ~/.netrc. If this happens, it is better to terminate \fInc\fP and
restart it again, to avoid having an ftp process hanging around 
somewhere in the background.
.PP
If you try to connect to a host that is listed in .netrc, but 
\fInc\fP beeps and returns you to your local file window without
any error message, then ftp can't connect to that host. The reason 
could be an unknown hostname, an unreachable network, a wrong password
or something like that. Try to connect to that host by launching ftp 
from the command line to see what really goes wrong. Currently
only the beep informs you that there was an error, no ftp error
messages are passed through the \fInc\fP interface.

.SH CUSTOMIZING THE COMMAND LINE PROMPT
The prompt shown in the command line is built using the $PS1 variable.
However, some prompts will not work as expected. Since $PS1 is evaluated
in a subshell not attached to a specific tty, you will see the string
"not a tty" in your prompt if $PS1 includes a call to \fItty\fP. Perhaps
there are other settings that don't work, too. 
.PP
\fINote:\fP You will get an error message, if the file \fI.nc.getps1\fP is
not found in your home directory. This file is needed for prompt 
evaluation.

.SH CUSTOMIZING THE ACTIONS MENU
In the present version, nearly all <ESC>-key combinations can be redefined 
to call
custom shell scripts. The Ctrl-X combinations and the <ESC><digit> 
combinations (where <digit> is a character between 0 and 9) are real 
built-ins and can't be redefined.
The redefinition concept used is very flexible, and I hope you will like it.
Redefinition is done in the \fI.nc_keys\fP file, see also the comment in that
file. The file \fI.nc_keys\fP is a fixed-format file, and must be edited very
carefully, because no error checking is performed.
\fI.nc_keys\fP consists of text lines, one line for each defined key. 
Each
line has 10 fields of various data types. All fields must be filled out, empty
fields and embedded separators are not possible. Field separators are those
characters that your C++ compiler recognizes as separators for the ">>"-
operator of ifstream. 
All field entries must be typed *without* quotes (''). I will use quotes 
in this manpage to talk about the entries, but you may not enter them. 
.PP
\fIComments\fP
.PP
Comments start and end with the "#"-sign. They can include multiple lines,
but they must begin and end in lines not otherwise used. Embedded comments
are not possible.
.PP
\fIFields\fP
.PP
Each line has the format:
.PP
\fIPrefix Key Label Path doit wait needarg Prompt default param\fP
.PP
\fIPrefix\fP stands for the control key that precedes the action key.
In the present version, only 'M' is recognized for the <ESC> key. 
.PP
\fIKey\fP is the key the user must press after the prefix key to select
an action. Every one-character-value is possible. Case is significant.
You may also enter the character code as a DECIMAL number preceded by
"$". Thus, A and $65 are the same. "$$" represents "$".
.PP
\fILabel\fP. This entry is only meaningful, if \fIKey\fP has a value
between '1' and '8'. In this case, it is the label text printed at the
bottom screen line of \fInc\fP for the corresponding numerical key. You
must assign some label for the other keys too, but it will never be 
printed. I suggest you use 'Nothing' for those other key labels. Don't
forget that all labels must fit in one screen line, so don't make them too
long. Too short bottom lines will be left-aligned.
.PP
\fIPath\fP. This is the name of the shell script file to execute when the
action key is selected. Names are relative to the current working
directory, therefore you must use absolute pathnames. Shell variables
are allowed, e.g. '$HOME/nc/script.nc'. I suggest using the extension
".nc" to avoid confusion. Standard scripts for the predefined actions
are supplied.
.PP
\fIdoit\fP is a numerical flag, that can take only two values, 0 and 1.
If this flag is set to 0, \fInc\fP will print the corresponding command
to its command line and wait for the user to possibly edit it and press
<RETURN>. If this flag is set to 1, the command will be executed 
immediately and the user will not see it in the command line.
.PP
\fIwait\fP is also a numerical flag. If it is set to 1, \fInc\fP will wait
after the command has been executed, and will prompt the user to press
a key to return to the window interface. If this flag is set to 0, \fInc\fP
will return immediately. Use this flag when the script produces screen
output that the user must be given some time to read before the screen is
cleared. If the script uses 'less' or some other pager that waits for a
keypress, this flag can be set to 0.
.PP
\fIneedarg\fP can also take the values 0 and 1. If it is 0, the script
will be executed immediately with only the information contained in 
\fInc\fP's file window. If the script needs additional information, set
this flag to 1 and \fInc\fP will prompt the user to enter a string that
will be passed to the script in addition to the information in the file
window. This is for example needed for the actions 'Copy' (the destination),
or 'MkDir' (the name of the directory to create).
.PP
\fIPrompt\fP. This is the prompt string that \fInc\fP prints out when
asking the user to enter an additional parameter (see \fIneedarg\fP).
The string may be only *one* word, but you can use underscores to simulate
spaces. Every character that is not a field separator may be used. Use
"Nothing" if you don't want a prompt string.
.PP
\fIdefault\fP is a flag with two values, 1 and 0. If it is set to 1,
\fInc\fP will supply the name of the current working directory of the 
currently *not* active window as a default value when prompting the user.
This is good if you implement a 'Copy' script, because the user can 
choose the target directory using the \fInc\fP navigating tools and he
has not to type in the entire target directory name as text. Default
values are presented in brackets to the user, he may still enter something
else on the input line and overwrite the default value. If this flag is
set to 0, the default will be an empty string.
.PP
\fIparam\fP is a two-character string that controls parameter passing
to the action script. Information is passed to the action script in a
file (PARAMFILE, see \fIconfig.h\fP), that contains only one line, with
filenames separated by spaces. Your script receives as $1 the name
of the parameter file. With this string you control which filenames
are passed to your script. There is no limit to the length of the parameter
passing file. The string must always have *two* characters. Their meaning
is:

.nf
m0 = The marked files (*) of the active file window
h0 = The filename under the active selection bar (the 
     hilighted file)
u0 = All but the marked files (the "unmarked" files)
p0 = Only the additional parameter is passed 
     (if \fIneedarg\fP==1)

All of the above are contained in the file named in $1

m1
h1
u1 = As m, h, u above, but the additional parameter 
     is passed as $1 before the name of the parameter 
     file, which is $2
m2
h2
u2 = As m, h, u above, but the additional parameter 
     is passed as $2 after the name of the parameter 
     file which is $1
n0 = No parameter passing
.ft
.fi

.SH Notice
The codes m0, m- and m+ return the HILIGHTED (!) filename if no 
filename is marked. They do *not* return the hilighted filename, 
if there are marked filenames. This is also the standard 
behaviour of the original NC.
.PP
For examples look at the predefined scripts.

.SH FILE TYPE SENSITIVE PROGRAM LAUNCHING
\fIftspl.nc\fP implements a file type sensitive program launching,
that is, you hilight a data file and press the action key for ftspl.nc
(ESC-ESC by default). The script tries to determine the type of the
hilighted file and launches a program that can process this type of file.
File type evaluation is done with the utility \fIfile\fP. Look at ftspl.nc
for details. You may extend ftspl.nc to handle other file types as well.

.SH CHANGING DIRECTORIES IN ACTION SCRIPTS
If your script needs to change the working directory and you want \fInc\fP
to display the contents of this directory after return from your script, you
must overwrite the file \fICWDFILE\fP (see config.h for the real name) with
the full name of the new working directory. \fInc\fP will read in this file
and change the directory of the active window to the directory named in this
file.

.SH TEMPORARY FILES
\fInc\fP creates some temporary files in $HOME when running. All temporary
file names that \fInc\fP creates begin with \fI.nc\fP.
Do not delete or edit those files, or \fInc\fP will crash. These files
are deleted when you exit \fInc\fP.

.SH FILESYSTEMS WITH LONG FILENAMES
The file windows are designed for an 80x25 screen and can only display
the first 14 characters of a filename. For processing, the entire 
filename is used, so this discussion applies only to the visual information
given in the file window. If you want to see the entire filename under 
the selection bar, you may set the #define LONGNAMES in \fIconfig.h\fP to
1. An additional text line will appear under the file window and it will
always display the full name of the hilighted file and other information. 
Unfortunately, this option costs some scrolling performance. 
Truncated long filenames are
marked in the file window with a '>' sign, so you always know that the 
name was truncated, even if you don't turn this option on.

.SH HIGH SCREEN RESOLUTIONS
If you want to use NC/Linux with screen resolutions other than 80x25, you
must define the environment variables LINES and COLS. E.g. if you want
to use NC/Linux with a 100x40 resolution on the Linux console, you should
put the following two lines into your .profile (when using bash as a shell):
.PP
export LINES=40
.br
export COLS=100

.SH THE HEX VIEWER
With \fInc\fP there comes a simple hexdump viewing utility \fIhex\fP.
It is used when you press the hex-viewing action key (see above), but
it can also be used as a standalone program in your customized scripts.
It takes the filename to view as the first parameter and optionally the
offset (where to start displaying) as a second parameter. It writes to
the standard output and is best used in a pipe with 'less' or another
pager.

.SH COMPILING NC
See the file \fIREADME\fP for information on building \fInc\fP.

.SH PORTING TO OTHER SHELLS
Some parts of the \fInc\fP source code must be changed to adapt it to
shells other than \fIbash\fP. First, you must rewrite the *.nc action
scripts. Then, look into \fIconfig.h\fP for changes. And at last, edit
\fInc.cc\fP, and look for string constants near the \fIsystem()\fP 
calls. There are some helpful comments in that code. No other source
files should be affected. Good luck ;-)

.SH BUG REPORTS
Send bug reports to the addresses listed in the "Support" section of this 
manpage. 
Please include the exact
version number (shown at startup) and a description of how to reproduce
the bug. You may also send bug fixes :-) but make them readable for a
human, please, and describe clearly what you are doing. The code still
changes every day, so the error maybe has already been corrected when 
your mail arrives and I must be able to understand what exactly you are 
fixing and how.

.SH NEW FEATURES
If you have extended \fInc\fP in some way, please let me know, so we
don't do things twice. Try to keep changes local and document everything
so that I can incorporate your code into the program. If you have written
clever shellscripts, please send them also and I will distribute them
along with the program.

.SH SUPPORT CONCEPT
I'm trying to set up some kind of online support. For general questions,
bug reports, and nearly everything else that relates directly to the program
please use the internet mail address
.PP
nc@gwdp88.gwdg.de (nc)
.PP
exactly as shown here.
Please use the following UPPERCASE words in the SUBJECT of your mail to make 
processing easier and to get a faster response. You may include additional 
text into the subject line too, but make sure the keywords appear in it.
Please include only one of those keywords in the subject of a mail. If
you have both a help request and a fix, you will have to write two separate
mails.

.nf
HELP         for general help request
BUG          for a bug report
FIX          for a fix you send me
SENDALL      if you want the entire nc package to be sent
             to you by email
SENDFIX      if you want the latest fixes to be sent to 
             you by email
SENDFAQ      if you want the latest FAQ to be sent to you 
             by email
SENDNEWS     if you want the latest product info and 
             announcements to be sent to you by email
OTHER        for everything else
.ft
.fi

All mails except the ones with a SEND* keyword in the subject will be
read by a human (me), the SEND* requests will be processed only by some
shell scripts, so don't bother writing text into them.
.PP
For topics that don't relate directly to the program (your opinions, 
ideas for future versions, flames) please use my personal addresses that 
are listed at the end of this manpage (section "Author").
.PP
There will also be some kind of \fItelnet\fP-based support interface
that will be announced later through the above described mail channels
and in comp.os.linux.announce.

.SH BUGS AND LIMITATIONS
\fInc\fP is still under development and not finished yet. Some of the
following will be changed soon.
.PP
o It is not possible to suspend processes that were invoked from within \fInc\fP. If you suspend them, they will be terminated instead, because \fInc\fP executes each process in a separate subshell which terminates when the process terminates. This will change in the future.
.PP
o  \fInc\fP is very slow when it initially reads in directories with many files. This is a tradeoff between initial read-in speed and scrolling performance. I choose to put all files into a list when the user changes directories, so that the scrolling speed remains constant. 
.PP
o  The original ALT-key combinations must be entered as Ctrl-X-<key>, because the ALT-key is not portable across different terminals. This will stay like that for a while, because those Ctrl-X-combinations are not used very often.
.PP
o There is still a mysterious bug with some vt100 emulations which don't accept the cursor keys as \fInc\fP would like to use them. On such terminals you won't be able to use the cursor keys at all. I'm not sure if this is a terminfo problem or something with the quality of the emulation, but I'm working on it.
.PP
o  \fInc\fP does not support a configuration file yet, all configuration must be done by editing config.h and recompiling. Exceptions see above.
.PP
o  It does not react correctly to a suspend command (ctrl-z). The terminal will behave unnormally and hang if you suspend \fInc\fP (this one is a curses feature). I am trying to get NCURSES to behave better, but I had no time yet to fix the problem.
.PP
o \fInc\fP works really fine only directly at the text mode Linux console. You can use it in X terminal windows too, but I don't know of any emulation that supports everything the console does. I tested the program under \fIshelltool\fP (which needs a "sun" terminfo entry), \fIxterm\fP (which is very slow and has the same scrolling problems that slow serial links have, see above) and \fIrxvt\fP (which works best when used with a vt100 terminfo entry). NEVER TRY TO RUN NC WITH A WRONG $TERM VARIABLE SETTING. It will do nonsense on the screen and it will sometimes confuse the terminal you are using so badly, that you will have to reset it. A common mistake is the use of a TERM=vt100 setting at the Linux console (which should be TERM=console). This was necessary for previous versions of \fInc\fP, but is fatal with this version since it really confuses the Linux console driver (the cursor keys don't work as expected any more). If this happens to you, you must open a new virtual console and better forget about the damaged one until you reboot the system. I will try to explore this behaviour soon.
.PP
o  Only some of the the most important "N***** Commander" features are included. If you want a specific feature included, drop me a mail.

.SH THANKS
To Eberhard Moenkeberg and Karl Eichwalder for great assistance and alpha testing
.PP
To Zeyd M. Ben-Halim, the author of \fIncurses\fP.
.PP
To Rolf Krahl for work on the ftp code and new ideas on various topics.
.PP
To Brian Norman Silverman for telling me how to access pty's and other ideas.
.PP
To Guus Jansen and Andy van Esch for fixing problems with NC and Slackware 1.1.2
.PP
To Dietrich Schmidt for bug reporting and the tcsh alias
.PP
To all users of the previous versions for their patience.

.SH COPYRIGHT
Copyright 1993, 1994 by Andreas Matthias.
.br
See the GNU GPL for a full statement of rights and permissions.
.SH AUTHOR
Andreas Matthias,
.br 
amatthi1@gwdg.de, andreas_matthias@rollo.central.de, 2:2437/210.43 fidonet

