/* ncds.cc  ---  Northern Change Directory 

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


 #include <fstream.h>
 #include <string.h>
 #include <sys/stat.h>
 #include <stdlib.h>
 #include <unistd.h>
 #include "globals.h"
 #include "config.h"
 #define NCD_VERSION "0.1 alpha"

 int main( int argc, char *argv[] )
   { 
   struct stat sbuf;
   char ftree_name[PATH_MAX], olddir[PATH_MAX], newdir[PATH_MAX];
   FILE *ftree;
   char cwd[PATH_MAX], cmd[PATH_MAX], compare[PATH_MAX];
   char *bptr, *found;
   bool cwdfound;

   if ( argc != 2 )
     {
     fprintf( stderr, "ncd version %s (C) 1993 by A.Matthias\n\n", 
              NCD_VERSION );
     fprintf( stderr, "Usage: %s <target directory>\n\n", argv[0] );
     exit( 1 );
     }

   inithome();

   sprintf( ftree_name, "%s%s", homedir, TREEFILE );
   if ( stat( ftree_name, &sbuf ) == -1 )
     {
     fprintf( stderr, "ncd version %s (C) 1993 by A.Matthias\n\n", 
              NCD_VERSION );
     fprintf( stderr, "Tree file %s not found. Please create it using nc\n",
	      ftree_name );
     exit( 1 );
     }

   char buffer[sbuf.st_size+256];  // Just to be sure
   if ( ( ftree=fopen( ftree_name, "r" ) ) == NULL )
     {
     fprintf( stderr, "Could not open tree file.\n" );
     exit( 1 );    
     }
  
  fread( buffer, sbuf.st_size, 1, ftree );
  buffer[sbuf.st_size]='\0';
  
  sprintf( olddir, "/%s/", argv[1] );
  getwd( cwd );          // Get current working directory
  
  strcpy( newdir, "" );  
  cwdfound = FALSE;
  bptr = strtok( buffer, "\n" );
  
  do
    {
    sprintf( compare, "%s/", bptr );

    // Accept only the first hit after the cwd
    if ( ( (found=strstr( compare, olddir )) != NULL ) &&
         ( strcmp( newdir, "" ) == 0) && 
         ( cwdfound == TRUE ) )
      {
      *(found+strlen( olddir )-1) = '\0';
      if ( strcmp( compare, cwd ) != 0 )
        strcpy( newdir, compare );
      }

    if ( strcmp( bptr, cwd ) == 0 )
      cwdfound = TRUE;

    bptr = strtok( NULL, "\n" );      
    }
  while ( ( bptr != NULL ) && ( strcmp( newdir, "" ) == 0 ) );

  // Test for a hit so far
  if ( strcmp( newdir, "" ) != 0 )
    {
    sprintf( cmd, "echo %s >%s%s", newdir, localtmpdir, CWDFILE );
    system( cmd );
    // Print it and exit
    printf( "%s\n", newdir );
    return 0; 
    }

  // If we are here, we had no hit after cwd, so search again from
  // the beginning

  fseek( ftree, 0, SEEK_SET );
  fread( buffer, sbuf.st_size, 1, ftree );
  fclose( ftree );
  buffer[sbuf.st_size]='\0';
  bptr = strtok( buffer, "\n" );
  
  do
    {
    sprintf( compare, "%s/", bptr );

    // Accept the first hit that is not the cwd
    if ( ( (found=strstr( compare, olddir )) != NULL ) &&
           ( strcmp( newdir, "" ) == 0) )
      {
      *(found+strlen( olddir )-1) = '\0';
      if ( strcmp( compare, cwd ) != 0 )
        strcpy( newdir, compare );
      }

    bptr = strtok( NULL, "\n" );      
    }
  while ( ( bptr != NULL ) && ( strcmp( newdir, "" ) == 0 ) );

  // Test again for a hit
  if ( strcmp( newdir, "" ) != 0 )
    {
    sprintf( cmd, "echo %s >%s%s", newdir, localtmpdir, CWDFILE );
    system( cmd );
    // Print it and exit
    printf( "%s\n", newdir );
    return 0; 
    }
  

  // If we have still no hit, lets exit into cwd
  printf( "%s\n", cwd );
  return 0;
  }  
