
#include <stdio.h>
#include <unistd.h>

#define READ 0
#define WRITE 1
#define ENDSIGN "-end-\n"

int cftp[2], ftpc[2];

int dgets( int fd, char *buf, int maxsize /* maxsize >= 1 */ )
{
char c = '\0';
int i = 0;

while ( ( c != '\n') && ( i < maxsize - 1 ) )
  {
  read( fd, &c, 1 );
  buf[i] = c;
  i++;
  }

buf[i] = '\0';

return i;
}

int dputs( int fd, const char *buf )
{
  int i;

  i = write( fd, buf, strlen( buf ) );
  write( fd, "\n", 1 );

  return ( i >= 0 ) ? i + 1 : i;
}

void ftpcmd ( int rfd, int wfd, const char *cmd, char *buf, int maxsize )
{
  char echocmd[256];
  char *p;
  int i = 0;

  sprintf( echocmd, "!echo %s", ENDSIGN );
  dputs( wfd, cmd );
  dputs( wfd, echocmd );

  do
  {
    p = &buf[i];
    i += dgets( rfd, p, maxsize - i );
  } while ( (strcmp( p, ENDSIGN )) && (i < maxsize-1 /* ERROR ! */) );
  
  *p = '\0';   /* Removes ENDSIGN from buf */
}

void ftpopen( char *hostname )
{
pipe( cftp );
pipe( ftpc );

if ( fork() == 0 )  /* ftp */
  {
  close( cftp[WRITE] );
  dup2( cftp[READ], 0 );
  close( cftp[READ] );

  close( ftpc[READ] );
  dup2( ftpc[WRITE], 1 );
  close( ftpc[WRITE] );
  execlp( "ftp", "ftp", "-", "-v", hostname, NULL );
  fprintf( stderr, "ftp died\n" );
  exit( 1 );
  }
else
  {
  close( cftp[READ] );
  close( ftpc[WRITE] );
  }
return;

}


int main ( int argc, char *argv[] )
{
char buf[1024];

ftpopen( "titan" );
ftpcmd( ftpc[READ], cftp[WRITE], "", buf, sizeof( buf ) );
puts( buf );

ftpcmd( ftpc[READ], cftp[WRITE], "ls -la", buf, sizeof( buf ) );
puts( buf );

ftpcmd( ftpc[READ], cftp[WRITE], "bye", buf, sizeof( buf ) );
puts( buf );

return 0;
}
