/* undel.cc  ---  Undeletes files previously deleted with "delete"

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <fstream.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdio.h>
#include "globals.h"
#include "config.h"

#define UNDEL_VERSION "0.2 alpha"

long getused( char *where );

char ddname[PATH_MAX];  // name of directory with deleted files
long newsize, ddsize;   // size of files to delete, size of already deleted
                        // files


int main( int argc, char *argv[] )
  {
  struct stat sbuf;
  char cmdline[PATH_MAX];
  char zipname[PATH_MAX];
  char tmp[PATH_MAX], entry[PATH_MAX], newname[PATH_MAX];

  inithome();

  if ( argc == 1 )     // Print list of deleted files
    {
    sprintf( tmp, "%s%s", homedir, UNDELFILE );
    ifstream f( tmp );
    printf( "\nFiles that can be undeleted:\n\n" );
    while ( f )
      {
      f.getline( entry, PATH_MAX, '\n' );
      printf( "%s\n", entry );
      }
    f.close();
    return 0;
    }

  // Look for deleted files directory

  sprintf( ddname, DELDIR, DELBASEDIR, getuid() );
  if ( stat( ddname, &sbuf ) == -1 )
    {
    fprintf( stderr, "Undelete directory seems to have disappeared.\n" );
    fprintf( stderr, "Exiting.\n" );
    // Remove the undelete file if it is still there
    sprintf( cmdline, "rm %s%s > /dev/null", homedir, UNDELFILE );
    system( cmdline );
    return( 1 );
    }
  
  for ( int i=1; i<argc; i++ )
    {
    // Build the real name of the deleted file
    sprintf( zipname, "%s%s", argv[i], ZIPEXT );
    // This could contain wildcards, so we must process it with "ls"
    sprintf( cmdline, "ls %s%s >%s%s", ddname, zipname, homedir, TMPFILE );
    system( cmdline );
    // Now we have a list of files to undelete (path included)
    sprintf( tmp, "%s%s", homedir, TMPFILE );
    ifstream f( tmp );
    while ( f )
      {
      f.getline( entry, PATH_MAX, '\n' );
      if ( f )
	{
        // Build the final file name by stripping ZIPEXT and path away
        strcpy( newname, &entry[strlen(ddname)] );
        newname[strlen( newname )-strlen( ZIPEXT )] = '\0';
       
        printf( "Restoring: %s\n", newname );
        sprintf( cmdline, "cp %s %s%s", entry, newname, ZIPEXT );
        system( cmdline );
	sprintf( cmdline, "%s %s%s", UNZIPCMD, newname, ZIPEXT );
	system( cmdline );
	}
      }

    f.close();
    sprintf( cmdline, "rm %s%s", homedir, TMPFILE );
    system( cmdline );
    }    
  }


