#include "config.h"
#include <stdio.h>
#include <string.h>

#ifdef VMS
#include <stat.h>
#else
#include <sys/types.h>
#include <sys/stat.h>
#endif

#ifndef NO_STDLIB_H
#include <stdlib.h>
#endif

#include "most.h"
#include "window.h"
#include "file.h"  
#include "display.h"  
#include "line.h"
#include "keym.h"
#include "sysdep.h"

/* Dan's hack... */
#define help_file	NULL

/* This section provided by Mats Akerberg (mats@efd.lth.se) */
  
static char *help[] = {
"Quitting:",
"  Q                      Quit MOST.",
"  :N,:n                  Quit this file and view next. ",
"                            (Use UP/DOWN arrow keys to select next file.)",
"Movement:",
"  SPACE, D              *Scroll down one Screen.",
"  U, DELETE             *Scroll Up one screen.",
"  RETURN, DOWN          *Move Down one line.",
"  UP                    *Move Up one line.",
"  T                      Goto Top of File.",
"  B                      Goto Bottom of file.",
"  RIGHT, TAB             Scroll Window right",
"  LEFT, <                Scroll Window left",
"  J, G                   Goto line.",
"  %                      Goto percent.",
"Window Commands:",
"  Ctrl-X 2, Ctrl-W 2     Split window.",
"  Ctrl-X 1, Ctrl-W 1     Make only one window.",
"  O, Ctrl-X O            Move to other window.",
"  Ctrl-X 0               Delete Window.",
"Searching:",
"  S, F,f,/              *Search forward",
"  ?                     *Search Backward",
"  N                     *Find next in current search direction.",
"Miscellaneous:",
"  W                      Toggle width between 80 and 132 char mode.",
"  Ctrl-X Ctrl-F          Read a file from disk",
"  R, Ctrl-R              Redraw Screen.",
"  :o                     Toggle options:  b-binary, w-wrap, t-tab",
"  E                      Edit file.  Uses MOST_EDITOR and EDITOR",
"                           environment variables.",
"*Note:  This command may be repeated `n' times By entering a number then",
"        the command key, e.g.,  '5 SPACE' moves 5 screens forward.",
NULL };

static void most_do_help_text (void)
{
   int i;
   char *beg, *end;
   char line[132];
   char attr[132];
   char **p = help, *sect = NULL;
   
   most_set_scroll_region(1,Most_Screen_Height);
   
   while (1)
     {	
	most_cls();
	i = 1;
	if (*p == NULL) break;
	
	if ((sect != NULL) && (**p == ' '))
	  {
	     most_tt_bold_video ();
	     most_send_string_to_term (sect);
	     most_tt_normal_video ();
	     most_send_string_to_term (" (continued)\n\n");
	     i += 2;
	  }
	else sect = NULL;
	
	while(i < Most_Screen_Height - 2)
	  {
	     if (*p == NULL) break;
	     beg = *p;
	     end = *p + strlen (*p);
	     most_analyse_line((unsigned char *) beg, (unsigned char *) end, line, attr);
	     if (**p != ' ') 
	       {
		  if (((i + 5) > Most_Screen_Height)
		      && (**p != '*'))
		    {
		       sect = NULL;
		       break;
		    }
		  
		  if (sect != NULL) 
		    {
		       most_tt_putchar('\n');
		       i++;
		    }
		  if (**p != '*')
		    {
		       sect = *p;
		       most_tt_bold_video ();
		    }
		  else sect = NULL;
	       }
	     
	     most_output ((unsigned char *) line, end - beg, (unsigned char *) attr,'$');
	     if ((**p != ' ') && (**p != '*'))
	       {
		  most_tt_normal_video ();
		  most_tt_putchar('\n');
		  i++;
	       }
	     most_tt_putchar('\n');
	     i++;
	     p++;
	  }
	
	most_tt_putchar('\n');
	most_tt_reverse_video();
	most_send_string_to_term("Press any key to continue.");
	most_tt_normal_video();
	most_getkey ();
	
	if (*p == NULL)
	  {
	     most_redraw_display();
	     return;
	  }
     }
}

static void most_do_help_file (char *helpfile)
{
   char *buf_name;

   buf_name = "*help*";
#ifdef MOST_HELPFILE
   if (help_file == NULL) helpfile = MOST_HELPFILE;
#endif
    if (helpfile == NULL)
      {
	 static char tempname[MAX_PATHLEN];     /* L_tmpnam */
	 struct stat statb;

	 most_head(Most_Program, tempname);
	 strcat(tempname, "most.doc");
	 if (0 == stat(tempname, &statb))
	   {
	      helpfile = tempname;
	   }
      }

   if (helpfile != NULL)
     {
	if (most_file_visible(buf_name)) return;
	if (!most_split_window())
	  {
	     most_message("Two many windows.",1);
	     return;
	  }
	most_update_status(1);  /* create status line of prev. window */
	most_other_window(1);
	(void) most_find_file(helpfile);
	strcpy(Most_Buf->file, buf_name);
	most_window_buffer ();
	most_redraw_window ();
	most_update_status (1);
     }
   else
     {
	most_message("You must set the environment variable 'MOST_HELP' to point to the help file.",1);
     }
}       


void most_do_help_command(void) 
{
   char *helpfile = getenv("MOST_HELP");
   
#if defined(MOST_HELPFILE)
   most_do_help_file (helpfile);
#else
   if (helpfile != NULL) most_do_help_file (helpfile);
   else most_do_help_text();
#endif
}


