/* Sample C code the demonstrate the use of the following locale message
   catalog functions: setlocale(); catopen(); catgets(); and catclose();
   and also allows the use of descriptive names when referring to messages
   and message sets.

   This third example demonstrates the use of a macro package which can be
   used when the same source code has to support multiple platforms -
   platforms that support locale message catalogs and those that do not.

   Written by Patrick D'Cruze (pdcruze@orac.iinet.com.au)
   Copyright (C) 1994 Patrick D'Cruze

   This code is licensed under the terms of thw GPL.  */


#include <stdio.h>
#include "messages_macros.h"

#ifdef NLS
#include "foobar-nls.h"
#endif


main()
{
	int temp_num = 5;

	/* initialise the message catalog.  ie, call the setlocale()
	   routine and open the catalog.                            */
	NLS_CATINIT;

	/* We're now free to start accessing the message catalog */
	printf( NLS_CATGETS( catfd, foobarSet, foobarOnly_if_NLS,
		"Display this message if NLS support hasn't been compiled in\n"));

	printf( NLS_CATGETS( catfd, foobarSet, foobarInteger_statement,
		"Display this integer directive example if no NLS .. %d\n"), temp_num);

	/* The program is about to end.  Close the catalog and free the
	   memory.                                                       */
	NLS_CATCLOSE(catfd);
	return(0);
}

