/* Common includes and macros for Message Catalog Support
   Copyright (C) 1994 Patrick D'Cruze

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Patrick D'Cruze <pdcruze@iinet.com.au>. */

/* These macros uses the define -DNLS to determine whether to include
   support for the message catalog routines or not.  */


#ifdef NLS
#include <locale.h>
#include <nl_types.h>

extern nl_catd catfd;
void catinit ();
#endif


/* Define Macros used */

#ifdef NLS
#define NLS_CATCLOSE(catfd) catclose (catfd);
#define NLS_CATINIT catinit ();
#define NLS_CATGETS(catfd, arg1, arg2, fmt) \
    catgets ((catfd), (arg1), (arg2), (fmt))
#else
#define NLS_CATCLOSE(catfd) /* empty */
#define NLS_CATINIT /* empty */
#define NLS_CATGETS(catfd, arg1, arg2, fmt) fmt
#endif

