#include <stdio.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/vt.h>
#include <sys/kd.h>
#include <signal.h>
#include <termios.h>
#include <string.h>
#include "chinese.h"
#include "input.h"
#include "portable.h"
#define SIGREL SIGUSR1
#define SIGACQ SIGUSR2
static struct winsize size;
static struct termios save_termios;
static struct vt_mode vmode;
static int trig_unlock,trig_lock,input_len,have_screen_control;
extern int ttyfd;
static int currentconsole;
static void close_chdrv();

/******************************************************************* 
 *  change_console_to is used to register a virtual console change *
 *  due to keyboard input.It is set by preread() in input.c        *
 *******************************************************************/
static int change_console_to;
static char sysbuf[3000],input_pool[512],quick_buf[3000];
SYSCFG sys_config;
int ttyfd;
int is_test=0;
typedef struct
{
  char ptyname[11];
  int master,has_data;
  int pid;
} CONSTATE ;

CONSTATE cons[CONS_NUM];
/* 
   We just record the occures of console switch,and switch when we return
   to ioloop.This will avoid switch change when draw graphics in screen 
*/

static void unlock_vt(int signo)
{
  trig_unlock = 1;
}
static void lock_vt(int signo)
{
  trig_lock = 1;
}

void sigquit(int no)
{
  int i;
  SYSERR1("Signal %d occurs",no);
  close_chdrv();
  if (have_screen_control)
      adm_end();
  ioctl(ttyfd,KDSETMODE,KD_TEXT);
  ioctl(ttyfd,VT_SETMODE,(int)&vmode);
  for(i=0;i<CONS_NUM;i++)
    if (cons[i].pid != -1)
       kill(cons[i].pid,9);
  exit(0);
}

/*
   The below routine do real work of console switch.
*/
static void _unlock_vt(int signo)
{
  signal(SIGREL,unlock_vt);
  ch_cursor_blink(0);
  ch_write_to_screen(0);

  trig_unlock = 0;
  ch_restoretext();
  ioctl(ttyfd,VT_RELDISP,1); 
}

static void _lock_vt(int signo)
{

  static int forbid_switch = 0;

  if (forbid_switch)
    return;
  forbid_switch = 1;
  signal(SIGALRM,SIG_IGN);
  signal(SIGACQ,lock_vt);
  ioctl(ttyfd,VT_RELDISP,VT_ACKACQ); 
  have_screen_control = 1;
  ch_write_to_screen(1);

  ch_graphicmode(currentconsole);
  ch_cursor_blink(1);
  forbid_switch = 0;
  trig_lock = 0;
}



static void Install_vt_control()
{
  int curcons,mask,lcon;
  struct vt_mode mode;
  struct vt_stat vstate;
  char ttys[20];
  struct termios graph_termio;

#ifndef REMOTE_DEBUGGER  
  if (sys_config.VT == 0)
    {
      if ((ioctl(0,VT_OPENQRY,&lcon)<0)||(lcon==-1))
	{
	  /**********************************************/
	  /* maybe the kernel is too old to support     */
	  /* VT_OPENQRY or there is no unused console   */
	  /**********************************************/
	  sys_config.VT = 0;
	}
      else
	sys_config.VT = lcon;
      printf("Using virtual console #%d\n",sys_config.VT);

    }
  if (sys_config.VT > 16)
    {
      /*****************************************************/
      /* We have no method to know whether the console has */
      /* been used when console no. is larger than 16.So   */
      /* It's your luck if this condition occurs.          */
      /*****************************************************/
      printf("You choice a console larger than 16.I don't know\n");
      printf("if this is an unused console.Hope good luck for you\n");
    }
  else
    {
      /* We should search a console larger than 8 to fit the statement */
      /* in NEWS,but...                                                */
      int mask;

      mask = 1<<(sys_config.VT);
      ioctl(0,VT_GETSTATE,(int)&vstate);
      if (vstate.v_state&mask)
	{
	  printf("console %d is used as other program.You may choice\n",
		 sys_config.VT);
          printf("another one\n");
	  exit(1);
	}
    }
#else
  sys_config.VT = 7;
#endif

  sprintf(ttys,"/dev/tty%d",sys_config.VT);
  ttyfd = open(ttys,O_RDONLY|O_NOCTTY|O_NDELAY);
  if (ttyfd < 0)
    {
      SYSERR1("Can't open console #%d ",sys_config.VT);
      exit(-1);
    }
  if (sys_config.enterchinese)
    {
      if (ioctl(ttyfd,VT_ACTIVATE,sys_config.VT)<0)
	{
	  SYSERR1("Can't change to console %d",sys_config.VT);
	  exit(-1);
	}
    }

  sys_config.ttyfd = ttyfd;
  ioctl(ttyfd,VT_GETMODE,(int)&vmode);
  ioctl(ttyfd,KDSETMODE,KD_GRAPHICS);
  tcgetattr(ttyfd,&save_termios);
  graph_termio = save_termios;
  graph_termio.c_iflag &= ~(BRKINT|ICRNL|ISTRIP|IXOFF|IXON);
  graph_termio.c_lflag &= ~(ECHO|ICANON|ISIG);
  graph_termio.c_cc[VMIN] = 1;
  graph_termio.c_cc[VTIME] = 1;
  tcsetattr(ttyfd,TCSAFLUSH,&graph_termio);
  
  /* In the mean time the currentconsole can be a wrong value */
  /* because the just opened console is not under control */
  /* in the last switch,so we reget the currentconsole here.  */

  currentconsole = 0;
  signal(SIGREL,unlock_vt);
  signal(SIGACQ,lock_vt);
  if (sys_config.enterchinese)
    mon_grmode();
  mode = vmode;
  mode.mode = VT_PROCESS;
  mode.relsig = SIGREL;
  mode.acqsig = SIGACQ;
  ioctl(ttyfd,VT_SETMODE,(int)&mode);
}

void delay_open_console(int c)
{
  change_console_to = c;
  SYSERR1("delay open console %d",c);
}
void kill_current_console()
{
  kill(cons[currentconsole].pid,9);
}

void delay_open_next_console()
{
  int i;
  
  for(i=currentconsole+1;i<CONS_NUM;i++)
      if (cons[i].master != -1)
	  break;
  if (i == CONS_NUM)
  {
    for(i=0;i<currentconsole;i++)
	if (cons[i].master != -1)
	    break;
    if (i == currentconsole)
	return;
  }
  change_console_to = i;
  SYSERR1("delay open console %d",i);
}

void execute_getty()
{
  char *ss;
  char *arg[20];
  int i;
  ss = sys_config.loginprogram;
  i = 1;
  arg[0] = ss;

  while(*ss)
    {
      if (isspace(*ss))
	{
	  *ss=0;
	  ss++;
	  while(*ss&&isspace(*ss)) ss++;
	  if (!*ss) break;
	  arg[i++] = ss;
	}
      ss++;
    }
  arg[i] = 0;
  
/*  setenv("TERM","chdrv",1);*/
  execv(arg[0],arg);
  printf("Can't find program %s\n",arg[0]);
  while(1);
}
  
void open_console(int c)
{
  int slave,i;
  
  if (c > CONS_NUM || c < 0)
    return;
  ch_change_console(c);
  currentconsole = c;
  ch_setscroll(0,ch_DimY()-1);

  if ((cons[c].pid != -1) && kill(cons[c].pid,0)==0)
    {
      SYSERR1("Change to exist console %d",c);
      return;
    }
  SYSERR1("Create console #%d",c);
  cons[c].master = ptym_open(cons[c].ptyname);
  fcntl(cons[c].master,F_SETFL,O_NONBLOCK);
  if (cons[c].master < 0)
    {
      SYSERR("Can't open PTY master\n");
      return;
    }
  ch_clear();
  if ((slave=fork())==0)
    {
      setsid();
      for(i=0;i<256;i++)
	close(i);
      slave = ptys_open(cons[c].master,cons[c].ptyname);
      if (slave < 0)
	{
	  SYSERR1("Slave %s open error\n",cons[c].ptyname);
	  exit(0);
	}
      dup2(slave,1);
      dup2(slave,2);
      if ((i=ioctl(slave,TIOCSCTTY,0))<0)
	SYSERR1("TIOCSCTTY errorcode = %d\n",i);
      ioctl(slave,TIOCSWINSZ,(int)&size);
      execute_getty();
      SYSERR("Fatel : maybe fork error");
      exit(0);
    }
  cons[c].pid = slave;
  cons[c].has_data = 0;
}

void read_from_client(int c)
{
  int len, quick_len;

again:

  len = read(cons[c].master,sysbuf,3000);
  if (len <= 0)
    {
      SYSERR1("Read error %s",_sys_errlist[errno]);
      return;
      
    }
  /*
  quick_len = read(cons[c].master,quick_buf,3000);
  if( quick_len > 0 )
    {
      if( quick_len > 512) 
	  ch_quick_scroll(1);
      _cwrite(c,sysbuf,len);
      _cwrite(c,quick_buf,quick_len);
      sysbuf[len] = 0;
      quick_buf[quick_len] = 0;
      ch_refresh();
      if (!unlock_vt)  goto again;
    }
  else
  */
  {
    _cwrite(c,sysbuf,len);
    ch_refresh();ch_refresh();
    if (input_len=ch_read_from_buffer(NULL,input_pool,-1))
      {
	  cons[c].has_data = 1;
      }
  }

/*
going:
  if ( ch_is_quick_scroll() )
  {
    ch_quick_scroll(0);
    ch_redraw();
  }
*/
  SYSERR2("Write %d to screen:%s",len,sysbuf);
  
}

void write_to_client(int c)
{
    write(cons[c].master,input_pool,input_len);
    SYSERR2("Send %d Data to console #%d\n",input_len,c);
    input_len = 0;
    cons[c].has_data = 0;
}

void ioloop()
{
    int i,j;
    fd_set rds,wds;
    struct timeval timeout;
    static int idletime = 0;
    static int saverstat = END_SAVER;
    
    /* close all file descriptor and seperate into a new section */
    
    /* Initialize console attribution structure */
    for(i=0;i<CONS_NUM;i++)
	cons[i].master = cons[i].pid = -1;
    open_console(0);
    timeout.tv_sec = 1;
    timeout.tv_usec = 0;
    
    while(1)
    {
    begin_loop:
	if (trig_unlock )
	{
	    _unlock_vt(0);
	}
	if (trig_lock )
	{
	    _lock_vt(0);
	}
	if (is_test)
	    ch_inputmethod(2);
	FD_ZERO(&rds);FD_ZERO(&wds);
	for(i=0;i<CONS_NUM;i++)
	    if (cons[i].master != -1)
	    {
		FD_SET(cons[i].master,&rds);
		if (cons[i].has_data)
		    FD_SET(cons[i].master,&wds);
		if (waitpid(cons[i].pid,NULL,WNOHANG)!=0)
		{
		  cons[i].pid = -1;
		  close(cons[i].master);
		  cons[i].master = -1;
		  cons[i].has_data = 0;
		  SYSERR1("Console #%d release\n",i);
		  for(j = i;j<CONS_NUM;j++)
		      if (cons[j].master != -1)
		      {
			  currentconsole = j;
			  ch_change_console(j);
			  goto begin_loop;
		      }
		  for(j=0;j<i;j++)
		      if (cons[j].master != -1)
		      {
			  currentconsole = j;
			  ch_change_console(j);
			  goto begin_loop;
		      }
		  /* no other console exist,endup CHDRV now */
		  open_console(0);
		  goto begin_loop;
	      }
	    }
	/* We only read data from input device when the last data
	   has been send */
	if (cons[currentconsole].has_data == 0)
	    FD_SET(ttyfd,&rds);
	if (select(255,&rds,&wds,NULL,&timeout)<0)
	    continue;

	timeout.tv_sec = 1;
	timeout.tv_usec = 0;
	idletime++;
	if (saverstat == START_SAVER)
	  ch_screen_saver(RUN_SAVER);

	if (idletime > sys_config.blank_time)
	  {
	    ch_screen_saver(START_SAVER);
	    saverstat = START_SAVER;
	  }
	
	for(i=0;i<CONS_NUM;i++)
	  {
	    if (FD_ISSET(cons[i].master,&rds))
	      read_from_client(i);
		
	    if (ch_input_status(i)==STATE_ESC)
	      {
		  timeout.tv_sec = 0;
		  timeout.tv_usec = sys_config.escwait;
	      }

	    if (FD_ISSET(cons[i].master,&wds))
	      {
		write_to_client(i);
		/********************************************/
		/* we only think the system is buzy when an */
		/* keypress occurs.                         */
		/********************************************/
		if (saverstat != END_SAVER)
		  {
		    /**************************************/
		    /* the screen saver is running now    */
		    /* send an END_SAVER to turn off it   */
		    /**************************************/
		    saverstat = END_SAVER;
		    ch_screen_saver(END_SAVER);
		  }
		idletime = 0;
	      }
	  }
	
	if (FD_ISSET(ttyfd,&rds)&&!input_len)
	{
	    input_len = read(ttyfd,sysbuf,512);
	    if (input_len > 0)
	    {
	      input_len = ch_read_from_buffer(sysbuf,input_pool,input_len);
	      if (change_console_to>=0)
	      {
		/* if a F1+{0-9} is in input_pool */
		open_console(change_console_to);
		change_console_to=-1;
	      }
	      if (input_len == 0)
		  SYSERR("trap 1");
	    }
	    
		   
	    if (input_len>0)
	    {
	      if (cons[currentconsole].master != -1)
	      {
		  cons[currentconsole].has_data = 1;
		  SYSERR2("%d Data read for console #%d",input_len,currentconsole);
		  sysbuf[input_len] = 0;
		  SYSERR1("%s",sysbuf);
	      }
	    }
	    else if (input_len<0)
		SYSERR1("Keyboard input error : %s",_sys_errlist[errno]);
	}
	else
	{
	  for(i=0;i<CONS_NUM;i++)
	  {
	      if (ch_input_status(i)== STATE_ESC)
	      {
		  input_len = ch_read_from_buffer(sysbuf,input_pool,-1);
	      }
	  }
      }
  }
 end_loop:
}


void signal_init()
{
  signal(SIGQUIT,sigquit);
  signal(SIGTERM,sigquit);
  signal(SIGKILL,sigquit);
  signal(SIGHUP,sigquit);
  signal(SIGSEGV,sigquit);
  signal(SIGFPE,sigquit);
  signal(SIGINT,sigquit);
}
void Read_Config()
{
  char *tmp;
  GDRIVER *gd;


  tmp = getenv("CHDRV_CONFIG");
  if (tmp != NULL)
    parse_system_config_file(tmp);
  else
    parse_system_config_file(CHSYS"config");
  tmp = getenv("CHDRV_COLOR");
  if (tmp != NULL)
    sys_config.color = strdup(tmp);
  if (sys_config.color)
    printf("The enviroment variable is obsolete,ignore it\n");
  if ((tmp = getenv("CHDRV_BLANK_TIME")))
    {
      if (*tmp>='0' && *tmp<='9')
	{
	  sys_config.blank_time = atoi(tmp);
	}
    }
  printf("ScreenSaver activate time is set to %d\n",sys_config.blank_time);

  if ((tmp = getenv("CHDRV_VT")))
    {
      if (*tmp<='9' && *tmp >= '0')
	{
	  sys_config.VT = *tmp;
	  printf("Using virtual console #%d\n",sys_config.VT);
	}
    }

  if ((tmp = getenv("CHDRV_GRDR")))
    {
      sys_config.gdriver = tmp;
    }
  for(gd = sys_graphics_driver;gd->name;gd++)
    {
      if (strcmp(gd->name,sys_config.gdriver)==0)
	{
	  gd->init();
	  break;
	}
    }
  if (gd->name == NULL)
    {
      printf("driver %s not defined\n",tmp);
      close_chdrv();
      
      exit(-1);
    }
  printf("Using graphics driver %s\n",sys_config.gdriver);
  if (tmp = getenv("CHDRV_ETMODE"))
    sys_config.etmode = atoi(tmp);
  if (sys_config.etmode)
    {
      printf("Loading ET mode keyboard layout\n");
      system("etmode");
    }
  Read_Console_Config();
  Read_Input_Config();
  Read_Output_Config();
  Read_Font_Config();
}

int check_chdrv()
{
  FILE *fp;
  int pid;
  
  fp = fopen("/etc/chdrv.pid","r");
  if (fp == NULL)
      return 0;
  fscanf(fp,"%d",&pid);
  if (kill(pid,0)!=0)
    {
      pid = 0;
      unlink("/etc/chdrv.pid");
    }
  fclose(fp);
  return pid;
}

void open_chdrv()
{
  FILE *fp;
  int pid;
  
  pid = getpid();
  fp = fopen("/etc/chdrv.pid","w");
  if (fp == NULL)
  {
    printf("Can't open /etc/chdrv.pid");
    exit(-1);
  }
  fprintf(fp,"%d",pid);
  fclose(fp);
}
void close_chdrv()
{
  SYSERR("REMOVE TAG");
  unlink("/etc/chdrv.pid");
}
int chdrv_is_in_startup_stage;


void main(int argc,char *argv[])
{
  int pid;
  
  chdrv_is_in_startup_stage = 1;
  have_screen_control = 1;
  change_console_to = -1;

  pid = check_chdrv();
  if (pid)
  {
    if ((argc>1)&&strcmp(argv[1],"-k")==0)
    {
      printf("Kill CHDRV DAEMON %d\n",pid);
      kill_chdrv(pid);
    }
    else
    {
      printf("Another CHDRV process %d exist or you interrupt your system\n",pid);
      printf("abnormally last time.\n");
    }
    exit(0);
  }

  sys_config.gdriver = "vga";
  sys_config.blank_time=60*60*24*30;  /* a month */
  sys_config.VT = 0;
  sys_config.etmode = 1;
  sys_config.color = NULL;
  sys_config.forecolor = 7;
  sys_config.backcolor = 0;
  sys_config.systemcolor = 7;
  sys_config.systemback = 2;
  sys_config.escwait = 500;
  sys_config.loginprogram="/bin/login";
  sys_config.enterchinese = 1;
  Read_Config();
  signal_init();
  error_init();
  open_chdrv();

  Install_vt_control();

  printf("Chinese driver 1.0.1 by Yu-Chung Wang 03/30/1995\n");
  adm_init();
  size.ws_row = 29;
  size.ws_col = 80;
  size.ws_xpixel = 29*16;
  size.ws_ypixel = 80*8;

  printf("Chinese driver init succefully\n");
  currentconsole = 0;
  ch_change_console(0);
  chdrv_is_in_startup_stage = 0;
  signal_init();
  ioloop();
  adm_end();
  close_chdrv();
}

setup_config(char *name,char *value)
{
  /* strip the last character */
  value[strlen(value)-1] = 0;

  if (strcmp(name,"GRDR") == 0)
    {
      sys_config.gdriver = strdup(value);
    }
  else if (strcmp(name,"VT") == 0)
    {
      sys_config.VT = atoi(value);
    }
  else if (strcmp(name,"COLOR")==0)
    {
      printf("This parameter is obsolete,ignore it\n");
    }
  else if (strcmp(name,"BLANK_TIME")==0)
    {
      sys_config.blank_time = atoi(value);
    }
  else if (strcmp(name,"ETMODE")==0)
    {
      sys_config.etmode = atoi(value);
    }
  else if (strcmp(name,"COLORTABLE")==0)
    {
      sys_config.colordef = strdup(value);
    }
  else if (strcmp(name,"FORECOLOR")==0)
    {
      sys_config.forecolor = atoi(value);
    }
  else if (strcmp(name,"BACKCOLOR")==0)
    {
      sys_config.backcolor = atoi(value);
    }
  else if (strcmp(name,"SYSTEMCOLOR")==0)
    {
      sys_config.systemcolor = atoi(value);
    }
  else if (strcmp(name,"SYSTEMBACK")==0)
    {
      sys_config.systemback = atoi(value);
    }
  else if (strcmp(name,"ESCWAIT")==0)
    {
      sys_config.escwait = atoi(value);
    }
  else if (strcmp(name,"LOGINPROGRAM")==0)
    {
      sys_config.loginprogram = strdup(value);
    }
  else if (strcmp(name,"ENTERCHINESE")==0)
    {
      sys_config.enterchinese = atoi(value);
    }
  else 
    {
      printf("Error token %s = %s\n",name,value);
    }
}



parse_system_config_file(char *f)
{
  FILE * fp;
  char line[256];
  char *ss,*tok;

  fp = fopen(f,"r");
  if (fp == NULL)
    {
      printf("System file %s not found\n",f);
      return;
    }

  /* the format of system file is
          <command> = <value>
   */
  while(fgets(line,255,fp))
    {
      ss = line;
      while(*ss&&isspace(*ss)) ss++;
      tok = ss;
      while(*ss && isalnum(*ss)) ss++;
      while(*ss&&*ss != '=') ss++;
      if (!*ss)
	continue;
      
      *ss = 0;
      ss++;
      setup_config(tok,ss);
    }
}
  
kill_chdrv(int pid)
{
  int vm;

  
  vm = ioctl(0,KDGETMODE,0);
  if (vm == KD_GRAPHICS)
    {
      printf("Please don't call chdrv -k in graphic mode virtual console\n");
      exit(0);
    }
  kill(pid,SIGQUIT);
}
