/*****************************************************
 * CNPRINT.C For CNPRINT Version 2.20 (VMS and UNIX) *
 *****************************************************
  Copyright YIDAO CAI (~{2LR@5@~}), 1992, 1993  
  All Rights Reserved.
  Free for non-commercial purpose only.  

Disclaimer: Posting CNPRINT on any FTP site does not imply the author's
	endorsement of the beliefs of the organization who owns the FTP site.

CNPRINT, a utility to print Chinese text (or convert to PostScript) under 
	DOS, VMS and UNIX systems. It works just as a print command on your 
	system.  Currently GB, Hz and BIG-5 formats are supported. 

*** PLEASE read CNPRINT.HELP first EVEN if you have used CNPRINT before ***

YIDAO CAI  cai@neurophys.wisc.edu
May 17, 1993
*****************************************************/

#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <stdlib.h>


#define CNLIB  CHSYS"cnj24.hbf" /* change to "[yourpath]cnj24.hbf" if HBF not defined */
#define TIME 1
#define GB "_gb"
#define PS "_ps"
#define EOL '\n'
#define IN 1
#define OUT 0
#define R 1
#define L 2
#define NT 0
#define BUFSIZE 7168
#define isvgb(c) (c==0x21 || c==0x2c || c==0x3A || c==0x3B || c==0x3F)
#define bell fprintf(stderr, "%c", (8-1))
#define Version "CNPRINT V2.20 (LINUX)"
#define CVersion Version "媩"
 /* define margins, line space (CLP) and char spaces */
int 	LM=740, RM=620, TM=820, BM=630;
int 	CSP, CLP, maxCLP, H, V;
float	XX=8.5, YY=11.;		/* paper size */
int	Xw, Yh, Xa, Ya;
float	pts=14.5;   		/* 1 pts = 10 div = 1/72 inch */
static  int Cw=7;		/* char width/line space */
float	Ci=1.0, Ca=1.0;		/* space between lines, characters */
float	Casc=0.5;		/* ASC width / CH width */
int	nCN=1024, copies=1;	/* # of entries in CNdict */
char	prntcmd[50];

char	PSfile[100], INfile[100], tempfile[]="cnprint.tmp";
int 	pts0, ptspc;		/* pts0=INT(pts+0.5), ptspc is from PC */
char	defFontStl, Stl;
int	defFont=1;
int	mx, my, Nx, CHsize;	/* default 24x24, size 72 bytes */
int 	inCH=100, newpos=1;         
int	filecount=1;
int     fputnpage=1, pagecount=1, bpc=1;
int	frl=NT;		/* right-left */
int     fnewline=1;
int     cnsp=0;		/* special CH char */
int	*fstring, *fdict, nchar;
unsigned char	**ptstring, *array;
float 	gray=.0;	/* 0 black, .9 white */
float	Cx=1., Cy=1.;
int	fshade=0;
int 	Hzfile=0, hztogb=0;
int	fprntfile=1;
int 	pause=0;	/* pause at every (pause) pages */
int	landscape=0, EPS=0;
int	vertical=0, Rotate=0, vgb=0;
int	suppress=0;
int 	mute=0, keepPS=0;
int	adjust=1;	/* adjust spaces between punctuation marks */
int	timestat=0;	/* suppress time / statistics about document */
int	BMatEndDoc=0;	/* BM at end of document if multicolumn */
int	big5=1;
int 	nEF=2, nEFs[40];	/* ASC font */
float	Wasc[95];	/* width of ASC char re Courier */
static char *EFname[]={"AvantGarde-Book", "", "Courier", "Helvetica", "", "", 
"Palatino-Roman", "Times-Roman", "ZapfChancery-MediumItalic", "ZapfDingbats",
"AvantGarde-BookOblique", "", "Courier-Oblique", "Helvetica-Oblique", 
"", "", "Palatino-Italic", "Times-Italic", "", "", 
"AvantGarde-Demi", "", "Courier-Bold", "Helvetica-Bold", "", "", 
"Palatino-Bold", "Times-Bold", "", "",
"AvantGarde-DemiOblique", "", "Courier-BoldOblique", "Helvetica-BoldOblique", 
"", "", "Palatino-BoldItalic", "Times-BoldItalic", "", "Symbol"};

		/*  for search  */
int 	PCN=0, SCN=0;
int 	scnsp=0;
int	sfrl=NT;		/* right-left for search */ 
int     Hs, CSPs, CLPs, clptmp;
int	cTM, cBM, cLM, cRM;
int	sinCH=100;
int	pline=0, pcolumn=1;
int 	sline=0, column=1;
int	lineclp[300], linedif[300], fsnewl=0; 
int chinese_mod = 0;
/* for HBF */
char	root[80], HBFname[100], defHBFname[100]; 
int 	segh[10], segl[10], byte2h[10], byte2l[10];
int	offset[10]; 

/* functions */
int getdata(), yes(); 
void newline(), snewline(), endAC(), usage(), opnfile();

FILE	*in, *out, *HBF, *cclibs[10];

int HBFopen() 
{       /* open HBF file, set segment and byte-2-ranges parameter, open 
		bitmap font files */
	int j, k, m, n;
	char cst[120], bmfname[10][20];
	if ((HBF=fopen(HBFname, "r"))==NULL) {
		if (chinese_mod)
			fprintf(stderr,"Lk} HBF 榡ɡAнTwO_\
T]w");
		else
			fprintf(stderr, 
"Cannot open HBF file -> %s\n\
Please check the existance of this file\n\
and/or read CNPRINT.HELP for information about fonts/HBF files\n", HBFname); 
		bell; 
		if (*defHBFname==0) exit(-1);
		else return 0; 
	}
	while (fgets(cst, 119, HBF)!=NULL)
 		if (strncmp(cst, "HBF_BITMAP_BOUNDING_BOX", 23)==0) break;
	sscanf(cst, "%*s%d%d", &mx, &my);
	CHsize=my*((mx+7)/8);
	if (array!=NULL) free(array);
	array = (unsigned char *) calloc(CHsize+2, sizeof(unsigned char));
	if (array==NULL) return 0; 
	while (fgets(cst, 119, HBF)!=NULL)
 		if (strncmp(cst, "HBF_START_BYTE_2_RANGES", 23)==0) break;
	sscanf(cst, "%*s%d", &n);
	for (j=0; j<n; j++) {
		while (fgets(cst, 119, HBF)!=NULL)
 			if (strncmp(cst, "HBF_BYTE_2_RANGE", 16)==0) break;
		sscanf(cst, "%*s%i-%i", &byte2l[j], &byte2h[j]);
	}
	while (fgets(cst, 119, HBF)!=NULL)
 		if (strncmp(cst, "HBF_START_CODE_RANGES", 21)==0) break;
	sscanf(cst, "%*s%d", &n);
	for (j=0; j<n; j++) {
		while (fgets(cst, 119, HBF)!=NULL)
 			if (strncmp(cst, "HBF_CODE_RANGE", 14)==0) break;
		sscanf(cst, "%*s%i-%i%s%d", 
			&segl[j], &segh[j], bmfname[j], &offset[j]);
		if (j>0) {
		    for (m=0; m<j; m++) 
			if (strcmp(bmfname[m], bmfname[j])==0) 
				cclibs[j]=cclibs[m]; 
		}
		if (cclibs[j]==0) {
		    strcpy(cst, root); strcat(cst, bmfname[j]);
		    if ((cclibs[j] = fopen(cst, "r"))==NULL) {
			if (chinese_mod)
				fprintf(stderr,"Lk}Ҧr %s\n",cst);
			else	
				fprintf(stderr, 
"Cannot open font file -> %s\n\
Please make sure this file exists\n\
and the HBF file is properly written\n", cst); bell; 
			if (*defHBFname==0) exit(-1);
			else return 0; 
		    }
		}
	}
	return 1; 
}

void HBFclose() 
{       /* Reset segment and byte-2-ranges parameter, close 
		bitmap font files and HBF file */
	int i;
	for (i=0; i<10; i++) {
		segh[i]=segl[i]=0;
		byte2h[i]=byte2l[i]=0;
		offset[i]=0;
		fclose(cclibs[i]);
		cclibs[i]=0; 
	}
	fclose(HBF);
}
 
int HBFgetBitmap(ch)
int ch; 
{	/* according to the segment and byte-2-range information, get
		bitmap string or return NULL for out-of-range char */
	int i, j, k, sq16=256;
	long addr; 
	for (i=0; i<10; i++) 
	    if (ch>=segl[i] && ch<=segh[i]) { 
		ch -= segl[i]; k=segl[i]%sq16; j=ch%sq16;
		if (big5) addr = ch/sq16*157 
			+ ((j >= 0xA1-k) ? (j-(0x40-k)-34) : j-(0x40-k));
		else addr = ch/sq16*94 + j - (0xA1-k);
		addr = addr*CHsize + offset[i];
		fseek(cclibs[i], addr, 0);
		return (int) fread(array, CHsize, 1, cclibs[i]);
	    }
	return 0;
}

void init(argc, v)
int argc;
char *v[];
{
	char c, d, cst[100];
	int m, n, j=0, HBFopen();

	*HBFname=0; *defHBFname=0; *PSfile=0;
	while (--argc>0 && *(++v)[0] == '-')
	    while (c = *++v[0])
		switch (c) {
		    case '5': big5--; break;
		    case 'a': Hzfile=1; break;
		    case 'c': if (!isdigit(d = *++v[0])) v[0]--; 
			if (d >= '1' && d <= '9') column= d-'0';
			break;
		    case 'd': adjust=0; Casc=0.5; break;
		    case 'e': 
			if (isdigit(*++v[0])) {
				m = (*v[0]-'0')*10;
				if (isdigit(*++v[0])) m += (*v[0]-'0');
				else v[0]--;
				if (m>=10 && m<100) Casc=m/100.; 
			}
			else {
				v[0]--;
				EPS=1; fputnpage=0; keepPS=1;
			}
			break;
		    case 'f': strcpy(HBFname, *(++v)); 
			argc--; v[0] += (strlen(HBFname)-1); 
			break;
		    case 'j': BMatEndDoc = (BMatEndDoc)? 0:1; break;
		    case 'l': 
			landscape=1; column=2;
			m=BM; BM=RM; RM=m;
			m=TM; TM=LM; LM=m;
			pts=(Cx+Cy>2.05)? 10.3: 12.3;
			break;
		    case 'm': if (!isdigit(d = *++v[0])) {v[0]--; mute=1;}
			else if (d >= '1' && d <= '9') copies = d-'0';
			break;
		    case 'n': 
			sscanf(*(++v), "%d", &m);
			if (m>=0 && m<=3000) nCN=m;
			argc--; v[0] += (strlen(*v)-1);
			break;
		    case 'p': pause=4;
			if (isdigit(*++v[0])) {
				if (*v[0] > '0') pause = *v[0]-'0';
			}
			else v[0]--;
			break;
		    case 's': if (isdigit(d = *++v[0]) && d > '1') suppress=2;
			else {
				suppress=1; v[0]--; 
			}
			break;
		    case 't': timestat++; break;
		    case 'u': keepPS=1; break;
		    case 'v': vertical++; Rotate=1; adjust=0; break;
		    case 'w': fprntfile=0; break;
		    case 'x': case 'y': 
			if ((m = *++v[0]-'0')>0 && m<10) {
				if (c=='x') Cx += (m/10.);
				else Cy += (m/10.); 
			    	Ci=Cy+(Cx-1.)/2.;
				pts=(landscape)? 12.3/(Cx+Cy-1): 13;
			}
			else v[0]--;
			break;
		    case 'z': hztogb=1; break;
		    default:  usage(); exit(0);
		}
	if (argc==1 || argc==2) {
		strcpy(INfile, *v); opnfile(IN); opnfile(OUT);
		if (argc==2) { 
			strcpy(PSfile, *(++v)); keepPS++;
		}
	}
	else {
		usage(); exit (1);
	}

	if (vertical>1 && !big5) vgb=1;
	if (hztogb) return;
	getroot();
	if (big5 && *HBFname==0) getdata(2);
	if (*HBFname==0) strcpy(HBFname, CNLIB);
	m=0;
	strcpy(cst, HBFname);
	for (j=strlen(HBFname) - 3; j>=0 ; j--)
  		if (isdigit(cst[j+1]) && isdigit(cst[j+2])) m=j;
	Stl = toupper(cst[m]);
	if (m==0) sprintf(HBFname, "%scn%s.hbf", root, cst);

	for (j=0; j<10; j++) cclibs[j]=0;
	if (HBFopen()==1) fprintf(stderr, "%s\n\n", (chinese_mod)? CVersion:Version);
	if (mx!=my) {
		if (chinese_mod)
			fprintf(stderr, "non-square bitmap size\n"); 
		else
			fprintf(stderr, "D諬Ix}\n");	
		exit(0);
	}
	Nx=mx;
	strcpy(defHBFname, HBFname);
	defFontStl=Stl;
	if(getdata(0)) strcat(prntcmd, " "); 
	else prntcmd[fprntfile=0]='\0';
	nchar= big5 ? 13973 : 8178; /* 8178=94*87, 13973=(63+94)*89 */
	fstring = (int *) calloc(nchar, sizeof(int));
	ptstring= (unsigned char **) calloc(nchar, sizeof(unsigned char *));
	if (big5) { adjust=0; Casc=0.5; }
}

int getdata(n)
int n; 
{
	char t[100], *s;
	int j, k, m[10]; 
	FILE *cmd;
	strcpy(t, root); 
	strcat(t, "cnprint.cmd"); 
	if ((cmd=fopen(t, "r"))==NULL) {
			
		if (n>0) 
			if (chinese_mod) 
				fprintf(stderr,"Lk}ҩROcnprint.cmd\n");
			else
				fprintf(stderr, 
"Cannot open file cnprint.cmd\n\
Please read cnprint.readme for information on cnprint.cmd\n");
		return 0;
	}
	if (n==1) {
	    if (strlen(EFname[nEF])<=1) return 0;
    	    while (fgets(t, 98, cmd)!=NULL) 
		if (strncmp(EFname[nEF], t, strlen(EFname[nEF]))==0) break; 
	    k=0;
	    while (fgets(t, 98, cmd)!=NULL) {
		if (!strncmp(t, "DATA:", 5)) {
			sscanf(t, "%*s%d%d%d%d%d%d%d%d%d%d", &m[0], &m[1], 
			&m[2], &m[3], &m[4], &m[5], &m[6], &m[7], &m[8], &m[9]);
			j=0; 
			while(k<95) {
				Wasc[k++]=m[j++]/10000.; 
				if (k==17) while (k<=25) Wasc[k++]=Wasc[16];
				if (j==10) break;
			}
		}
		if (k>=95) break;
	    }
	    if (k<95) {
		fclose(cmd); return 0;
	    }
	}
	else if (n==0) {
	    while(fgets(t, 98, cmd)!=NULL) {
		if (strncmp(t, "DEFAULT_PAPERSIZE", 17)) continue;
		sscanf(t, "%*s%f%f", &XX, &YY);
		if (XX<1. || YY<1.) {XX=8.5; YY=11;}
		break;
	    }
	    fseek(cmd, 0, 0);
	    while(fgets(t, 98, cmd)!=NULL) {
		if (strncmp(t, "PS_PRINT_COMMAND", 16)) continue; 
		s = &t[j=17]; 
		while(s[0]==' ') s = &t[++j];
		j=0;
		while(s[j]) if (s[j++]==EOL) s[j-1] = ' ';
		if (strlen(s)==0) {
			fclose(cmd); return 0;
		}
		strcpy(prntcmd, s);
		break;
	    }
	}
	else if (n==2) {
	    while(fgets(t, 98, cmd)!=NULL) {
		if (strncmp(t, "DEFAULT_BIG5FONT", 16)) continue;
		sscanf(t, "%*s%s", HBFname);
		break;
	    }
	}
	fclose(cmd);
	return 1;
}

void opnfile(n)
int n;
{
	if (n==IN) {
		if ((in=fopen(INfile, "r"))==NULL) {
		    if (chinese_mod)
			fprintf(stderr,"Lk}Ҥr%s\n",INfile);
		    else		
      		    	fprintf(stderr, "Can't open input file -> %s\n", INfile);
      		    bell; exit (-2);
    		}
	}
	else if ((out=fopen(tempfile, "w"))==NULL) {
		if (chinese_mod)
			fprintf(stderr,"Lk}ҿX\n");
		fprintf(stderr, "Can't open output file\n");
		bell; exit (-3);
	}
}

void style()
{
int n, a, b, j;
float lm, rm, tm, bm, x, pr, pb, os=0;
float Ck=0.03527778;	/* ~~~ mm/div ~~~ */
float mg_change();
char s[100], cst[100]; 
void charsize(), cleanup();

    Xw=XX*720; Yh=YY*720; pr=Xw*Ck; pb=Yh*Ck;
    if (landscape) {
	RM=Yh-RM;  BM=Xw-BM;
	x=pr; pr=pb; pb=x;
    }
    else {
	RM=Xw-RM;  BM=Yh-BM;
    }
    charsize();	
    lm = LM*Ck;        	     
    rm = pr - RM*Ck;
    tm = TM*Ck -(os + CLP*Cw*Ck/10.); 
    bm = pb - (BM*Ck - (os + CLP*Ck) );

    if (!mute) do {
	if (fputnpage) fprintf(stderr,
"\tN: Page Numbering.  Current:   Yes.  Start at page %d\n", pagecount);
	else fprintf(stderr,
"\tN: Page Numbering.  Current:   No.\n");
	fprintf(stderr, fprntfile? 
"\tP: Print PS file?   Current:   Yes.\n" :
"\tP: Print PS file?   Current:   No.\n"); 
	fprintf(stderr,
"\tS: Character Size.  Current: %7.2f mm (%4.1f pts)\n\
\tA: Character Space. Current: %6.1f (1=standard)\n\
\tI: Line Space.      Current: %6.1f (1=standard)\n\
\tL: Left Margin.     Current: %6.1f mm\n\
\tR: Right Margin.    Current: %6.1f mm\n\
\tT: Top Margin.      Current: %6.1f mm\n\
\tB: Bottom Margin.   Current: %6.1f mm\n\
\tH: English Font.    Current:   %s\n\
\tQ: Quit.\n\n", CSP*Ck, pts, Ca, Ci, lm, rm, tm, bm, EFname[nEF]);
	a = 10.*(pb-bm-tm + .3*Ck*CLP)/(CLP*Ck);
	b = 10.*(pr-rm-lm)/(CSP*Ck); 
	fprintf(stderr,
" There are about %d.%d lines in a page and %d.%d words in a line\n\n\
 To change, type one of the following:\n\n\tN, P, S, A, I, L, R, T, B, H, Q\n\n\
 or press RETURN key to continue\n", a/10, a%10, b/10, b%10); 
	gets(cst);
        if ( cst[0] != '\0') switch (toupper(cst[0])) {
		case 'N':
			if (fputnpage) fprintf(stderr,
"\tN: Page Numbering.  Current:   Yes.  Start at page %d\n", pagecount);
			else fprintf(stderr,
"\tN: Page Numbering.  Current:   No.\n");
			fprintf(stderr, "(Y/N ?) If NO, type < N >;\n\
 If YES, enter your number to change OR press RETURN to continue;\n");
                        gets(s);  
                        if (toupper(s[0]) == 'N') fputnpage=0;
	                else {
		if (toupper(s[0])!='Y') sscanf(s,"%d", &pagecount);
				fputnpage=1;
			}
			bpc=pagecount;
			break;
		case 'P':
			fprintf(stderr, fprntfile? 
"\tPrint PS file ? Current:   Yes.  [Yes]?\n\n" :
"\tPrint PS file ? Current:   No.   [No]?\n\n");
			if (strlen(prntcmd)<=2) {
		fprintf(stderr, "Print command invalid/not found, OK !?\n"); 
				bell; gets(s);
			}
			else fprntfile=yes(fprntfile);	
			break;
		case 'S':
   			fprintf(stderr,
"\tCharacter Size. Current: %7.2f mm (%4.1f pts)\n\
\t\t****** 1 pts = 3.556 mm ******\n", CSP*Ck, pts);
                        pts=mg_change(pts,0);
			charsize();
			break;
		case 'A':
			fprintf(stderr,
"Standard is 8%% of the size of a Chinese character\n\
\tA: Character Space. Current: %6.1f (1=standard)\n", Ca);
	Ca=mg_change(Ca,2); charsize(); break;
		case 'I':
			fprintf(stderr,
"Standard is 50%% of the size of a Chinese character\n\
\tI: Line Space.      Current: %6.1f (1=standard)\n", Ci);
	Ci=mg_change(Ci,2); charsize(); break;
		case 'L':
	fprintf(stderr, "\tLeft Margin.    Current: %6.1f mm\n\n", lm);
	lm=mg_change(lm,1); break;
		case 'R':
	fprintf(stderr, "\tRight Margin.   Current: %6.1f mm\n\n", rm);
	rm=mg_change (rm,1); break;
		case 'T':
	fprintf(stderr, "\tTop Margin.     Current: %6.1f mm\n\n", tm);
	tm=mg_change (tm,1); break;
		case 'B':
	fprintf(stderr, "\tBottom Margin.  Current: %6.1f mm\n\n", bm);
	bm=mg_change (bm,1); break;
		case 'H':
	fprintf(stderr, "\tH: English Font.    Current: %s\n\n", EFname[nEF]);
	for (j=0; j<10; j++) if (strlen(EFname[j]) > 1) 
		fprintf(stderr, "%4d:  %s\n", j, EFname[j]);
	fprintf(stderr, 
"0-9: Normal  10-19: Oblique/Italic  20-29: Bold  30-39: Bold & Oblique\n");
	if ((nEF=mg_change(nEF+0.1, 3))%10 != 2)
	    if (!getdata(1)) {
		fprintf(stderr, 
"No data available for selected font, Courier used, OK?!\n");
		bell; gets(s); nEF=2; 
	    }                                      
		break; 
		case 'Q':
	cleanup(); fclose(out); remove(tempfile); exit(0); 
		default: break;
       }
    } while (cst[0] != '\0');

    charsize();
    LM = lm/Ck;           	      
    RM = (pr - rm)/Ck;
    TM = (tm +(os + CSP*Ck))/Ck; 
    BM = (pb - bm + (os + CLP*Ck))/Ck;
    RM = ((RM-LM)%CSP < CSP/2)? (RM-LM)/CSP*CSP+LM : (RM-LM)/CSP*CSP+CSP+LM;	
    BM = ((BM-TM)%CLP < CLP/2)? (BM-TM)/CLP*CLP+TM : (BM-TM)/CLP*CLP+CLP+TM;
    fprintf(stderr, " There are %d lines in a page and %d words in a line\n\n", 
		(BM - TM)/CLP, (RM - LM)/CSP); 
    RM -= LM; BM -= TM; Xa = LM; Ya = TM; LM=TM=0;
    cRM = RM; cBM = BM; cTM=cLM=0;
    CLPs = CLP; CLPs = CLP;
    if (column>1) {
	n = (RM-LM-2*Cw*pts*(column-1))/column;
	cRM = cLM + (n/CSP)*CSP;
	PCN=SCN=1;
    }
    if (nEF%10 ==2) for (j=0; j<95; j++) Wasc[j]=1;
    nEFs[nEF]++;
}                       
   
void charsize()
{
	CLP = pts*(Cw*Cy - 1./25. + (1.0 - Cw/10. + 1./25.)*Ci*10.);
	CSP = pts*(Cw*Cx - .4 + 1./25.*Ca*10);
	pts0 = ptspc = (pts+0.5);
	maxCLP = clptmp = CLP;
}

float mg_change(y, n) 
float y; int n;
{
	float x = -1.;
	char s[100];
	fprintf(stderr,
" Please enter your desired value, or press RETURN to continue\n");
	if (n==0)
fprintf(stderr, " ~~~~~~ ONLY VALUE IN --pts-- IS ACCEPTABLE ~~~~~~\n"); 
	else if (n==1)
fprintf(stderr, " ~~~~~~  inch OR mm  ~~~~~~\n");
	bell; gets(s);  
	if (s[0] != '\0') {
	    sscanf(s,"%f",&x);
            if (x<=5. && n==1) x *= 25.4; 
        }	/* 5mm < Margin <= 127 mm (5 in) */
	else return y;
	if (n==0 && x<100. && x>=1.) return x;
	else if (n==1 && x<=130. && x>=5.) return x;
	else if (n==2 && x<=20. && x>=0.1) return x;
	else if (n==3 && x<40. && x>= -0.1) return x+0.1;
	else {
		fprintf(stderr,
"\n**** WARNING: input value out of range, ignored ! ****\n\n");
		bell; return y;
	} 
}

void cleanup()
{
	void HBFclose();
  	fclose(in);
	HBFclose(); 
	bell;
}

void newline()
{
	void shade(), endpage();
	int x;
	if (fshade) shade();
	else endAC();
	if (column==1) {
		V += CLP; H=LM;
		if (V>= BM) {
			endpage(0); V=TM; 
		}
		maxCLP = clptmp = CLP;
	}
	else {
		V += lineclp[++pline]; H = cLM;
		if (V >= cBM) {
		    x = (RM-LM-2*Cw*pts*(column-1))/column;
		    x = (x/CSP)*CSP;
		    if (++pcolumn <= column) {	
			V = cTM; 
			H=cLM=LM+(x+(RM-LM-x*column)/(column-1))*(pcolumn-1);
		    }
		    else if (V >= BM) {
			endpage(0);
			V=cTM=TM; H=Hs=cLM=LM; 
			PCN=SCN=1;		/* see isfs, PCN=2 */
			pline=1; sline=0;	/* force goto search */
			pcolumn=1;
		    }
		    cRM = cLM + x;
		}
	}
	fnewline=1;
	if (fshade) ;
}                 

void endpage(flag)
int flag;
{
	char s[100], fn[100];
        void putnpagetime(), header(), trailer(), pagesetup();
	int pp;
	if (pagecount==bpc) bell;
	if (chinese_mod)
		fprintf(stderr, "***  %d wBz ***\n",pagecount);
	else
		fprintf(stderr, "*** Page %d has been done ***\n", pagecount); 
        putnpagetime();
 	pagecount++;
	pp = (pause)? pause:1;
	fprintf(out, "EP\n");
	if (flag || (pause && !((pagecount-1)%pp)) ) {
		trailer(); bpc=pagecount;
		if (ferror(out)) {
			if (chinese_mod)
				fprintf(stderr,
"ĵi: PS %s gJ~AiOOwΧ\n",tempfile);
			else	
				fprintf(stderr, 
"WARNING: PS file %s write error, possibly out of memory.\n\
	 PS file might NOT be complete.\n\
Suggestion: delete PS file and run CNPRINT again, use the -p[number] option\n\
	 or select smaller number\n", tempfile);
			bell; exit(-4);
		}
		fclose(out);
		if (fprntfile) {
			strcpy(s, prntcmd); strcat(s, tempfile);
			system(s);
			if (chinese_mod)
				fprintf(stderr, "XwQeL\n");
			else
				fprintf(stderr, "Job has been sent to printer\n");
			if (!keepPS) {
			if (chinese_mod)
	fprintf(stderr, "ЦbLu@U RETURN ");
			else
	fprintf(stderr, "Please press RETURN after print job is finished");
				bell; gets(s); 
				remove(tempfile);
			}
 		}
		if (keepPS || !fprntfile) {
 			strcpy(fn, PSfile); 
			if (pause) {
				sprintf(s, "%d", filecount); strcat(fn, s);
			}
			rename(tempfile, fn);
		}
		if (pause && !fprntfile) {
			if (chinese_mod)
				fprintf(stderr,"Ы RETURN ~\n");
			else
				fprintf(stderr,"Please press RETURN to continue"); 
			bell; gets(s);
		} 
		filecount++;
		if (!flag) {
			opnfile(OUT); header();
		}
	}
	else pagesetup();
}

void trailer()
{
	int j=0;
	fprintf(out, 
"%%%%Trailer\n%%%%Pages: %d\n", pagecount-bpc);
	while (j<40) if (nEFs[j++]>0) {
		fprintf(out,   
"%%%%DocumentNeededResources: font %s\n", EFname[j-1]); 
		break;
	    }
	while (j<40) if (nEFs[j++]>0) 
		fprintf(out, "%%%%+: font %s\n", EFname[j-1]); 
	fprintf(out, 
"%%%%DocumentSuppliedResources: procset CNset\n");
	if (nCN>0) for (j=1; j<=(1+(nCN-1)/256); j++)
		fprintf(out, "%%%%+: font CN%d%d\n", Nx, j); 
	fprintf(out, "%%%%EOF\n");
	if (EPS && pagecount-bpc >1) {
		bell;
		if (chinese_mod)
			fprintf(stderr,
"ĵi: PS ɮ榡MEPSF@A]tGHW\n");	
		else
			fprintf(stderr, 
"WARNING: This PS file does NOT comform to EPSF format\n\
	  because it contains more than one page\n");
	}
}

void pagesetup()
{ 
	void charsize_ctrl();
	fprintf(out,
"%%%%Page: %d %d\n%%%%BeginPageSetup\n/pagelevel save def\nBP\n",
		pagecount, pagecount-bpc+1);
	charsize_ctrl();
	fprintf(out, "%%%%EndPageSetup\n");
}

void putnpagetime() 
{
	struct tm *time_str;
	int i=0; 
	long time_val;
	char s[80]; 
	endAC();
        if (!fputnpage) return;
	if (vertical) fprintf(out, "fa %d %d q gctr (%6d.) S grestore\n",
		Yh-(BM-3*CLP), RM+CLP, pagecount); 
	else fprintf(out, "fa %d %d Q (%6d.) S\n", 
		Yh-(BM+CLP), RM-300-3*CSP, pagecount); 
        if (!TIME || timestat==1) return;
	time(&time_val);
	time_str = localtime(&time_val);
	strftime(s, 48, "CNPRINT %a %d-%b-%y %H:%M:%S %Z", time_str);
	while ( (s[i]=toupper(s[i])) != '\0') ++i;
	if (vertical) fprintf(out, 
"/Courier 60 SF %d %d q gctr (%s) S grestore\n", Yh-(TM+1200), RM+CLP, s);
	else fprintf(out, 
"/Courier 60 SF %d %d Q (%s) S\n", Yh-(BM+CLP), LM, s);
}

void header()
{
	int j, n;
	float x;
	long time_val;
	void CNdict(), pagesetup();
	time(&time_val);
	fprintf(out, 
"%%!PS-Adobe-3.0 %s\n\
%%%%Title: GB %s PS %s\n\
%%%%Creator: %s CYD UW-Madison WI USA\n",
(EPS)? "EPSF-3.0": "", INfile, PSfile, (chinese_mod)? CVersion:Version);
	fprintf(out, "%%%%CreationDate: %s", ctime(&time_val));
	j=(Yh-(Ya+BM+2*CLP))/10; if (j<=0) j=0;
	fprintf(out, 
"%%%%BoundingBox: %d %d %d %d\n\
%%%%Pages: (atend)\n\
%%%%DocumentNeededResources: (atend)\n\
%%%%DocumentSuppliedResources: (atend)\n\
%%%%Orientation: %s\n\
%%%%EndComments\n", (Xa-CSP)/10, j, (Xa+RM+3*CSP/2)/10, (Yh-Ya+3*CLP/2)/10,
(landscape)? "Landscape":"Portrait");  
	fprintf(out, 
"%%%%BeginProlog\n\
%%%%BeginResource: procset CNset 1500 1200\n");
	fprintf(out, 
"/B {bind def} bind def\n\
/*SF { exch findfont exch dup type /arraytype eq {makefont} {scalefont}\n\
ifelse setfont} B\n\
/languagelevel where {pop languagelevel} {1} ifelse 2 lt {/SF /*SF load def}\n\
{/SF /selectfont load def} ifelse %% selectfont emulation\n\
/EP {pagelevel restore showpage} B\n");	
	if (landscape) fprintf(out, 
"/BP {.1 .1 scale 90 rotate %d -%d translate} B\n", Xa, Ya+Yh); 
	else fprintf(out,
"/BP {.1 .1 scale %d -%d translate} B\n", Xa, Ya);
	fprintf(out, 
"/S /show load def\n\
/Q {exch moveto} B\n\
/q {p add Q} B\n\
/gct {gsave currentpoint translate} B\n\
/gctr {gct 90 rotate} B\n");
	fprintf(out,
"/T {gct LL} B\n\
/t {gctr LL} B\n\
/W {show p 0 rmoveto} B\n\
/w {gctr show grestore p 0 rmoveto} B\n\
/M {imagemask grestore p 0 rmoveto} B\n\
/m /imagemask load def\n\
/l {scale dup true} B\n");
	x = mx*25./24.;
	fprintf(out, 
"/a {%d %d true [1 0 0 -1 0 %d]} B\n\
/FMatrix [%7.5f 0 0 %7.5f 0 0] def\n\
/FBBox [0 0 %6.3f %6.3f] def\n", mx, mx, mx, 1./x, 1./x, x, x); 
	fprintf(out,
"/Shade {gsave moveto lineto lineto lineto closepath setgray fill grestore\n\
setgray} B\n");
	if (nCN>0) {
		fprintf(out, "/code 256 array def\ncode 0 [");
		for (j=0; j<256; j++) 
			fprintf(out, (j%20==0)? "\n/%02x " : "/%02x ", j);
		fprintf(out, "] putinterval\n");
	}
	fprintf(out, "%%%%EndResource\n%%%%EndProlog\n%%%%BeginSetup\n");
	if (copies>1 && !EPS) fprintf(out, "/#copies %d def\n", copies);
	n=0;
	while (nCN > 256*n) CNdict(++n); 
	if (nCN>0 && !pause) free(fdict);
	fprintf(out, "%%%%EndSetup\n");
	pagesetup();
}

void CNdict(n)  /* Fonts for frequently used characters with nCN entries */
int n;
{
    int i, j, k, m, ch, sq16=256;
    int HBFgetBitmap();
    void putBitmap();
        k = (nCN>=n*256)? 256:(nCN%256);
	j = mx*mx/24/24; j = j*(385.*k/256.); k = j*(375./385.);
	fprintf(out, 
"%%%%BeginResource: font /CN%d%d %d00 %d00\n\
8 dict begin\n\
/FontType 3 def\n\
/FontMatrix FMatrix def\n\
/FontBBox FBBox def\n", mx, n, j+1, k+1); 
	fprintf(out, 
"/BuildGlyph {0 0 0 0 %d %d setcachedevice %% 0 x/y displacement\n\
exch /CharProcs%d get exch 2 copy known not {pop /.notdef} if get exec} B\n", 
mx, mx, n); 
	fprintf(out, 
"/BuildChar {1 index /Encoding get exch get 1 index /BuildGlyph get exec} B\n\
/Encoding 256 array def\n\
Encoding 0 code putinterval\n");
	if (nCN < n*256) fprintf(out,
"%d 1 255 {Encoding exch /.notdef put} for\n", nCN%256);
	fprintf(out, 
"/CharProcs%d %d dict def\n\
CharProcs%d begin\n/.notdef {} def\n", n, (nCN>=n*256)? 257:(nCN%256+1), n);

	k = (nCN < n*256)? nCN : n*256;
	for (i=(n-1)*256; i<k; i++) {
	    m=fdict[i];
	    if (big5) {
		ch=m%157;  ch += ((ch<63)? 0x40:(0xA1-63));
		ch += (m/157+0xA1)*sq16;
	    }
	    else ch = (m/94 + 0xA1)*sq16 + m%94 + 0xA1;
	    HBFgetBitmap(ch);   
	    fprintf(out, "/%02x {a {<", i%256);
	    putBitmap(array);
	    fprintf(out, ">} m} B\n");
	    ptstring[m] = array;
        }
	fprintf(out, "end currentdict end\n/CN%d%d exch definefont pop\n\
%%%%EndResource\n", mx, n);
}

void putBitmap(a)
unsigned char *a;
{
	int j;
	for (j=0; j<CHsize; ++j) 
		fprintf(out, (!(j%38) && j)? "\n%02x" : "%02x", a[j]);
}

void charsize_ctrl()
{
	float z, ns;
	int  j, nsx, nsy, nx, ny, nty;
	endAC(); inCH=100;
	if (ptspc <= 0 || ptspc >= 100 || ptspc==pts0) {
		ptspc=pts0;
		CLP = pts*(Cw*Cy - 1./25. + (1.0 - Cw/10. + 1./25.)*Ci*10.);
		CSP = pts*(Cw*Cx - .4 + 1./25.*Ca*10);
	}
	else {
		CLP = ptspc*(Cw*Cy - 1./25. + (1.0 - Cw/10. + 1./25.)*Ci*10.);
		CSP = ptspc*(Cw*Cx - .4 + 1./25.*Ca*10);
	}
	z = (ptspc==pts0)? pts : ptspc;
	ns = z*Cw*10*24./25./10.;  
	nsy = ns*Cy; nsx = (Stl=='F')? ns*.95*Cx : ns*Cx;
	nx = (0.5775*CSP*10./Cw)*2.*Casc;
	ny = z*0.75*10.*Cy; nty = ny/9.;
	fprintf(out, "/p %d def\n\
/LL {%d %d %d l [%d 0 0 -%d 0 %d]} B\n", CSP, mx, nsx, nsy, mx, mx, mx);
	if (nCN>0) for (j=1; j<=(nCN+255)/256; j++) {
		if (nsx!=nsy) fprintf(out, 
"/z%d {/CN%d%d [%d 0 0 %d 0 0] SF} B\n", j, mx, j, nsx, nsy);
		else fprintf(out, 
"/z%d {/CN%d%d %d SF} B\n", j, mx, j, nsx);
	}
	fprintf(out, 
"/fa {/%s [%d 0 0 %d 0 %d] SF} B\n", EFname[nEF], nx, ny, nty);
	if (gray>0.01) fprintf(out, "%3.1f setgray\n", gray);
}

int isrlasc(c)
int c;
{              /* L=left; R=right; NT=none */
	if (!adjust) return NT;
	switch (c) {
		case 40 : case 60 : case 91 : case 123 :
			return L;
		case 33 : case 41 : case 44 : case 46 : case 58 : 
		case 59 : case 62 : case 63 : case 93 : case 125 :
			return R;
		default: return NT;
	}
}

int isrlch(c1, c2)
unsigned char c1, c2;
{		/* L=left; R=right; NT=none */ 
	switch (c1) {
	    case 0xA1:
		if (c2>=0xAE && c2<=0xBF) c2%=2;
		switch (c2) {
			case 0: return L; 
			case 1: case 0xA2 : case 0xA3 : case 0xC3 : 
			case 0xE3 : case 0xE4 : case 0xE5 : 
				return R; 
	      		default: return NT; 
		}
	    case 0xA3:
		switch (c2) {
			case 0xA8 : case 0xDB : case 0xFB : case 0xE0 :
				return L; 
			case 0xA1 : case 0xA7 : case 0xA9 : case 0xAC : 
			case 0xAE : case 0xBA : case 0xBB : case 0xBF : 
			case 0xDD : case 0xDF : case 0xFD : 
				return R; 
	      		default: return NT; 
		}
      	    default: return NT; 
	}
}

unsigned char tovhb5(c)
unsigned char c;
{ /* convert vertical big5 punctuations to horizontal ones or vice versa */
	int j;
	if (c<0x5D || c>0x7D) return c;
	j = (c-0x5D)%4;
	if (j<2 && vertical) return (c+2);
	if (j>=2 && !vertical) return (c-2);
        return c;
}

int rtch(c1, c2)
unsigned char c1, c2;
{		/* R=rotate */ 
	if (big5) return R;
	switch (c1) {
	    case 0xA1:
		switch (c2) {
 			case 0xA2 : case 0xA3 : return R; 
   	      		default: return NT; 
   		}
	    case 0xA3:
		switch (c2) {
			case 0xA1 : case 0xAC : case 0xAE : case 0xBA : 
			case 0xBB : case 0xBF : 
				return R; 
   	      		default: return NT; 
   		}
	    case 0xA6: case 0xA7: return NT;
	    case 0xA8: return (c2 < 0xC4)? NT : R;
      	    default: return R; 
	}
}

int putASC(c)
int c;
{
	int k, ASP, newl=0;
	float x;
	int isrlasc(), rl;

	if (c==13 || c==26) return 0; 
	cnsp=0; frl=NT;
	if (c==EOL) {
		newline(); return 0;
	}
	if (c=='\t') {
		endAC(); 
		x = (H-cLM)*2.0/CSP; 
		k = x + 8.5;  k = (k/8)*8;
		H += ((k-x)*CSP/2.0);  
		return 0;
	}
	k = (c>=' ' && c<=126 )? (c-' ') : 0; 
	ASP = CSP*Casc*Wasc[k];
	if (c==' ') {
		if (!inCH) fprintf(out, " "); 
		else newpos = 1;
		H += ASP;  
		return 0;
	}
	if ((rl=isrlasc(c))==L) if (H > cRM-ASP*3/2) newl=1;
	if (newl || (H > cRM-ASP/2 && rl != R) ) {
		newline(); return 1;
	}
	if (inCH) {
		fprintf(out,"%d %d Q fa (", Yh-V, H);
		inCH=OUT;
	}
	fprintf(out, (isprint(c)) ? 
		( (c=='(' || c==')' || c==92)? "\\%c":"%c") : "\\%03o" , c);
	H += ASP;
	return 0; 
}

int Addr(c1, c2)
int c1, c2;
{
	return (!big5)? ((c1-0xA1)*94+c2-0xA1) :
		( (c1-0xA1)*157 + ( (c2>=0xA1)? (63+c2-0xA1):(c2-0x40) ) );
}

int putCH(c1, c2)
unsigned char c1, c2;
{
	int  j, addr, ch, newl=0;
	void putBitmap();
	int isrlch(), rtch(), rl, rt, HBFgetBitmap(), Addr();
	unsigned char tovhb5();

	rl=NT;
	if (big5>1) if (c1==0xA1) c2=tovhb5(c2);
	if (c1>=0xA4) cnsp=0;
	else if (adjust) { 
	    cnsp++;     
	    if ( (rl=isrlch(c1, c2))==NT ) cnsp=0;
	    else if (rl==L) {
		if (H > cRM-2*CSP) {
			cnsp=1; newpos=1; 
			if (H < cRM-CSP*5/4) {
				H -= ((frl==R)? CSP: CSP/2); 
				if (frl==R) frl=NT; 
				if (H < cRM-2*CSP) H=cRM-2*CSP;
			}
			else if (H < cRM-CSP*3/4 && frl==R) {
				H -= CSP; 
				if (H < cRM-2*CSP) H=cRM-2*CSP;
			}
			else newl=1;
		}
	    }
	    else if (rl==R && frl==L) cnsp=1;
	}  
	if (vertical) {
		rt = (c1<0xB0)? rtch(c1, c2) : R;
		if (rt==R) Rotate=1;
	}
	else rt=NT;
	ch=c1*256+c2;
	if (ch != (big5 ? 0xA140 : 0xA1A1) ) { 
	    if (adjust) {
		if (frl==R && H > cRM-CSP && H <=cRM-CSP/4 && !cnsp) {
			newpos=1;
			H = (H > cRM-CSP/2)? (H-CSP/2):(cRM-CSP);
		}
		else if (newl || (H > cRM-CSP*2/3 && rl!=R) ) {
			newline(); return 2;
		}
		if (cnsp >= 2) {      /* take care of 'half' CN   */
			if (linedif[pline] > CSP/2) 
				linedif[pline] -= (CSP/2); 
			else if (linedif[pline] > 0) {
				H -= (CSP/2-linedif[pline]);
				linedif[pline]=0; newpos=1;
			}
			else {
				H -= (CSP/2); newpos=1;
			}
		}
	    }
	    else if (H > cRM - CSP*2/3) {
		newline(); return 2;
	    }
	    addr=Addr(c1, c2);
            if ((defFont && ptstring[addr]==NULL) || !defFont) {
		    HBFgetBitmap(ch);   
		    if (defFont) {
		         /* allocate memory for bitmap array */
ptstring[addr] = (unsigned char *) calloc(CHsize+1, sizeof(unsigned char));
		    	if (ptstring[addr]!=NULL) for (j=0; j<CHsize; ++j)  
				ptstring[addr][j]=array[j];
			else ptstring[addr=0] = array;
		    }
		    else ptstring[addr=0] = array;
	    }
	    if (!inCH) endAC(); 
	    if (newpos || (rt==NT && Rotate) ) {
		if (newpos==1 || rt==R || (rt==NT && Rotate) ) 
		    fprintf(out, (vertical && rt==R)? 
			"%d %d q\n":"%d %d Q\n", Yh-V, H);   
		newpos=0; 
		if (vertical && rt==NT) {Rotate=0; newpos=2;}
	    }
	    if (defFont && fstring[addr]<0) {
		j = fstring[addr] + 5000;
		if (inCH != j/256 +1) fprintf(out, "z%d ", (inCH = j/256 +1));
		j%=256;
		fprintf(out, (j>'~' || j<' ' || j=='(' || j==')' || j==92)? 
			"<%02x>%s\n" : "(%c)%s\n", j, ((rt==NT)? "W":"w"));
	    }
	    else {
		fprintf(out, (rt==NT)? "T {<" : "t {<");
		putBitmap(ptstring[addr]);
		fprintf(out, ">} M\n");
	    }
	    if (fstring[addr]>0) if (--fstring[addr]==100) {
		free(ptstring[addr]);
		ptstring[addr]=NULL;
	    }
	}
	else if (!inCH && adjust) {
		putASC(' '); return 0;
	} 
	else newpos=1;
	H+=CSP;
	frl=rl;
	return 0;
}

void usage()
{
	bell; 
	
	fprintf(stderr, "%s\n\n", (chinese_mod)? CVersion:Version);
	if (chinese_mod)
	fprintf(stderr,
"ϥΤk: cnprint [-h] [-wulc2x3...f font] ɦW [PS/GB name]\n\n"
"	-h:	UTAԲӤeаѾ CNPRINT.HELP\n"
"	-z:	uNHzഫGB \n"
"	-5:	ϥBIG5X \n"
"	-w:	ഫPS \n"
"	-u:	LᤣNPSɧR \n"
"	-v:	CL \n"
"	-l:	VCL \n"
"	-m:	LAܥ\\n"
"	-x2:	]rMe 1:2\n"
"	-y3:	]rMe 1:3\n"
"	-p4:	PɳBz| \n"
"	-c3:	N@TCL \n"
"	-f font	(j16,f24 k24 ΧHBFW):ܦr \n");
	else
		fprintf(stderr, 
"USAGE: cnprint [-h] [-wulc2x3...f font] filename [PS/GB name]\n\n\
	The default code scheme is changed to BIG5 in Chinese tty\
		
	-h:	This message. See CNPRINT.HELP for more.\n\
	-z:	Hz to GB conversion only.\n\
	-5:	Input is *NOT* BIG 5 file.\n\
	-w:	Convert to PS Without printing.\n\
	-u:	Keep PS file after printing.\n\
	-v:	Vertical printing.\n\
	-l:	Set paper orientation Landscape.\n\
	-m:     Mute, do NOT display menu.\n\
	-x2:	Set character width/height 1.2.\n\
	-y3:	Set character height/width 1.3.\n\
	-p4:	Print/convert 4 pages at a time.\n\
	-c3:	Divide one page into 3 Columns.\n\
	-f font (j16, f24, k24, or full HBF name): Select font.\n");

}

int isfs(s, pr)
unsigned char *s;
int pr;
{
	int j, k, x, HBFopen(), issfs();
	unsigned char c1, c2;
	void shade(), charsize_ctrl(), HBFclose();
	
	c1=s[1]; c2=s[2];
        if (s[3]!=']') {
		if (c1!='M' || c2!='V' || s[9]!=']') return 0;
		if(suppress) return (suppress>=2)? 0 : 10; 
		for (j=3; j<=8; j++) if (!isdigit(s[j])) return 0;
		sscanf(s, "%*c%*c%*c%03d%03d", &j, &k);
		if (pr) { 
			endAC(); 
			if (j!=1) H = j*10; if (k!=1) V = k*10;
		}
		else if (j!=1) Hs = j*10;
		return 10;
	}
	if(suppress) return (suppress>=2)? 0 : 4; 
    	switch(c1) {
/* C: column number */
	    case 'C':      
		if (!pr) return issfs(c1, c2);
		if (!isdigit(c2)) return 0;
		k = (c2=='0')? 1 : (c2-'0');
		PCN++; 
		if (PCN==1) {
			if (column==1 && k==1) PCN=SCN=0;
			return 4;
		}
		else {
		    column = k;      /* set search mode for next one */ 
		    fnewline = 1;
		    sline = 0;  pline = 1;
		    V = cBM; cBM = BM; 
		    Hs = cLM = H = LM;
		    if (column > 1) {
			SCN = 1; PCN = 1; cTM = V;   
    			x = (RM-LM-2*Cw*pts*(column-1))/column;
		        x = (x/CSP)*CSP;
			cRM = LM + x;
		    }
		    else { 
			SCN = 0; PCN = 0; 
			cRM = RM; cTM = TM;
		    }
		}
		return 4;
/* ASC font */
	    case 'h': case 'H': case 'q': case 'Q':
		if (!isdigit(c2)) return 0;
		nEF=c2-'0';
		if (isupper(c1)) nEF += 20;
		if (c1=='q') nEF += 10;
		if (strlen(EFname[nEF]) > 1 && (nEF%10)!=2) 
		    if (!getdata(1)) {
			if (chinese_mod)
				fprintf(stderr,
"Lk{ҿ蠟rAϥCourierN\n");
			else
				fprintf(stderr, 
"No data available for selected font, Courier used\n");
			bell; nEF=2;
			for (j=0; j<95; j++) Wasc[j]=1;
 		    }
		nEFs[nEF]++;
		return 4;
/* CH font */
	    case 'f': case 'F': case 'u': case 'U':     
                if (!isalpha(c2)) return 0;
		if (!pr) return 4;
		Stl = toupper(c2);
		k = (isupper(c1))? 1:0; 
		k += (isupper(c2))? 1:0;
		switch(k) {
			case 0: j = (toupper(c1)=='F')? 16:40; break; 
			case 1: j = (toupper(c1)=='F')? 24:56; break; 
			case 2: j = (toupper(c1)=='F')? 48:64; break; 
			default: break; 
		}
		HBFclose();
		sprintf(HBFname, "%scn%c%d.hbf", root, tolower(c2), j); 
		if (!HBFopen()) {
			strcpy(HBFname, defHBFname); 
			if (chinese_mod)
				fprintf(stderr,"ϥΤwr\n");
			else
				fprintf(stderr, "Default font used\n\n");
			Stl=defFontStl;
			HBFopen();
		}
		if (mx!=my) {
			if (chinese_mod)
				fprintf(stderr,"ϥΫD諬I}r\n");
			else
				fprintf(stderr, "non-square bitmap size\n"); 
			exit(8);
		}
		defFont= strcmp(defHBFname, HBFname)? 0:1;
		charsize_ctrl();
		return 4;
/* shading */
	    case 'S':
		if (!isdigit(c2)) return 0;
		if (!pr) return 4;
		if (fshade) shade();
		fshade=(c2=='0')? 0:1;
		return 4;
/* gray */
	    case 'G':
		if (!isdigit(c2)) return 0;
		if (!pr) return 4;
		endAC();
		fprintf(out, "%3.1f setgray\n", gray=(c2-'0')/10.);
		return 4;
/* X, Y expansion */
	    case 'X': case 'Y':
		if (!isdigit(c2)) return 0;
		if (c1=='X') { Cx=1.+(c2-'0')/10.; Cy=1;}
		else { Cy=1.+(c2-'0')/10.; Cx=1;}
		if (Cy+(Cx-1.)/2. > Ci) Ci = Cy+(Cx-1.)/2.;
		if (!pr) return issfs('0'+ptspc/10, '0'+ptspc%10);
		charsize_ctrl();
		return 4;
/* ASC width, line and char space */
    	    case 'E': 
		if (!isdigit(c2)) return 0;
		Casc = (c2=='0')? Casc : (c2-'0')/10.;
		if (!pr) return issfs('0'+ptspc/10, '0'+ptspc%10);
		charsize_ctrl();
		return 4;		
	    case 'I': case 'A': 
		if (!isxdigit(c2)) return 0;
		if (c1=='I') Ci= (c2=='0')? 
			Ci : (isdigit(c2)? (c2-'0')/10. : (c2-'a'+1) );
		else Ca= (c2=='0')? Ca : (isdigit(c2)? (c2-'0') : c2-'a'+10);
		if (!pr) return issfs('0'+ptspc/10, '0'+ptspc%10);
		charsize_ctrl();
		return 4;		
    	    case 'P': 
		if (!isdigit(c2)) return 0;
		if (!pr) return 4;
		j = c2-'0';
		if (!j || (BM-V)/CLP<=j) {
			V=BM; newline();
		}
		return 4;
    	    default: 
		if (!isdigit(c1) || !isdigit(c2)) return 0;
/* char size */
		if (!pr) return issfs(c1, c2);
		ptspc = (c1-'0')*10 + (c2-'0');
	        charsize_ctrl();
		return 4;
	}
}

int issfs(c1, c2)
unsigned char c1, c2;
{
	int k, x, span();
	switch(c1) {
/* C: column number */
	    case 'C':      
		if (!isdigit(c2)) return 0;
		k = (c2=='0')? 1:(c2-'0');
		SCN++;
		if (SCN==1) {
			column = k;
			if (column==1) PCN=SCN = 0; 
			cTM = V; 
			x = (RM-LM-2*Cw*pts*(column-1))/column;
		        x = (x/CSP)*CSP;
			cRM = LM + x;
		}
		else {
			cBM=span(1);
			cLM = H = LM;
			pcolumn = 1;
		}
		return 4;
	    default: 
		if (!isdigit(c1) || !isdigit(c2)) return 0;
/* char size */
		k = (c1-'0')*10 + (c2-'0');
		if (k >= 100 || k <=0) k=pts;
		ptspc=k;
		CSPs = k*(Cw*Cx - .4 + 1./25.*Ca*10);
		CLPs = k*(Cw*Cy - 1./25. + (1.0 - Cw/10. + 1./25.)*Ci*10.);
		  /* size ctrl at the begin of a line, take it */
		if (column==1) {
			if (Hs==LM || CLPs > 1.2*clptmp) {
				V += (CLPs - maxCLP);
				maxCLP = CLPs;
			}
		}
		else if (Hs==LM || CLPs > 1.2*clptmp) {
			if (sline==0) V += (CLPs-lineclp[sline+1]);
			lineclp[sline+1] = CLPs;
		}
		return 4;
	}
}
  
void shade()
{
	endAC(); ;
}

void endAC()
{
	if (!inCH) {fprintf(out,") S\n"); inCH=100;}
	newpos=1; 
}	

int scanASC(c)
int c;
{
	int  k, ASP, newl=0, isrlasc(), rl;
	float x;

	if (c==13 || c==26) return 0; 
	scnsp=0; sfrl=NT;
	if (c==EOL) {
		snewline(1); return 0;
	}
	if (c=='\t') {
		x = (Hs-LM)*2.0/CSPs; 
		k = x + 8.5;  k = (k/8)*8;
		Hs += ((k-x)*CSPs/2.0);  
		return 0;
	} 
	k = (c>=' ' && c<=126 )? (c-' ') : 0; 
	ASP = CSPs*Casc*Wasc[k];
	if (c==' ') {
		Hs += ASP;  
		return 0;
	}
	if ((rl=isrlasc(c))==L) if (Hs > cRM - ASP*3/2) newl=1;
	if (newl || (Hs > cRM-ASP/2 && rl != R) ) {
		snewline(0);  return 1;
	}	
	sinCH=OUT;
	Hs += ASP;
	return 0;  
}

int scanCH(c1, c2)
unsigned char c1, c2;
{
	int  newl=0, isrlch(), rl=NT;
	unsigned char tovhb5();

	if (big5>1) if (c1==0xA1) c2=tovhb5(c2);
	if (c1>=0xA4) scnsp=0;
	else if (adjust) { 
	    scnsp++;     
	    if ( (rl=isrlch(c1, c2))==NT) scnsp=0;
	    else if (rl==L) {
		if (Hs > cRM-2*CSPs) {
			scnsp=1;
			if (Hs < cRM-CSPs*5/4) {
				Hs -= ((sfrl==R)? CSPs: CSPs/2); 
				if (sfrl==R) sfrl=NT;
				if (Hs < cRM-2*CSPs) Hs=cRM-2*CSPs;
			}
			else if (Hs < cRM-CSPs*3/4 && sfrl==R) {
				Hs -= CSPs;
				if (Hs < cRM-2*CSPs) Hs=cRM-2*CSPs;
			}
			else newl=1;
		}
	    }
	    else if (rl==R && sfrl==L) scnsp=1;
	}  
	if (c1!=0xA1 || c2!=(big5 ? 0x40:0xA1)) { 
	    if (adjust) {
		if (sfrl==R && Hs > cRM-CSPs && Hs <=cRM-CSPs/4 && !scnsp)
			Hs = (Hs > cRM-CSPs/2)? (Hs-CSPs/2):(cRM-CSPs);
		else if (newl || (Hs > cRM-CSPs*2/3 && rl != R) ) {
			snewline(0);  return 2;
		}
		if (scnsp >= 2) Hs -= (CSPs/2);
	    }
	    else if (Hs > cRM - CSPs*2/3) {
		snewline(0);  return 2;
	    }
	    sinCH=100;
	}
	else if (adjust && !sinCH) {
		scanASC(' '); return 0;
	}
	Hs+=CSPs;
	sfrl=rl;
	return 0;
}

void snewline(ret)
int ret;
{
	fsnewl=1; sinCH=100; 
	lineclp[1+(++sline)]=clptmp=CLPs;
	linedif[sline]=(Hs<cRM && !ret)? (cRM-Hs):0;
	Hs=LM; 
}

void hz2gb() 
{
	int state, cin, cin2;
	state = OUT;
	fprintf(stderr, "Hz --> GB ...\n");
	while ( (cin=fgetc(in)) != EOF) {
		if (cin=='~') {
      			if ( (cin2=fgetc(in)) == '{') state = IN;
			else if (cin2 == '}') state = OUT;
			else if (cin2 == '~') fprintf(out, "~");
			else if (cin2 != EOL) fprintf (out, "%c%c", 
				cin+(state==IN?128:0), cin2+(state==IN?128:0));
		}
		else {
		    if (state == IN) {
			cin2 = fgetc(in);
			fprintf (out,"%c%c", cin+128, cin2+128);
		    } 
		    else fprintf (out, "%c", cin);
		}
	}
	fclose(in);
	if (ferror(out)) {
		fprintf(stderr, " GB version %s write error\n", tempfile);
		bell; exit(-4);
	}
	fclose(out);   
}

int ishz(c)
int c;
{
	return (c=='{' || c=='}')? 1:0;
}

int span(m)
int m;
{
	int x, y, n, j, k=1;
	if (m==0) {
		x = BM-V+lineclp[0]; y=0;
		for (j=1; j<=sline; j++) {
			y += lineclp[j];
			if (y >= x) {
				y=0; j--; k++;
			}
		}
		return (k>column)? 1:0;
	}    /* end of document */
	else if (m==10 && BMatEndDoc) return BM;
	else {
		n=1; x=lineclp[0];
 		do {
			x += lineclp[n++];
			y=0; k=1;
			for (j=1; j<=sline; j++) {
				y += lineclp[j];
				if (y >= x) {
					y=0; j--; k++;
				}
			}
			if (k<=column && y<x) return 
				((x-lineclp[0]+cTM)>BM)? BM :(x-lineclp[0]+cTM);
		} while (k>column);
	}
}

void prescan()
{
    int	i, k, m, n, N, c1, c2, HZ=0, ishz(), Addr();
    void hz2gb(), FName();

    for (i=0; i<nchar; i++) fstring[i]=0;
    if (chinese_mod)	
	fprintf(stderr, "Ķ ...\n");
    else	
    	fprintf(stderr, "Scanning document ...\n");
    while ((c1=fgetc(in))!=EOF) {
	if (c1>=0xA1) {
		if ((c2=fgetc(in))==EOF) break; 
		else if (c1==0xa3 && !big5 && adjust && isalnum(c2-128)) 
			continue;
		else if (c2>=(big5 ? 0x40 : 0xA1)) fstring[Addr(c1, c2)]++;
		else if (c2=='~') if ((c1=fgetc(in))!=EOF) HZ += ishz(c1);
	}
	else if (c1=='~') {
		if ((c2=fgetc(in))!=EOF) HZ += ishz(c2);
	}
	else if (vgb) if (isvgb(c1)) fstring[2*94+c1-32]++;
    }
    fclose(in); opnfile(IN); 
    if (*PSfile==0) {
	strcpy(PSfile, INfile);
	FName(PSfile, PS);
    }
    if (HZ && !hztogb && !big5) {
	if (!Hzfile) fprintf(stderr, 
"Input file is in Hz format, is that right (Y/N)?\n");
	hztogb=(Hzfile)? 1 : ((yes(2))? 1 : 0);
	if (hztogb) {
		hz2gb();
		FName(INfile, GB);
		rename(tempfile, INfile);
		opnfile(IN); opnfile(OUT);
		return; 
	}
	else HZ=0;
    }
    if (!HZ || hztogb || big5) {
	fstring[0]=0; N=m=n=0;
	for (i=0; i<nchar; i++) if (fstring[i]) {
		m += fstring[i]; N++;
		if (fstring[i]==1) n++;
	    }
	if (chinese_mod)
		fprintf(stderr,
"`@ %d Pr`@ %d rboӤ\n",N,m);
	else
		fprintf(stderr, 
"There are %d different words and total %d words in this document\n", N, m);
	if (nCN>N-n) nCN=N-n;
	m=N; n=0;
	if (N>0) {
	    fdict = (int *) calloc(N, sizeof(int));
	    while (++n) {
		if (m<=0) break;
		for (i=1; i<nchar; i++) if (fstring[i]>0 && fstring[i]<=n) {
			fdict[--m]=i; fstring[i] -= 10000;  
			if (m==0) break;
		}
	    }
	    if (nCN>0) for (m=0; m<nCN; m++) fstring[fdict[m]] = m-5000;
	    if (nCN<N) for (m=nCN; m<N; m++) fstring[fdict[m]] += 10100;
	}
    }
}

int yes(n)
int n;
{
	char s[50];
	do {
		bell; gets(s);
		if ((toupper(s[0]))=='Y') return 1;
		else if ((toupper(s[0]))=='N') return 0;
		else if (n<=1) return n;
		else s[0]='\0';
		fprintf(stderr, "(Y/N) ?\n");
	} while (s[0]=='\0');
}

void FName(t, s)
char *t, *s;
{
	int j;
#if VMS
	j=strlen(t);
	while (t[j]!=';' && j) j--;
	if (j>1) t[j]='\0'; 
#endif
	strcat(t, s);
}
  
main (argc, argv)
int	argc;
char	*argv[];
{
    int	k, j, jmax, c, endfile=0;
    void init(), style(), hz2gb(), prescan();
    void header(), endpage(), cleanup(), FName();
    int span();
    unsigned char buf[BUFSIZE], *s, *p, *doAC();
    float Cis, Cas, Cascs, Cxs, Cys, ps;
    int nEFs;
    
    check_if_chinese_exist();
    init(argc, argv);
    if (hztogb) {
	hz2gb();
	if (*PSfile) strcpy(INfile, PSfile);
	else FName(INfile, GB);
	rename(tempfile, INfile); bell; exit(0);
    }
    style(); 
    prescan(); if (hztogb) prescan();
    fprintf(stderr, "%s --> PS ...\n", (big5)? "BIG-5" : "GB");
    header();
    V=TM; H=LM;

    buf[0]=getc(in); buf[1]='\0'; p = &buf[0];
    while (p[0]!='\0') {	
		/* reorganize buf */
	if (!endfile && strlen(p) < BUFSIZE-2048) {
	    j=0;
	    if (p != &buf[0]) while (buf[j++] = *p++) ;
	    jmax=strlen(buf); j=BUFSIZE-jmax-2;
	    while (--j>0 && (c=getc(in))!=EOF) if (c!='\0') buf[jmax++]=c;
	    buf[jmax]='\0'; 
	    if (c==EOF) { endfile=1; if (hztogb) remove(INfile); }
	    p = &buf[0];
	}
	s=p;
	CSPs = CSP; CLPs = CLP; Hs = LM;
	Cis=Ci; Cas=Ca; Cascs=Casc; Cxs=Cx; Cys=Cy; ps=ptspc; nEFs=nEF;
	sline=fsnewl=0;
	lineclp[0]=lineclp[1]=clptmp=CLPs;
/* SEARCH */
	for (;;) {
	    while (!fsnewl && *s!='\0' && (s[1]!='\0' || endfile) )
		s=doAC(s, 0);
	    if (column==1 || SCN==2) break; 
	    else if ( span(0) || (endfile && s[0]=='\0') ) { 
		if (endfile && s[0]=='\0') {  /* see issfs  SCN=2 */
			if (s[-1]!=EOL) snewline(1);
			cBM=span(10); 
		}
		else cBM = BM;
		cLM = H = LM;
		pcolumn = 1;
		break;
	    }
	    fsnewl = 0; 
	}
/* PRINT */
	Ci=Cis; Ca=Cas; Casc=Cascs; Cx=Cxs; Cy=Cys; ptspc=ps; 
	if (nEF != nEFs) {
		nEF=nEFs;
		if (!getdata(1)) for (j=0; j<95; j++) Wasc[j]=1;
	}
	pline=1; 
	do {
	    fnewline=0;
	    while (!fnewline && *p!='\0' && (p[1]!='\0' || endfile) )
		p=doAC(p, 1);
	    if (column==1) break;
	} while (pline<=sline && *p!='\0');
    }
    endpage(1);
    cleanup();
}

unsigned char *doAC(q, pr)
unsigned char *q;
int pr;
{
	int k, j=1;
	int putCH(), putASC(), scanCH(), scanASC(), isfs();
	unsigned char c1, c2;
	c2=0;
	if ( (c1 = *q++) >= 0xa1) {  
	    if (q[0]=='\0') ; 
	    else {
		c2= *q++;
		if (!big5 && c2 >= 0xa1) {  
			if (c1==0xa3 && adjust && isalnum(c2-128)) c1 = c2-128;
        		else j = 2;
		}
		else if (big5 && c2 >= 0x40) j = 2;
		else {q--; c2=0;}
	    }
	} 
	else if (c1=='@' && q[0]=='[') {
		if (k=isfs(q, pr)) {
			q += k; j=0;
		}
	} 
 	if (j == 2) k = (pr) ? putCH(c1, c2) : scanCH(c1, c2);  
	else if (j == 1) {
		if (!vgb || !isvgb(c1)) k = (pr) ? putASC(c1) : scanASC(c1);
		else k = ((pr) ? putCH(0xa3, c1+128) : scanCH(0xa3, c1+128))/2;
	}
	else k=0;
	if (k==1 && c2!=0) k++;
	return (q-k);
}

getroot()
{
	strcpy(root, CNLIB);
	if (strlen(root) > 4) {
		root[strlen(root)-9]='\0'; return 1;
	}
	if (getenv("HBF") != NULL) strcpy(root, getenv("HBF"));
	else root[0]='\0';
	return 1;
}
