#include <stdio.h>
#include <stdlib.h>
#include "vga.h"
#include "chinese.h"

int headlen,offset,isch,maplen;
FILE *infile;
char chbuf[32*1000];
SYSCFG sys_config;

displayEnglish()
{
  int i,x,y;

  if (headlen)
    fseek(infile,headlen,SEEK_SET);
  fseek(infile,offset*maplen*2,SEEK_CUR);
  fread(chbuf,maplen*2,256,infile);
  for(i=0;i<256;i++)
    {
      x = (i % 80);
      y = (i / 80)*maplen*2;
      vga1_drawtext(x,y,&chbuf[i*maplen]);
    }
  vga1_getch();
}

displayChinese()
{
  int i,x,y;
  char buf[32];

  if (headlen)
    fseek(infile,headlen,SEEK_SET);
  fseek(infile,offset*maplen*2,SEEK_CUR);
  fread(chbuf,maplen*2,500,infile);
  for(i=0;i<500;i++)
    {
      x = (i % 40)*2;
      y = (i / 40)*maplen*2;
      memset(buf,0,32);
      memcpy(buf,&chbuf[i*maplen*2],maplen*2);
      vga1_drawctext(x,y,buf);
    }
  vga1_getch();
}
main(int argc,char **argv)
{

  headlen = offset = isch = 0;
  sys_config.ttyfd=0;
  headlen = offset = 0;
  while(argv[1][0] == '-')
    {
      switch(argv[1][1])
	{
	case 's':
	  headlen = atoi(argv[1]+2);
	  break;
	case 'l':
	  offset = atoi(argv[1]+2);
	  break;
	case 'd':
	  isch = 1;
	  break;
	case 'm':
	  maplen = atoi(argv[1]+2);
	  break;
	default:
	  printf("Error arg %s",argv[1]);
	}
      argv++;
      argc--;
    }
  if (argc < 2)
    {
      printf("Usage : displayfont [-s <offset>] [-l <offset>] [-m <len>] [-d] <file>\n");
      exit(1);
    }
  
  infile = fopen(argv[1],"r");
  if (infile == NULL)
    {
      printf("Can't open %s\n",argv[1]);
      exit(1);
    }
  printf("Load font %s Head length= %d offset is %d\n",argv[1],headlen,offset);
  printf("FONT SIZE is %d ",maplen);
  if (isch)
    printf("STYLE is Chinese\n");
  else
    printf("STYLE is English\n");
  vga1_setmode(G640x480x16);
  vga1_setcolor(15);
  if (isch)
    displayChinese();
  else
    displayEnglish();
  fclose(infile);
  vga1_setmode(TEXT);
}
	  
