#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "chinese.h"
static char pbuf[1024];
InputHead head;
WordMap mm[30000];

main(int argc,char *argv[])
{
  FILE *infile,*outfile;
  int i,kk,cc,j;
  char c;
  WordMap tt;

  if (argc < 2)
    {
      printf("Usage : mkmulti <def file> <tbl file>\n");
      exit(-1);
    }
  
  infile = fopen(argv[1],"r");
  outfile = fopen(argv[2],"wb");
  if (infile == NULL)
    {
      printf("Definition file %s not exist\n",argv[1]);
      exit(-1);
    }
  if (outfile == NULL)
    {
      printf("Can't open %s table file\n",argv[2]);
      exit(-1);
    }
  /* section 1 */
  while(!feof(infile))
    {
      fgets(pbuf,1024,infile);
      if (strncmp(pbuf,"%%",2) == 0)
	break;
      else if (strncmp(pbuf,"bell",4) == 0)
	head.bell = 1;
      else if (strncmp(pbuf,"full",4) == 0)
	head.full = 1;
      else if (strncmp(pbuf,"mark",4) == 0)
	{
	  char *bb = strchr(pbuf,'[');
	  char *be = strchr(bb,']');
	  *be = 0;
	  strncpy(head.mark,bb,6);
	}
      else
	{
	  printf("Line is invalid\n");
	  printf(pbuf);
	}
    }
  /* section 2 */
  memset(head.cmap.chkey,0,512);    
  memset(head.keymap,255,256);
  memset(head.mapkey,255,256);
  while(fgets(pbuf,1024,infile))
    {
      if (strncmp(pbuf,"%%",2)==0)
	break;
      kk = 0;
      while(pbuf[kk]!=' '&& pbuf[kk] != '\t' && pbuf[kk] && pbuf[kk] != '\n' ) 
	kk++;
      memcpy(&head.cmap.CHKEY[*pbuf],pbuf+1,kk-1);
    }
  kk = 0;
  for(i=0;i<256;i++)
    {
      while(head.cmap.CHKEY[kk] == 0 && kk < 256) kk++;
      if (kk == 256)
	break;
      head.keymap[i] = kk;
      head.mapkey[tolower(kk)]=i;
      head.mapkey[toupper(kk)]=i;
      head.cmap.CHKEY[i] = head.cmap.CHKEY[kk];
      kk++;
    }
  for(;i<256;i++)
    head.cmap.CHKEY[i] = 0;
  for(i=0;i<256;i++)
    {
      c=head.cmap.chkey[i*2];
      head.cmap.chkey[i*2] = head.cmap.chkey[i*2+1];
      head.cmap.chkey[i*2+1]=c;
    }
  fwrite((char *)&head,sizeof(InputHead),1,outfile);
  /* section 3 */
  cc = 0;
  while(fgets(pbuf,1024,infile))
    {
      if (strncmp(pbuf,"%%",2) == 0)
	break;
      /* If the first char in a line is blank,we think it as comment */
      if (isspace(*pbuf))
	continue;
      memset(mm[cc].seqs,255,5);
      for(i=0;i<5;i++)
	{
	  if (pbuf[i]!= ' ')
	    mm[cc].seqs[i] = head.mapkey[pbuf[i]];
	  else
	    break;
	  
	}
      while(pbuf[i] == ' ') i++;
      mm[cc].word.code[1] = pbuf[i];
      mm[cc].word.code[0] = pbuf[i+1];
      mm[cc].order = cc;
      cc++;
    }
  printf("Begin sort.Please wait\n");
  SortTable(cc);
  for(i=0;i<cc-1;i++)
    if (memcmp2(mm+i,mm+i+1,5) > 0)
      printf("ERROR %d\n",i);
  fwrite(mm,sizeof(WordMap),cc,outfile);
  fclose(infile);
  fclose(outfile);
}
	  
#define M 7
#define NSTACK 10000
#define FM 7875
#define FA 211
#define FC 1663
int memcmp2(WordMap *d1,WordMap *d2,int len)
{
  int st;
  st = memcmp(d1->seqs,d2->seqs,len);
  if (st == 0)
    {
      if (d1->order > d2->order)
	return 1;
      else if (d1->order < d2->order)
	return -1;
      else
	return 0;
    }
  else
    return st;
}
	  
SortTable(int n)
{
  int l=0,jstack=0,j,ir,iq,i;
  int istack[NSTACK+1];
  int fx=0;
  WordMap a;
  
  ir = n;
  for(;;)
    {
      if (ir-l < M)
	{
	  for(j=l+1;j<=ir;j++)
	    {
	      a = mm[j];
	      for(i=j-1;memcmp2(mm+i,&a,5)>0 && i >=0;i--)
		mm[i+1] = mm[i];
	      mm[i+1] = a;
	    }
	  if (jstack == 0)
	    return;
	  ir = istack[jstack--];
	  l = istack[jstack--];
	}
      else
	{
	  i = l;
	  j = ir;
	  fx = (fx*FA+FC)%FM;
	  iq = l+((ir-l+1)*fx)/FM;
	  a = mm[iq];
	  mm[iq] = mm[l];
	  for(;;)
	    {
	      while(j>=0 && memcmp2(&a,mm+j,5) < 0) j--;
	      if (j <= i)
		{
		  mm[i] = a;
		  break;
		}
	      mm[i++] = mm[j];
	      while(memcmp2(&a,mm+i,5)>0 && i <= n) i++;
	      if (j <= i)
		{
		  mm[(i=j)] = a;
		  break;
		}
	      mm[j--] = mm[i];
	    }
	  if (ir-i >= i-1)
	    {
	      istack[++jstack] = i+1;
	      istack[++jstack] = ir;
	      ir = i-1;
	    }
	  else
	    {
	      istack[++jstack]=l;
	      istack[++jstack]=i-1;
	      l = i+1;
	    }
	  if (jstack > NSTACK)
	    {
	      printf("NSTACK too small in Quick sort\n");
	      exit(1);
	    }
	}
    }
}





