#include	"def.h"

#include	<ctype.h>
#include	<signal.h>
#include	<string.h>
#ifdef	CURSESX
#include	<cursesX.h>
#else
#include	<curses.h>
#endif

#define otherBracket(c) (c == '<' ? '>' : ']')
#define printable(c) (((c)>31 && (c)<127) || (c)==9 || (c)==10)

extern char editor[];

/* values for links.tcmd */
#define	LINK_COMMAND 10
#define	EXEC_COMMAND 11
#define	INPUT_COMMAND 12
#define	TWDB_COMMAND 13

struct link {
    char lname[MAXFNAME];
    int lx;
    int ly;
    int tcmd;
    int tx;
} links[MAXLINKS];
int nlinks = 0;

struct hist {
    char hfname[MAXFNAME];
    int hlinkno;
    int hpageno;
    char tmpfile[L_tmpnam+12];
    int lines;
} history[MAXHIST];
int nhist = 0;

#ifndef	USEENV
/*	table for variables	*/
struct symt {
	char *name;
	char *value;
} symtab[MAXSYMS];
int nsym = 0;
#endif

int more = FALSE;

/*
 * my strncpy() terminates strings with a null byte.
 * Writes a null byte into the n+1 byte of dst.
 */
char *
mystrncpy(dst, src, n)
char *dst, *src;
int n;
{
    char *val;

    val = strncpy(dst, src, n);
    *(dst+n) = '\0';
    return val;
}

/*
 * push the current filename, link and page number onto the history list
 */
push(fname, cur, page, tfile)
char *tfile;
char *fname;
int cur, page;
{
    if (nhist<MAXHIST)  {
	strcpy(history[nhist].hfname, fname);
	history[nhist].hlinkno = cur;
	history[nhist].hpageno = page;
	strcpy(history[nhist].tmpfile, tfile);
	nhist++;
    }
}

/*
 * pop the previous filename, link and page number from the history list
 */
char *
pop(cur, page)
int *cur, *page;
{
    if (nhist>0) {
	nhist--;
	if (strlen(history[nhist].tmpfile) != 0)
		unlink(history[nhist].tmpfile);
	*cur = history[nhist].hlinkno;
	*page = history[nhist].hpageno;
	return(history[nhist].hfname);
    } else {
	return(" ");
    }
}

void cleanup()
{
    int lastx=1, lasty=1;

    while (nhist > 0) {
	int d;
	pop(&d, &d);
    }
    move(LINES-1, 0);
    mvcur(lasty, lastx, LINES-1, 0);
    clrtoeol();
    refresh();
    stopCurses();
}

void returnToContinue()
{
	char answer[MAXLINELENGTH];
	printf("Press <return> to continue");
	fflush(stdout);
	scanf("%c", answer);
}

/*
 * here's where we do all the work
 */
mainloop(startfile)
char *startfile;
{
    int  c, arrowup=FALSE, show_help=FALSE;
    int  cur = 0, savcur = 0;
    int  oldpage = 0, newpage = 1, savpage = 1;
    char oldfile[MAXFNAME], newfile[MAXFNAME];

    char *cp;
    FILE *fp = NULL, *oldfp;
	int redrawafteredit;

    strcpy(newfile, startfile);

    for (;;) {
	if (strcmp(oldfile, newfile) != 0) {
	    /*
	     * Try to open the new file.
	     * If the file is not found in the current directory, use
	     * the first three letters of the filename as a directory name,
	     * and try again.  This is for compatibility with HYPERRES,
	     * not because I like it.
	     */
	    oldfp = fp;
	    if ((fp=fopenWithSearchPath(newfile, "r")) != NULL) {
		if (oldfp != NULL)
		    (void) fclose(oldfp); /* close previous file */
		oldpage = 0; /* to force a showpage() */
		newpage = savpage;
		savpage = 1;
		strcpy(oldfile, newfile);
		history[nhist-1].lines = countLines(fp);
	    } else { /* file is not found */
/*
statusline(newfile);
*/
		    if (nhist>0)
			strcpy(newfile, pop(&savcur, &savpage));
		    fp = oldfp;
	    }
	    if ((long)ftell(fp) == 0) {
		if (getc(fp) == EOF) { /* file is empty */
		   if (nhist>0)
			strcpy(newfile, pop(&savcur, &savpage));
		} else
		   rewind(fp);
	    }
	}

	if (oldpage != newpage) {
	    if (showpage(fp, newpage, oldpage) > 0) {
		if (arrowup) {
		    cur = nlinks - 1;
		    arrowup = FALSE;
		} else
		    cur = savcur;
		savcur = 0;
		oldpage = newpage;
	    } else {
		newpage = oldpage;
	    }
	}

	if (!show_help) {
	    if (more)
		statusline(MORE);
	    else
		statusline((char *) NULL);
	    pageNumber(newpage);
	}

	highlight(TRUE, cur);	/* highlight current link */

	c = mygetch();

	if (show_help) {
	    if (more)
		statusline(MORE);
	    else
		statusline((char *) NULL);
	    pageNumber(newpage);
	    show_help = FALSE;
	}

	switch(c) {
	case ' ':	/* next page */
	case '+':
	    newpage++;
	    break;
	case 'b':	/* prev page */
	case 'B':
	case '-':
	    newpage--;
	    break;
	case UPARROW:
	case 'k':
	case 'K':
#ifdef	CYCLIC
	    if (cur == 0) {
		highlight(FALSE, cur);
		cur = nlinks-1;
	    } else
#endif
	    if (cur>0) {		/* previous link */
		highlight(FALSE, cur);
		cur--;
	    } else if (oldpage > 1) {	/* previous page */
		newpage--;
		arrowup = TRUE;
	    }
	    break;
	case DNARROW:
	case 'j':
	case 'J':
#ifdef	CYCLIC
	    if (cur == nlinks-1) {
		highlight(FALSE, cur);
		cur = 0;
	    } else
#endif
	    if (cur<nlinks-1) {		/* next link */
		highlight(FALSE, cur);
		cur++;
	    } else {			/* next page */
		newpage++;
	    }
	    break;
	case LTARROW:			/* back up a level */
	case 27: 			/* ESC backs up a level too */
	case 'H':
	case 'h':
	    if (nhist>0)
		strcpy(newfile, pop(&savcur, &savpage));
	    break;
	case RTARROW:			/* follow a link */
	case 'L':
	case 'l':
	case '\n':
	case '\r': /* ACTION */
	    if (nlinks > 0) {
		if (links[cur].tcmd == LINK_COMMAND) {	/* it's a link  */
		    char buf[MAXFNAME], name[MAXFNAME], *link=buf;
		    getlinkname(name, cur);
		    interpolate(link, name); while (*link == ' ') link++;
		    if (*link != '\0')
		        {   /* very simple error checking */
			    strcpy(newfile, link);
			    push(oldfile, cur, newpage, "");
		        }
		}
		else if (links[cur].tcmd == EXEC_COMMAND ||
			 links[cur].tcmd == INPUT_COMMAND ||
			 links[cur].tcmd == TWDB_COMMAND) {
			int wasBrowse = 0;
			char str[MAXFNAME], cmd[MAXFNAME], execKind;
			if (links[cur].tcmd == EXEC_COMMAND) {
			   execKind = (links[cur].lname[1] == '!' ? 1 : 2);
			   getcomdstring(str, cur);
			   interpolate(cmd, str);
			} else {
			   redrawafteredit = edit(cur);
			   if (redrawafteredit == 2) {
				execKind = 3; /* cancelled -- quick hack */
				savcur = cur;
			   } else {
			   gettrigger(str, links[cur].lname);
			   execKind = (str[0] == '!' ? 1 :
					(str[0] == '@' ? 2 : 0));
			   if (execKind)
			     interpolate(cmd, str+1);
			   }
			}
			switch (execKind) {
			case 1:
		        if (strncmp(cmd, predefbrowse, strlen(predefbrowse)) == 0) {
			   wasBrowse = 1;
			   mx(&cmd[strlen(predefbrowse)]);
			   savcur = cur;
			}
		        else
				execshell(cmd); savcur = cur;
			    break;
			case 2:{
			   char tname[MAXFNAME];
#ifdef CONVEX
			   strcpy(tname, tmpnam(0));
#else
 			   strcpy(tname, tempnam("/tmp","hy"));
#endif
			   if (indirect(cmd, tname)) {
				unlink(tname); savcur = cur;
			   } else {
	   			strcpy(newfile, tname);
	   			push(oldfile, cur, newpage, tname);
			   }
			} }
			if (execKind || redrawafteredit) {
			   if (execKind == 1 && wasBrowse == 0 &&
				links[cur].tcmd == EXEC_COMMAND)
				returnToContinue();
			   rewind(fp); oldpage = 0;
			   /* force a redraw */
			}
		}
	    }
	    break;
	case '?':			/* show help text */
	    strcpy (newfile, HELPFILE);
	    push(oldfile, cur, newpage, "");
	    break;
	case 'm':	/* return to main screen */
	case 'M':
	    strcpy (newfile, startfile);
	    cur = 0;
	    nhist = 0;
	    break;
	case 'e':
	case 'E':
	    /* if (nhist == 0 || history[nhist-1].tmpfile[0] == 0) */
	    {
		char cmd[MAXFNAME];
		strcpy(cmd, editor); strcat(cmd, " ");
		strcat(cmd, findWithSearchPath(newfile));
		fclose(fp);
		execshell(cmd);
		fp = fopenWithSearchPath(newfile, "r");
		oldpage = 0;
	    }
	    break;
	case 18:	/* ^R */
	    oldpage = 0; rewind(fp); savcur = cur;
	    break;
	case '!':
	    execshell(getenv("SHELL"));
	    oldpage = 0; rewind(fp); savcur = cur;
	    break;
	case 'q':	/* quit */
	case 'Q':
	case 4:
	case EOF: {
	    char answer[MAXLINELENGTH];
	    prompt("Really want to quit? [y] ", answer);
	    if (answer[0] == '\0' || toupper(answer[0]) == 'Y')
		return;
	    break;
	}
	default:
	    if (more)
		statusline(MOREHELP);
	    else
		statusline(HELP);
	    show_help = TRUE;
#ifdef DEBUG
	    printw("%d", c);
#endif
	    break;
	}
    }
}

execshell(cmd)
char* cmd;
{
	statusline(NULL);
	stopCurses();
	logcommand(cmd);
	(void) system(cmd);
	startCurses();
}

indirect(cmd, tname)
char* cmd, *tname;
{
	int x;

	statusline(NULL);
	strcat(cmd, " > ");	/* redirect stdout */
 	strcat(cmd, tname);	/* mk tmp name */
	strcat(cmd, " 2>&1");	/* redirect stderr too */
	stopCurses();
	x = system(cmd);
	startCurses();
	return(x);
}

/*
 * display one screen of text
 *
 * Read & display one screenfull of text.
 * Looks for (and remembers) links, and converts IBM PC line drawing
 * characters to standard ascii
 *
 * Pre-reads one line from the next page, to ensure that the "- more -"
 * message is only displayed when there really is more.
 */
int
showpage(fp, page, oldpage)
FILE *fp;
int page, oldpage;
{
    int lineno, col;
    static char line[MAXLINELENGTH];
    char *cp, *cp2, *acp;

    if (page < 1)
	page = 1;

    if (page == oldpage) {		/* nothing to do */
	return(0);
    } else if (page < oldpage) {	/* have to back up */
	rewind(fp);
	oldpage = 0;
    }

    if (page == 1 || page != oldpage+1) {
	more = FALSE;
	lineno = oldpage*(LINES-1);
	while (lineno<(page-1)*(LINES-1) &&
		fgets(line, MAXLINELENGTH, fp) != NULL) {
	    lineno++;
	}
    }

    lineno = 0;
    while (lineno<(LINES-1) && (more ||
				fgets(line, MAXLINELENGTH, fp) != NULL)) {
	more = FALSE;
	cp = line+strlen(line)-1;
	if (*cp == 13)
	    *cp = '\0';		/* remove trailing <return> */

	if (lineno == 0) {
	    nlinks = 0;
	    clear();
	}
	col = 0;
	for (cp=line; *cp != '\0' && col < COLS; cp++) {
	    if (!printable(*cp)) {
#ifdef DEBUG
		    /* shouldn't happen - see what we've missed */
		    if (*cp != 13) {
			printw("%d", *cp);
			refresh();
		    }
#endif
		    *cp = ' ';
	    } else if (*cp == '<' || *cp == '[') {	/* start of link? */
		char leftBracket = *cp,
		     rightBracket = otherBracket(*cp);
		for (cp2 = cp+1;
		    *cp2 != rightBracket &&
			/* *cp2 != leftBracket && */
			*cp2 != '\0' &&
		    cp2-cp+1 < MAXFNAME; cp2++)
		    if (*cp2 == '\\')
			cp2++;
		if (*cp2 == rightBracket && nlinks < MAXLINKS) { /* it's a link */
		    links[nlinks].lx = col;
		    links[nlinks].ly = lineno;
		    mystrncpy(links[nlinks].lname, cp, cp2-cp+1);
		    switch (cp[1]) { /* RECORD */
		    case '!':
		    case '@':
			links[nlinks].tcmd = EXEC_COMMAND;
			break;
		    case '$':
		    case '%': {
			char var[MAXFNAME], value[MAXFNAME];
			links[nlinks].tcmd = (cp[1] == '$' ? INPUT_COMMAND
						: TWDB_COMMAND);
			getvar(var, links[nlinks].lname);
			getvalue(value, var);
			if (links[nlinks].tcmd == TWDB_COMMAND ||
				value[0] == '\0') {
				getdefault(value, links[nlinks].lname);
				setvalue(value, var);
			}
			break;
		    }
		    default:
			links[nlinks].tcmd = LINK_COMMAND;
		    }
		    nlinks++;
		    /* this way is easier -- make highlight() do the work */
		    cp = cp2;
		    col += highlight(FALSE, nlinks-1);
		    continue;
		}
	    } else if (*cp == '\t') {	/* expand tabs */
		    col += 7 - (col % 8);
	    } else if (*cp == '\\') {	/* escape */
		cp++;
	    	if (*cp == '~') {	/* interpolate variable */
		    char tmp[MAXFNAME], val[MAXFNAME], *tp, *ep;
		    tp = ++cp; /* start of variable */
		    while (*cp != '\0' && *cp != '~' && *cp != '=') cp++;
                    if (*cp == '=') { /* seen assignment */
		        mystrncpy(tmp, tp, cp-tp);
			ep = cp;
		        while (*cp != '\0' && *cp != '~') cp++;
			mystrncpy(val, ep+1, cp-ep-1);
			setvalue(val, tmp);
		    } else {
		        mystrncpy(tmp, tp, cp-tp);
		    	getvalue(val,tmp);
		    	addstr(val);
		    	col += strlen(val);
		    }
		    if (!*cp) cp--;
		    continue;
		}
	    }
	    addch(*cp);
	    col++;
	}
	lineno++;
	clrtoeol();
#ifdef DEBUG
refresh();
#endif
    }
    if (lineno==(LINES-1) && fgets(line, MAXLINELENGTH, fp) != NULL)
	more = TRUE;
    refresh();
    return(lineno);
}

/*
 * my getch() translates some escape sequences and may fake noecho
 */
mygetch()
{
    int a, b, c;

    c = getch();
    if (c == 27) {	/* handle escape sequence */
	b = getch();
	if (b == '[' || b == 'O')
	    a = getch();
	else
	    a = b;

	switch (a) {
	case 'A': c = UPARROW; break;
	case 'B': c = DNARROW; break;
	case 'C': c = RTARROW; break;
	case 'D': c = LTARROW; break;
	case '5':			/* vt 300 prev. screen */
	    if (b == '[' && getch() == '~')
		c = '-';
	    break;
	case '6':			/* vt 300 next screen */
	    if (b == '[' && getch() == '~')
		c = '+';
	    break;
	}
    }
    return(c);
}


/*
 * highlight (or unhighlight) a given link
 */
highlight(flag, cur)
int flag;
int cur;
{
    int count=0;

    if (nlinks > 0) {
	int i; char buf[MAXFNAME], *p=buf;
	move(links[cur].ly, links[cur].lx);
	if (flag == TRUE)
		attribCurrent(); /* attrset(A_REVERSE); */
	else
		attribSelectable(); /* attrset(A_BOLD); */
	switch (links[cur].tcmd) { /* DISPLAY */
	case EXEC_COMMAND:
		getlabel(buf, cur);
		break;
	case INPUT_COMMAND:
	case TWDB_COMMAND: {
    		int maxWindow=(links[cur].tcmd == TWDB_COMMAND ?
				MAXDBWIN : MAXSYMWIN);
		char var[MAXFNAME];
		buf[0] = '|';
		getvar(var, links[cur].lname);
		getvalue(buf+1, var);
		for (i = strlen(buf); i <= maxWindow; i++) buf[i] = ' ';
		buf[maxWindow+1] = '|';
		buf[maxWindow+2] = '\0';
		break;
	} 
	case LINK_COMMAND:
		getlabel(buf, cur);
		/* p = links[cur].lname; */
	}
	addstr(p);
	count = strlen(p);
	attribNormal(); /* attrset(A_NORMAL); */
	refresh();
    }
    return(count);
}


/*
 * display (or hide) the status line
 */
statusline(text)
char *text;
{
    move(LINES-1,0);
    clrtoeol();
    if (text != NULL) {
	attribStatusLine(); /* attrset(A_REVERSE); */
	if (strlen(text) < (COLS/2)) move(LINES-1,(COLS-strlen(text))/2);
	addstr(text);
	attribNormal(); /* attrset(A_NORMAL); */
    }
    refresh();
}

pageNumber(p)
int p;
{
	char text[20];

	if (history[nhist-1].lines/(LINES-1) <= 1) return;
	sprintf(text, "Page %d/%d", p, history[nhist-1].lines/(LINES-1)+1);
	move(LINES-1, 78-strlen(text));
	attribStatusLine(); /* attrset(A_REVERSE); */
	addstr(text);
	attribNormal(); /* attrset(A_NORMAL); */
	refresh();
}

#ifdef	NOPROTO
int countLines(fp)
FILE* fp;
#else
int countLines(FILE* fp)
#endif
{
	int c, lines = 0;

	while ((c = getc(fp)) != EOF)
		if (c == '\n')
			lines++;
	rewind(fp);
	return(lines);
}

char* findDelim(s, c)
char* s;
char c;
{
	char* cp;
	char *rightBracket = &s[strlen(s)-1];

	for (cp = s; cp != rightBracket; cp++)
	    if (*cp == '\\')
		cp++;
	    else if (*cp == c)
		return(cp);
	return(cp);
}

/*
 * extract the filename portion of a link <filename[ ...]>
 */
getlinkname(buf, cur)
char *buf;
int cur;
{
    char *cp;

	cp = findDelim(links[cur].lname, ':'); /* OK due to interpolate */
	mystrncpy(buf, links[cur].lname+1, cp - links[cur].lname - 1);
}

/*
getlinkname(buf, cur)
int cur;
char *buf;
{
    char *cp;

    if (nlinks > 0) {
	char *rightBracket = &links[cur].lname[strlen(links[cur].lname)-1];
	for (cp=links[cur].lname+1; cp != rightBracket && *cp != '\0'; cp++) {
	    if (*cp == ':') break;
	    *buf = *cp;
#ifndef	CASESEN
	    if (isupper(*buf))
		*buf = tolower(*buf);
#endif
	    buf++;
	}
    }
    *buf = '\0';
}
*/

getlabel(buf, cur)
char *buf;
int cur;
{
    char *cp;

	cp = findDelim(links[cur].lname, ':');
	buf[0] = links[cur].lname[0];
	if (*cp == ':')
		strcpy(buf+1, cp+1);
	else
		strcpy(buf+1, links[cur].lname+1);
}

getvar(buf, field)
char *buf, *field;
{
	char *cp;

	cp = findDelim(field, '=');
	mystrncpy(buf, field+2, cp - field - 2);	/* BUGGY! */
}

getdefault(buf, field)
char *buf, *field;
{
	char *cp1, *cp2;
	char tmp[MAXFNAME];

	cp1 = findDelim(field, '=');
	if (*cp1 == '=') {
	    cp2 = findDelim(cp1, '@');
	    if (*cp2 != '@') cp2 = findDelim(cp1, '!');
	    mystrncpy(tmp, cp1+1, cp2 - cp1 - 1);
	    interpolate(buf, tmp);
	} else
	    buf[0] = '\0';
}

gettrigger(buf, field)
char *buf, *field;
{
	char *cp1, *cp2;
	cp1 = findDelim(field, '=');
	if (*cp1 == '=') {
	    cp2 = findDelim(cp1, '@');
	    if (*cp2 != '@') cp2 = findDelim(cp1, '!');
	    if (*cp2 == '@' || *cp2 == '!') {
		strcpy(buf, cp2);
		buf[strlen(buf)-1] = '\0';
	    } else
		buf[0] = '\0';
	} else
	    buf[0] = '\0';
}

getcomdstring(buf, cur)
char *buf;
int cur;
{
    char *cp;

	cp = findDelim(links[cur].lname, ':'); /* OK due to interpolate */
	mystrncpy(buf, links[cur].lname+2, cp - links[cur].lname - 2);
}

interpolate(buf, p)
char *buf, *p;
{
	while (*p)
	    if (*p == '\\') {
		p++;
		*buf++ = *p++;
	    } else
	    if (*p == '$') {
		char vname[MAXFNAME], *np, val[MAXFNAME];
		p++;
		np = vname;
		while ((*p >= 'a' && *p <= 'z') ||
			(*p >= 'A' && *p <= 'Z') ||
			(*p >= '0' && *p <= '9')) /* get var name */
		    *np++ = *p++;
		*np = '\0';
		getvalue(val, vname);
		np = val;
		while (*np)	/* copy value */
		    *buf++ = *np++;
	    } else
		*buf++ = *p++;
    *buf = '\0';
}

char V_PWD[] = "PWD";	/* special -- use getwd */

void getvalue(buf, name)
char *buf, *name;
{
	int i;
	char* b;

	if (strcmp(name, V_PWD) == 0) {
		getwd(buf);
		return;
	}
	buf[0] = '\0';
#ifdef	USEENV
	if (b = getenv(name))
		strcpy(buf, b);
#else
	for (i = 0; i<nsym; i++)
		if (strcmp(name, symtab[i].name) == 0) {
			strcat(buf, symtab[i].value);
			break;
		}
#endif
}

void setvalue(buf, var)
char *buf, *var;
{
	int i;

	if (strcmp(var, V_PWD) == 0) {
		char p[MAXFNAME];
		getwd(p);
		if (chdir(buf)) chdir(p);
		return;
	}
#if	USEENV
	if (strlen(buf) == 0)
		unsetenv(var);
	else
		setenv(var, buf, 1);
#else
	for (i = 0; i<nsym; i++)
		if (strcmp(var, symtab[i].name) == 0)
			break;
	if (i == MAXSYMS) return;
	if (i == nsym) {
		nsym++;
		symtab[i].name = malloc(strlen(var)+1);
		strcpy(symtab[i].name, var);
	} else
		free(symtab[i].value);
	symtab[i].value = malloc(strlen(buf)+1);
	strcpy(symtab[i].value, buf);
#endif
}

edit(cur)
{
    char buf[MAXFNAME+1], var[MAXFNAME+1];
    int i, ch, pos = 0, offset = 0, redraw = 1;
	int redrawafteredit = 0;
	int maxWindow=(links[cur].tcmd == TWDB_COMMAND ? MAXDBWIN : MAXSYMWIN);

    getvar(var, links[cur].lname);
    getvalue(buf, var);
    for (i = strlen(buf); i<MAXFNAME; i++) buf[i] = ' ';
	statusline(FIELDHELP);
    attribInputForm(); /* attrset(A_UNDERLINE|A_BOLD); */
    for (;;) {	/* currently, only simple version */
	if  (pos - offset + 1 >= maxWindow) {
	     redraw = 1;
	     offset = offset+1;
	} else if (pos <= offset) {
	     redraw = 1;
	     offset = max(0,pos-2);
	}
	if (redraw) {
	     for (i = offset; i<offset+maxWindow; i++) {
		move(links[cur].ly,  links[cur].lx+i-offset+1);
		addch(buf[i]);
	     }
	     redraw = 0;
	}
	move(links[cur].ly, links[cur].lx+pos-offset+1);
	refresh();
	ch = mygetch();
	if (ch == erasech || ch == ruboutch) { /* delete */
	    if (ch == erasech && pos)
		pos--;
	    for (i = pos; i<MAXFNAME-2; i++)
		buf[i] = buf[i+1];
	    buf[MAXFNAME-1] = ' ';
	    redraw = 1;
	} else if (ch < ' ') {
		if (ch == 7) return(2); /* quick hack */
		if (ch == '\02') {
			strcpy(buf, mx((char *)0));
			redrawafteredit = 1;
		}
		break;
	}
	else switch (ch) {
	case LTARROW:
		if (pos) pos--;
		break;
	case RTARROW:
		if (offset+pos<MAXFNAME) pos++;
		break;
	case UPARROW:
	case DNARROW:
		goto endedit;
	default:
		if ((pos != MAXFNAME) && (buf[MAXFNAME-1] == ' ')) {
	    	    for (i = MAXFNAME-2; pos <= i; i--)
			buf[i+1] = buf[i];
		    redraw = 1;
		    addch(buf[pos] = ch);
		    pos++;
		}
	}
    }
	endedit:
    for (i = MAXFNAME-1; i>0 && buf[i] == ' '; i--) ;
    buf[i+1] = '\0';
    setvalue(buf, var);
	return(redrawafteredit);
}

void initVariables()
{
    int l;
    char line[MAXLINELENGTH+1];
    char var[MAXFNAME], *cp;

    FILE *fp = fopenWithSearchPath(".hybrowrc", "r");
    if (!fp) return;
    while (fgets(line, MAXLINELENGTH, fp) != NULL) {
	if (line[0] == '#' || line[0] == ';')
		/* skip comments */
		continue;
	while ((l = strlen(line)) > 0)
		if (line[l-1] == '\n' ||
			line[l-1] == ' ' ||
			line[l-1] == '\t')
		/* skip trailing spaces */
			line[l-1] = '\0';
		else
			break;
	cp = strchr(line, '=');
	if (!cp) continue;
	mystrncpy(var, line, cp - line);
	setvalue(cp+1, var);
    }
    fclose(fp);
}
