#include	"def.h"

#include	<ctype.h>
#include	<signal.h>
#include	<string.h>


char *searchPath[MAXSEARCHPATH] = { NULL };

void addSearchPath(p)
char *p;
{
	int i;

	if (p[0] == '\0') /* if empty string, use current directory */
		p = ".";
	for (i = 0; i < MAXSEARCHPATH && searchPath[i] != NULL; i++)
		;
	if (i < MAXSEARCHPATH) {
		searchPath[i] = malloc(strlen(p)+1);
		strcpy(searchPath[i],p);
		searchPath[i+1] = NULL;
	}
}

void extendSearchPath(p)
char *p;
{
	while (p) {
		char *np = strchr(p, ':');
		if (np) {
			*np = '\0';
			addSearchPath(p);
			p = np+1;
		} else {
			addSearchPath(p);
			return;
		}
	}
}

FILE *fopenWithSearchPath(fn, mode)
char *fn, *mode;
{
	int i;
	FILE *fd;
	char nf[MAXFNAME];

	if (fn[0] == '/')
		return(fopen(fn, mode));
	else /* for relative pathnames, look up for alternative paths */
	   for (i = 0; i<MAXSEARCHPATH; i++) {
		if (searchPath[i] == NULL)
			return(NULL);
		strcpy(nf, searchPath[i]); strcat(nf, "/"); strcat(nf, fn);
		fd = fopen(nf, mode);
		if (fd != NULL)
			return(fd);
	   }
}

char *findWithSearchPath(fn)
char *fn;
{
	int i;
	FILE *fd;
	static char nf[MAXFNAME];

	if (fn[0] == '/')
		return(fn);
	else /* for relative pathnames, look up for alternative paths */
	   for (i = 0; i<MAXSEARCHPATH; i++) {
		if (searchPath[i] == NULL)
			return("");
		strcpy(nf, searchPath[i]); strcat(nf, "/"); strcat(nf, fn);
		fd = fopen(nf, "r");
		if (fd != NULL) {
			close(fd);
			return(nf);
		}
	   }
}
