#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "safedelete.h"

int  main(int argc, char **argv)
{
char InLog[WORK_BUF_LEN];
char InLogOld[WORK_BUF_LEN];
char OutLog[WORK_BUF_LEN];
char NewDir[256], OldDir[256];
char WorkBuf[WORK_BUF_LEN];
FILE *in, *out;
char *inbuf, *outbuf, *CurrIn;
char *wrkptr, *LoginName, *HomeDir;
int  j;
struct stat FileInfo, DirInfo;
file_struct fs;
struct passwd *UserInfo;

  HomeDir=getenv("HOME");
  if(HomeDir == NULL)
  {
    LoginName=getlogin();
    UserInfo=getpwnam(LoginName);
    HomeDir=UserInfo->pw_dir;
  }

  strcpy(NewDir, HomeDir);
  strcat(NewDir, SAFE_DIR_NAME);
  strcpy(InLog, HomeDir);
  strcat(InLog, "/.safedelete.log");
  strcpy(InLogOld, HomeDir);
  strcat(InLogOld, "/.safedelete.log.old");
  strcpy(OutLog, HomeDir);
  strcat(OutLog, "/.safedelete.log.new");

  if(stat(InLog, &FileInfo) != 0)
    return 1;
  if(FileInfo.st_size < 30)
  {
    printf("safecnvt: your .safedelete.log is empty, conversion not needed\n");
    return 0;
  }

/* Convert the old .safedelete.log to the new format */

  printf("safecnvt: converting your .safedelete.log\n");

  CurrIn=inbuf=malloc(2*FileInfo.st_size);
  outbuf=inbuf+FileInfo.st_size;
  in=fopen(InLog, "r");
  fread(inbuf, FileInfo.st_size, 1, in);
  fclose(in);

/* See if the .safedelete.log was previously converted */

  if(*inbuf != '/')
    printf("safecnvt: your .safedelete.log was previously converted\n");
  else
  {
    fs.Version=0;
    fs.FileFlag=0;
    fs.Mode=0;
    fs.Uid=0;
    fs.Gid=0;
    fs.Size=0;
    fs.Atime=0;
    fs.Mtime=0;

    out=fopen(OutLog, "w");

    while((long)(CurrIn-inbuf) < FileInfo.st_size)
    {
      wrkptr=strchr(CurrIn, '\n')+1;   /* Look for start of next record */
      j=(int)(wrkptr-CurrIn);
      memcpy(outbuf+2, CurrIn, j);     /* Copy record to area */
      CurrIn+=j;                       /* Point to next input record */
      wrkptr=strchr(outbuf+2, '\t');   /* End filename with null */
      *wrkptr='\0';
      wrkptr=strchr(wrkptr+1, '\n');   /* End grunged name with null */
      *wrkptr='\0';
      wrkptr++;                        /* Point past grunged name */
      j=(int)(wrkptr-outbuf);
      if(j%2)
      {
        *wrkptr=127;
        wrkptr++;
        j++;
      }
      memcpy(wrkptr, &fs, sizeof(fs));
      j+=sizeof(fs);
      memcpy(outbuf, &j, 2);           /* Set length of new record */
      fwrite(outbuf, j, 1, out);
    }
    fclose(out);
    rename(InLog, InLogOld);
    rename(OutLog, InLog);
  }
  free(inbuf);

/* Move the files from the old SafeDelete 
   directory to the new one.
*/

  printf("safecnvt: enter the complete path where your safedeleted files are\n");
  printf("safecnvt: currently kept ==> ");
  fgets(OldDir, 256, stdin);
  wrkptr=strchr(OldDir, '\n');
  *wrkptr='\0';

/* Make target directory if it doesn't exist */

  if(stat(NewDir, &DirInfo) != 0)
  {
    printf("safecnvt: creating %s\n", NewDir);
    mkdir(NewDir, S_IRWXU);
  }
  
  printf("safecnvt: moving your safedeleted files from %s\nsafecnvt: to %s\n", OldDir, NewDir);
  sprintf(WorkBuf, "mv %s/* %s", OldDir, NewDir);
  system(WorkBuf);

  printf("safecnvt: conversion successful!\n");
  return 0;
}
