

/*
 * Copyright (c) 1983, 1988 The Regents of the University of California.
 * All rights reserved
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


/*
 * Write "n" bytes to a descriptor.
 * Use in lace of write() when fd is a stream socket.
 */

int
     writen(fd, ptr, nbytes)
register int    fd;
register char   *ptr;
register int    nbytes;
{
     int     nleft, nwritten;
     
     nleft = nbytes;
     while (nleft > 0) {
	  nwritten = write(fd, ptr, nleft);
	  if (nwritten <= 0)
	       return(nwritten);                    /* error */
	  
	  nleft -= nwritten;
	  ptr   += nwritten;
     }
     return(nbytes - nleft);
}

