/* rot13.c -- rotate or de-rotate a file.
 *
 * Author: Marc Unangst <mju@mudos.ann-arbor.mi.us>
 *
 * Last modified Wed Aug  8 06:47:47 EDT 1990 by mju
 *
 * Copyright (c) 1990 Marc Unangst.  All Rights Reserved.
 *
 * Distribution permitted in accordance with the GNU Copyleft agreement
 * (contact the author for a copy).
 */

const char Copyright[] = "rot13.c  v1.0 Copyright (c) 1990 Marc Unangst.  All Rights Reserved.";

#include <stdio.h>
#include <stdlib.h>

#ifndef TRUE
#define FALSE 0
#define TRUE  !FALSE
#endif

void main(int argc, char **argv);
char rotate(char c);

/* This is the length of norm[] and rot[] */
#define ALPHALEN    52

char norm[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
char rot[]  = "NOPQRSTUVWXYZABCDEFGHIJKLMnopqrstuvwxyzabcdefghijklm";

void
main(int argc, char **argv)
{
    FILE *input, *output;		/* Input, output buffers */

    /* Bad args */
    if(argc > 3) {
	fprintf(stderr,"rot13: usage: rot13 [input [output]]\n");
	exit(1);
    }

    /* input = stdin; output = stdout */
    if(argc == 1) {
	input = fdopen(fileno(stdin), "r");
	output = fdopen(fileno(stdout), "w");
    }

    /* input = file; output = stdout or file */
    if(argc == 2 || argc == 3) {
	if((input = fopen((char *)argv[1], "r")) == NULL) {
	    fprintf(stderr, "rot13: couldn't open %s for input\n",
		    (char *)argv[1]);
	    exit(1);
	}
	if(argc == 3) {	    /* output = file */
	    if((output = fopen((char *)argv[2], "w")) == NULL) {
		fprintf(stderr, "rot13: couldn't open %s for output\n",
			(char *)argv[2]);
		exit(1);
	    }
	} else		    /* output = stdout */
	    output = fdopen(fileno(stdout), "w");
    }

    /* Main loop -- read a char, rotate it, output it */
    while(!feof(input))
	fputc(rotate(fgetc(input)),output);

    exit(0);
}

char
rotate(char c)
{
    int i;
    int flag = FALSE;

    for(i = 0; i < ALPHALEN; i++)
	if(c == norm[i]) {
	    flag = TRUE;
	    break;
	}

    if(flag == TRUE)
	return(rot[i]);
    else
	return(c);
}
