/*
Copyright Notice
================
BOCHS is Copyright 1994 by Kevin P. Lawton.

BOCHS is shareware for PERSONAL USE only.

For more information, read the file 'LICENSE' included in the bochs
distribution.  If you don't have access to this file, or have questions
regarding the licensing policy, the author may be contacted via:

    US Mail:  Kevin Lawton
              528 Lexington St.
              Waltham, MA 02154

    EMail:    bochs@tiac.net
*/





#include <stdio.h>
#include "bx_bochs.h"



  void
bx_SAHF()
{
  bx_cpu.eflags.sf = (AH & 0x80) >> 7;
  bx_cpu.eflags.zf = (AH & 0x40) >> 6;
  bx_cpu.eflags.af = (AH & 0x10) >> 4;
  bx_cpu.eflags.pf = (AH & 0x04) >> 2;
  bx_cpu.eflags.cf = (AH & 0x01);
}

  void
bx_LAHF()
{
  AH = (bx_cpu.eflags.sf ? 0x80 : 0) |
       (bx_cpu.eflags.zf ? 0x40 : 0) |
       (bx_cpu.eflags.af ? 0x10 : 0) |
       (bx_cpu.eflags.pf ? 0x04 : 0) |
       0x02 |
       (bx_cpu.eflags.cf ? 0x01 : 0);
}

  void
bx_CLC()
{
  bx_cpu.eflags.cf = 0;
}

  void
bx_STC()
{
  bx_cpu.eflags.cf = 1;
}

  void
bx_CLI()
{
  bx_cpu.eflags.if_ = 0; 
}

  void
bx_STI()
{
  bx_cpu.eflags.if_ = 1;
}

  void
bx_CLD()
{
  bx_cpu.eflags.df = 0;
}

  void
bx_STD()
{
  bx_cpu.eflags.df = 1;
}

  void
bx_CMC()
{
  bx_cpu.eflags.cf = 1 - bx_cpu.eflags.cf;
}

  void
bx_write_eflags(Bit32u eflags)
{
  bx_cpu.eflags.cf = eflags & 0x01;
  bx_cpu.eflags.pf = (eflags >> 2) & 0x01;
  bx_cpu.eflags.af = (eflags >> 4) & 0x01;
  bx_cpu.eflags.zf = (eflags >> 6) & 0x01;
  bx_cpu.eflags.sf = (eflags >> 7) & 0x01;
  bx_cpu.eflags.tf = (eflags >> 8) & 0x01;
  bx_cpu.eflags.if_ = (eflags >> 9) & 0x01;
  bx_cpu.eflags.df = (eflags >> 10) & 0x01;
  bx_cpu.eflags.of = (eflags >> 11) & 0x01;
  bx_cpu.eflags.iopl = (eflags >> 12) & 0x03;
  bx_cpu.eflags.nt = (eflags >> 14) & 0x01;
  bx_cpu.eflags.rf = (eflags >> 16) & 0x01;
  bx_cpu.eflags.vm = (eflags >> 17) & 0x01;
  bx_cpu.eflags.ac = (eflags >> 18) & 0x01;
}

  void
bx_write_flags(Bit32u flags)
{
  bx_cpu.eflags.cf = flags & 0x01;
  bx_cpu.eflags.pf = (flags >> 2) & 0x01;
  bx_cpu.eflags.af = (flags >> 4) & 0x01;
  bx_cpu.eflags.zf = (flags >> 6) & 0x01;
  bx_cpu.eflags.sf = (flags >> 7) & 0x01;
  bx_cpu.eflags.tf = (flags >> 8) & 0x01;
  bx_cpu.eflags.if_ = (flags >> 9) & 0x01;
  bx_cpu.eflags.df = (flags >> 10) & 0x01;
  bx_cpu.eflags.of = (flags >> 11) & 0x01;
  bx_cpu.eflags.iopl = (flags >> 12) & 0x03;
  bx_cpu.eflags.nt = (flags >> 14) & 0x01;
}
