/*
Copyright Notice
================
BOCHS is Copyright 1994 by Kevin P. Lawton.

BOCHS is shareware for PERSONAL USE only.

For more information, read the file 'LICENSE' included in the bochs
distribution.  If you don't have access to this file, or have questions
regarding the licensing policy, the author may be contacted via:

    US Mail:  Kevin Lawton
              528 Lexington St.
              Waltham, MA 02154

    EMail:    bochs@tiac.net
*/





/* ------ One byte opcode stuff ------ */
/* 0x00 - 0x0F */
void bx_ADD_EbGb();
void bx_ADD_EvGv();
void bx_ADD_GbEb();
void bx_ADD_GvEv();
void bx_ADD_ALIb();
void bx_ADD_eAXIv();
void bx_PUSH_ES();
void bx_POP_ES();
void bx_OR_EbGb();
void bx_OR_EvGv();
void bx_OR_GbEb();
void bx_OR_GvEv();
void bx_OR_ALIb();
void bx_OR_eAXIv();
void bx_PUSH_CS();
void bx_TWO_BYTE_ESC();

/* 0x10 - 0x1F */
void bx_ADC_EbGb();
void bx_ADC_EvGv();
void bx_ADC_GbEb();
void bx_ADC_GvEv();
void bx_ADC_ALIb();
void bx_ADC_eAXIv();
void bx_PUSH_SS();
void bx_POP_SS();
void bx_SBB_EbGb();
void bx_SBB_EvGv();
void bx_SBB_GbEb();
void bx_SBB_GvEv();
void bx_SBB_ALIb();
void bx_SBB_eAXIv();
void bx_PUSH_DS();
void bx_POP_DS();

/* 0x20 - 0x2F */
void bx_AND_EbGb();
void bx_AND_EvGv();
void bx_AND_GbEb();
void bx_AND_GvEv();
void bx_AND_ALIb();
void bx_AND_eAXIv();
void bx_ES();
void bx_DAA();
void bx_SUB_EbGb();
void bx_SUB_EvGv();
void bx_SUB_GbEb();
void bx_SUB_GvEv();
void bx_SUB_ALIb();
void bx_SUB_eAXIv();
void bx_CS();
void bx_DAS();

/* 0x30 - 0x3F */
void bx_XOR_EbGb();
void bx_XOR_EvGv();
void bx_XOR_GbEb();
void bx_XOR_GvEv();
void bx_XOR_ALIb();
void bx_XOR_eAXIv();
void bx_SS();
void bx_AAA();
void bx_CMP_EbGb();
void bx_CMP_EvGv();
void bx_CMP_GbEb();
void bx_CMP_GvEv();
void bx_CMP_ALIb();
void bx_CMP_eAXIv();
void bx_DS();
void bx_AAS();

/* 0x40 - 0x4F */
void bx_INC_eAX();
void bx_INC_eCX();
void bx_INC_eDX();
void bx_INC_eBX();
void bx_INC_eSP();
void bx_INC_eBP();
void bx_INC_eSI();
void bx_INC_eDI();
void bx_DEC_eAX();
void bx_DEC_eCX();
void bx_DEC_eDX();
void bx_DEC_eBX();
void bx_DEC_eSP();
void bx_DEC_eBP();
void bx_DEC_eSI();
void bx_DEC_eDI();

/* 0x50 - 0x5F */
void bx_PUSH_eAX();
void bx_PUSH_eCX();
void bx_PUSH_eDX();
void bx_PUSH_eBX();
void bx_PUSH_eSP();
void bx_PUSH_eBP();
void bx_PUSH_eSI();
void bx_PUSH_eDI();
void bx_POP_eAX();
void bx_POP_eCX();
void bx_POP_eDX();
void bx_POP_eBX();
void bx_POP_eSP();
void bx_POP_eBP();
void bx_POP_eSI();
void bx_POP_eDI();

/* 0x60 - 0x6F */
void bx_PUSHAD();
void bx_POPAD();
void bx_BOUND_GvMa();
void bx_ARPL_EwRw();
void bx_FS();
void bx_GS();
void bx_OPSIZE();
void bx_ADRSIZE();
void bx_PUSH_Iv();
void bx_IMUL_GvEvIv();
void bx_PUSH_Ib();
void bx_IMUL_GvEvIb();
void bx_INSB_YbDX();
void bx_INSW_YvDX();
void bx_OUTSB_DXXb();
void bx_OUTSW_DXXv();

/* 0x70 - 0x7F */
void bx_JO_Jb();
void bx_JNO_Jb();
void bx_JB_Jb();
void bx_JNB_Jb();
void bx_JZ_Jb();
void bx_JNZ_Jb();
void bx_JBE_Jb();
void bx_JNBE_Jb();
void bx_JS_Jb();
void bx_JNS_Jb();
void bx_JP_Jb();
void bx_JNP_Jb();
void bx_JL_Jb();
void bx_JNL_Jb();
void bx_JLE_Jb();
void bx_JNLE_Jb();

/* 0x80 - 0x8F */
/* NULL, GROUP1 EbIb */
/* NULL, GROUP1 EvIv */
/* NULL, INVALID */
/* NULL, GROUP1 EvIb */
void bx_TEST_EbGb();
void bx_TEST_EvGv();
void bx_XCHG_EbGb();
void bx_XCHG_EvGv();
void bx_MOV_EbGb();
void bx_MOV_EvGv();
void bx_MOV_GbEb();
void bx_MOV_GvEv();
void bx_MOV_EwSw();
void bx_LEA_GvM();
void bx_MOV_SwEw();
void bx_POP_Ev();

/* 0x90 - 0x9F */
/* NULL, NOP */
void bx_XCHG_eCSeAX();
void bx_XCHG_eDXeAX();
void bx_XCHG_eBXeAX();
void bx_XCHG_eSPeAX();
void bx_XCHG_eBPeAX();
void bx_XCHG_eSIeAX();
void bx_XCHG_eDIeAX();
void bx_CBW();
void bx_CWD();
void bx_CALL_Ap();
void bx_WAIT();
void bx_PUSHF_Fv();
void bx_POPF_Fv();
void bx_SAHF();
void bx_LAHF();

/* 0xA0 - 0xAF */
void bx_MOV_ALOb();
void bx_MOV_eAXOv();
void bx_MOV_ObAL();
void bx_MOV_OveAX();
void bx_MOVSB_XbYb();
void bx_MOVSW_XvYv();
void bx_CMPSB_XbYb();
void bx_CMPSW_XvYv();
void bx_TEST_ALIb();
void bx_TEST_eAXIv();
void bx_STOSB_YbAL();
void bx_STOSW_YveAX();
void bx_LODSB_ALXb();
void bx_LODSW_eAXXv();
void bx_SCASB_ALXb();
void bx_SCASW_eAXXv();

/* 0xB0 - 0xBF */
void bx_MOV_ALIb();
void bx_MOV_CLIb();
void bx_MOV_DLIb();
void bx_MOV_BLIb();
void bx_MOV_AHIb();
void bx_MOV_CHIb();
void bx_MOV_DHIb();
void bx_MOV_BHIb();
void bx_MOV_eAXIv();
void bx_MOV_eCXIv();
void bx_MOV_eDXIv();
void bx_MOV_eBXIv();
void bx_MOV_eSPIv();
void bx_MOV_eBPIv();
void bx_MOV_eSIIv();
void bx_MOV_eDIIv();

/* 0xC0 - 0xCF */
/* NULL, group 2 */
/* NULL, group 2 */
void bx_RETnear_lw();
void bx_RETnear();
void bx_LES_GvMp();
void bx_LDS_GvMp();
void bx_MOV_EbIb();
void bx_MOV_EvIv();
void bx_ENTER_IwIb();
void bx_LEAVE();
void bx_RETfar_lw();
void bx_RETfar();
void bx_INT3();
void bx_INT_Ib();
void bx_INTO();
void bx_IRET();

/* 0xD0 - 0xDF */
/* group2 Eb1 */
/* group2 Ev1 */
/* group2 EbCL */
/* group2 EvCL */
void bx_AAM();
void bx_AAD();
/* NULL, INVALID */
void bx_XLAT();
/* NULL, ESC0 */
/* NULL, ESC1 */
/* NULL, ESC2 */
/* NULL, ESC3 */
/* NULL, ESC4 */
/* NULL, ESC5 */
/* NULL, ESC6 */
/* NULL, ESC7 */

/* 0xE0 - 0xEF */
void bx_LOOPNE_Jb();
void bx_LOOPE_Jb();
void bx_LOOP_Jb();
void bx_JCXZ_Jb();
void bx_IN_ALIb();
void bx_IN_eAXIb();
void bx_OUT_IbAL();
void bx_OUT_IbeAX();
void bx_CALL_Av();
void bx_JMP_Jv();
void bx_JMP_Ap();
void bx_JMP_Jb();
void bx_IN_ALDX();
void bx_IN_eAXDX();
void bx_OUT_DXAL();
void bx_OUT_DXeAX();

/* 0xF0 - 0xFF */
/* NULL, LOCK */
/* NULL, INVALID */
/* NULL, REPNE */
/* NULL, REP */
void bx_HLT();
void bx_CMC();
/* NULL, GROUP3 Eb */
/* NULL, GROUP3 Ev */
void bx_CLC();
void bx_STC();
void bx_CLI();
void bx_STI();
void bx_CLD();
void bx_STD();
/* NULL, GROUP4 */
/* NULL, GROUP5 */


/* ------ Two byte opcode stuff ------ */
/* 0x00 - 0x0F */
/* NULL, GROUP6 */
/* NULL, GROUP7 */
void bx_LAR_GvEw();
void bx_LSL_GvEw();
/* NULL, INVALID */
/* NULL, INVALID */
void bx_CLTS();
/* NULL, INVALID */
void bx_INVD();
void bx_WBINVD();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* 0x10 - 0x1F */
void bx_INVLPG_Ea();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* 0x20 - 0x2F */
void bx_MOV_CdRd();
void bx_MOV_DdRd();
void bx_MOV_RdCd();
void bx_MOV_RdDd();
void bx_MOV_TdRd();
/* NULL, INVALID */
void bx_MOV_RdTd();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* 0x30 - 0x3F */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* 0x40 - Ox4F */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* 0x50 - 0x5F */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* 0x60 - 0x6F */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* 0x70 - 0x7F */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* 0x80 - 0x8F */
void bx_JO_Jv();
void bx_JNO_Jv();
void bx_JB_Jv();
void bx_JNB_Jv();
void bx_JZ_Jv();
void bx_JNZ_Jv();
void bx_JBE_Jv();
void bx_JNBE_Jv();
void bx_JS_Jv();
void bx_JNS_Jv();
void bx_JP_Jv();
void bx_JNP_Jv();
void bx_JL_Jv();
void bx_JNL_Jv();
void bx_JLE_Jv();
void bx_JNLE_Jv();

/* 0x90 - 0x9F */
void bx_SETO_Eb();
void bx_SETNO_Eb();
void bx_SETB_Eb();
void bx_SETNB_Eb();
void bx_SETZ_Eb();
void bx_SETNZ_Eb();
void bx_SETBE_Eb();
void bx_SETNBE_Eb();
void bx_SETS_Eb();
void bx_SETNS_Eb();
void bx_SETP_Eb();
void bx_SETNP_Eb();
void bx_SETL_Eb();
void bx_SETNL_Eb();
void bx_SETLE_Eb();
void bx_SETNLE_Eb();

/* A0 - AF */
void bx_PUSH_FS();
void bx_POP_FS();
/* NULL, INVALID */
void bx_BT_EvGv();
void bx_SHLD_EvGvIb();
void bx_SHLD_EvGvCL();


void bx_PUSH_GS();
void bx_POP_GS();
/* NULL, INVALID */
void bx_BTS_EvGv();
void bx_SHRD_EvGvIb();
void bx_SHRD_EvGvCL();
/* NULL, INVALID */
void bx_IMUL_GvEv();

/* B0 - BF */
void bx_A6();
void bx_A7();
void bx_LSS_Mp();
void bx_BTR_EvGv();
void bx_LFS_Mp();
void bx_LGS_Mp();
void bx_MOVZX_GvEb();
void bx_MOVZX_GvEw();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, GROUP8 EvIb */
void bx_BTC_EvGv();
void bx_BSF_GvEv();
void bx_BSR_GvEv();
void bx_MOVSX_GvEb();
void bx_MOVSX_GvEw();

/* C0 - CF */
void bx_XADD_EbRb();
void bx_XADD_EvRv();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
void bx_BSWAP_EAX();
void bx_BSWAP_ECX();
void bx_BSWAP_EDX();
void bx_BSWAP_EBX();
void bx_BSWAP_ESP();
void bx_BSWAP_EBP();
void bx_BSWAP_ESI();
void bx_BSWAP_EDI();

/* D0 - DF */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* E0 - EF */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* F0 - FF */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */


/* --------- MOD R/M OPCODE STUFF -------- */

/* GROUP1[EbIb] */
void bx_ADD_EbIb();
void bx_OR_EbIb();
void bx_ADC_EbIb();
void bx_SBB_EbIb();
void bx_AND_EbIb();
void bx_SUB_EbIb();
void bx_XOR_EbIb();
void bx_CMP_EbIb();

/* GROUP1[EvIv] */
void bx_ADD_EvIv();
void bx_OR_EvIv();
void bx_ADC_EvIv();
void bx_SBB_EvIv();
void bx_AND_EvIv();
void bx_SUB_EvIv();
void bx_XOR_EvIv();
void bx_CMP_EvIv();

/* GROUP1[EvIb] */
void bx_ADD_EvIb();
void bx_OR_EvIb();
void bx_ADC_EvIb();
void bx_SBB_EvIb();
void bx_AND_EvIb();
void bx_SUB_EvIb();
void bx_XOR_EvIb();
void bx_CMP_EvIb();

/* GROUP2[EbIb] */
void bx_ROL_EbIb();
void bx_ROR_EbIb();
void bx_RCL_EbIb();
void bx_RCR_EbIb();
void bx_SHL_EbIb();
void bx_SHR_EbIb();
/* NULL, INVALID */
void bx_SAR_EbIb();

/* GROUP2[EvIb] */
void bx_ROL_EvIb();
void bx_ROR_EvIb();
void bx_RCL_EvIb();
void bx_RCR_EvIb();
void bx_SHL_EvIb();
void bx_SHR_EvIb();
/* NULL, INVALID */
void bx_SAR_EvIb();

/* GROUP2[Eb1] */
void bx_ROL_Eb1();
void bx_ROR_Eb1();
void bx_RCL_Eb1();
void bx_RCR_Eb1();
void bx_SHL_Eb1();
void bx_SHR_Eb1();
/* NULL, INVALID */
void bx_SAR_Eb1();

/* GROUP2[Ev1] */
void bx_ROL_Ev1();
void bx_ROR_Ev1();
void bx_RCL_Ev1();
void bx_RCR_Ev1();
void bx_SHL_Ev1();
void bx_SHR_Ev1();
/* NULL, INVALID */
void bx_SAR_Ev1();

/* GROUP2[EbCL] */
void bx_ROL_EbCL();
void bx_ROR_EbCL();
void bx_RCL_EbCL();
void bx_RCR_EbCL();
void bx_SHL_EbCL();
void bx_SHR_EbCL();
/* NULL, INVALID */
void bx_SAR_EbCL();

/* GROUP2[EvCL] */
void bx_ROL_EvCL();
void bx_ROR_EvCL();
void bx_RCL_EvCL();
void bx_RCR_EvCL();
void bx_SHL_EvCL();
void bx_SHR_EvCL();
/* NULL, INVALID */
void bx_SAR_EvCL();

/* GROUP3[Eb] */
void bx_TEST_EbIb();
/* NULL, INVALID */
void bx_NOT_Eb();
void bx_NEG_Eb();
void bx_MUL_ALEb();
void bx_IMUL_ALEb();
void bx_DIV_ALEb();
void bx_IDIV_ALEb();

/* GROUP3[Ev] */
void bx_TEST_EvIv();
/* NULL, INVALID */
void bx_NOT_Ev();
void bx_NEG_Ev();
void bx_MUL_eAXEv();
void bx_IMUL_eAXEv();
void bx_DIV_eAXEv();
void bx_IDIV_eAXEv();

/* GROUP4[] */
void bx_INC_Eb();
void bx_DEC_Eb();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* GROUP5[] */
void bx_INC_Ev();
void bx_DEC_Ev();
void bx_CALL_Ev();
void bx_CALL_Ep();
void bx_JMP_Ev();
void bx_JMP_Ep();
void bx_PUSH_Ev();
/* NULL, INVALID */

/* GROUP6[] */
void bx_SLDT_Ew();
void bx_STR_Ew();
void bx_LLDT_Ew();
void bx_LTR_Ew();
void bx_VERR_Ew();
void bx_VERW_Ew();
/* NULL, INVALID */
/* NULL, INVALID */

/* GROUP7[] */
void bx_SGDT_Ms();
void bx_SIDT_Ms();
void bx_LGDT_Ms();
void bx_LIDT_Ms();
void bx_SMSW_Ew();
/* NULL, INVALID */
void bx_LMSW_Ew();
/* NULL, INVALID */


/* GROUP8[EvIb] */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
void bx_BT_EvIb();
void bx_BTS_EvIb();
void bx_BTR_EvIb();
void bx_BTC_EvIb();

/* ------ NDP ESCAPES 0-7 --------- */

/* NDP ESC 0 */
void bx_FADD_Es();
void bx_FMUL_Es();
void bx_FCOM_Es();
void bx_FCOMP_Es();
void bx_FSUB_Es();
void bx_FSUBR_Es();
void bx_FDIV_Es();
void bx_FDIVR_Es();

void bx_FADD_ST_STi();
void bx_FMUL_ST_STi();
void bx_FCOM_ST_STi();
void bx_FCOMP_ST_STi();
void bx_FSUB_ST_STi();
void bx_FSUBR_ST_STi();
void bx_FDIV_ST_STi();
void bx_FDIVR_ST_STi();

/* NDP ESC 1 */
void bx_FLD_Es();
/* NULL, INVALID */
void bx_FST_Es();
void bx_FSTP_Es();
void bx_FLDENV_Ea();
void bx_FLDCW_Ew();
void bx_FSTENV_Ea();
void bx_FSTCW_Ew();

void bx_FLD_ST0();
void bx_FXCH_ST0();
void bx_FNOP();
/* NULL, INVALID */
void bx_FCHS();
void bx_FLD1();
void bx_F2XM1();
void bx_FPREM();

void bx_FLD_ST1();
void bx_FXCH_ST1();
/* NULL, INVALID */
/* NULL, INVALID */
void bx_FABS();
void bx_FLDL2T();
void bx_FYL2X();
void bx_FYL2XP1();

void bx_FLD_ST2();
void bx_FXCH_ST2();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
void bx_FLDL2E();
void bx_FPTAN();
void bx_FSQRT();

void bx_FLD_ST3();
void bx_FXCH_3();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
void bx_FLDPI();
void bx_FPATAN();
void bx_FSINCOS();

void bx_FLD_ST4();
void bx_FXCH_ST4();
/* NULL, INVALID */
/* NULL, INVALID */
void bx_FTST();
void bx_FLDLG2();
void bx_FXTRACT();
void bx_FRNDINT();

void bx_FLD_ST5();
void bx_FXCH_ST5();
/* NULL, INVALID */
/* NULL, INVALID */
void bx_FXAM();
void bx_FLDNLN2();
void bx_FPREMI();
void bx_FSCALE();

void bx_FLD_ST6();
void bx_FXCH_ST6();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
void bx_FLDZ();
void bx_FDECSTP();
void bx_FSIN();
void bx_FLD_ST7();
void bx_FXCH_ST7();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
void bx_FINCSTP();
void bx_FCOS();

/* NDP ESC 2 */
void bx_FIADD_Ew();
void bx_FIMUL_Ew();
void bx_FICOM_Ew();
void bx_FICOMP_Ew();
void bx_FISUB_Ew();
void bx_FISUBR_Ew();
void bx_FIDIV_Ew();
void bx_FIDIVR_Ew();

/* NULL, INVALID */
void bx_FUCOMPP();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* NDP ESC 3 */
void bx_FILD_Ew();
/* NULL, INVALID */
void bx_FIST_Ew();
void bx_FISTP_Ew();
void bx_FLD_Et();
/* NULL, INVALID */
void bx_FSTP_Et();
/* NULL, INVALID */

/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, GROUP3A */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* NDP ESC 3, GROUP3a */
void bx_FENI();
void bx_FDISI();
void bx_FCLEX();
void bx_FINIT();
void bx_FSETPM();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */

/* NDP ESC 4 */
void bx_FADD_El();
void bx_FMUL_El();
void bx_FCOM_El();
void bx_FCOMP_El();
void bx_FSUB_El();
void bx_FSUBR_El();
void bx_FDIV_El();
void bx_FDIVR_El();

void bx_FADD_STi_ST();
void bx_FMUL_STi_ST();
void bx_FCOM_STi_ST();
void bx_FCOMP_STi_ST();
void bx_FSUB_STi_ST();
void bx_FSUBR_STi_ST();
void bx_FDIV_STi_ST();
void bx_FDIVR_STi_ST();

/* NDP ESC 5 */
void bx_FLD_El();
/* NULL, INVALID */
void bx_FST_El();
void bx_FSTP_El();
void bx_FRSTOR_Ea();
/* NULL, INVALID */
void bx_FSAVE_Ea();
void bx_FSTSW_Ew();

void bx_FFREE_STi();
/* NULL, INVALID */
void bx_FST_STi();
void bx_FSTP_STi();
void bx_FUCOM_STi();
void bx_FUCOMP_STi();
/* NULL, INVALID */
/* NULL, INVALID */

/* NDP ESC 6 */
void bx_FIADD_Ed();
void bx_FIMUL_Ed();
void bx_FICOM_Ed();
void bx_FICOMP_Ed();
void bx_FISUB_Ed();
void bx_FISUBR_Ed();
void bx_FIDIV_Ed();
void bx_FIDIVR_Ed();

void bx_FADDP_STi_ST();
void bx_FMULP_STi_ST();
/* NULL, INVALID */
void bx_FCOMPP();
void bx_FSUBP_STi_ST();
void bx_FSUBRP_STi_ST();
void bx_FDIVP_STi_ST();
void bx_FDIVRP_STi_ST();

/* NDP ESC 7 */
void bx_FILD_Ed();
/* NULL, INVALID */
void bx_FIST_Ed();
void bx_FISTP_Ed();
void bx_FBLD_Eb();
void bx_FILD_Eq();
void bx_FBSTP_Eb();
void bx_FISTP_Eq();

void bx_FSTSW_AX();
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */
/* NULL, INVALID */



void bx_CMPXCHG_XBTS(void);
void bx_CMPXCHG_IBTS(void);
void bx_CMPXCHG_EbGb(void);
void bx_CMPXCHG_EvGv(void);
void bx_XADD_EbGb(void);
void bx_XADD_EvGv(void);
void bx_XCHG_eCXeAX(void);
void bx_RETnear_Iw(void);
void bx_RETfar_Iw(void);
void bx_FLD_STi(void);
void bx_FXCH_STi(void);
void bx_FLDLN2(void);
void bx_FPREM1(void);
void bx_FUCOM_STi_ST(void);
void bx_FCOMP_STi(void);
