/*
Copyright Notice
================
BOCHS is Copyright 1994 by Kevin P. Lawton.

BOCHS is shareware for PERSONAL USE only.

For more information, read the file 'LICENSE' included in the bochs
distribution.  If you don't have access to this file, or have questions
regarding the licensing policy, the author may be contacted via:

    US Mail:  Kevin Lawton
              528 Lexington St.
              Waltham, MA 02154

    EMail:    bochs@tiac.net
*/






#include "bx_bochs.h"
#include "iodev/iodev.h"


void bx_INSB_YbDX() {bx_invalid_instruction();}
void bx_INSW_YvDX() {bx_invalid_instruction();}
void bx_OUTSB_DXXb() {bx_invalid_instruction();}
void bx_OUTSW_DXXv() {bx_invalid_instruction();}


  void
bx_IN_ALIb()
{
  AL = bx_inp(bx_fetch_next_byte());
}

  void
bx_IN_eAXIb()
{
  Bit8u imm8;

  imm8 = bx_fetch_next_byte();

  if (bx_32bit_opsize) {
    EAX = 	bx_inp(imm8++) | 
		(bx_inp(imm8++) << 8) | 
		(bx_inp(imm8++) << 16) |
		(bx_inp(imm8) << 24);
     }
  else {
    AX = (bx_inp(imm8++) |
         (bx_inp(imm8) << 8));
    }
}

  void
bx_OUT_IbAL()
{
  Bit8u al;

  al = AL;

  bx_outp(bx_fetch_next_byte(), al);
}

  void
bx_OUT_IbeAX()
{
  Bit8u imm8;
  Bit16u ax;
  Bit32u eax;

  imm8 = bx_fetch_next_byte();

  if (bx_32bit_opsize) {
    eax = EAX;
    bx_outp(imm8++, eax);
    eax >>= 8;
    bx_outp(imm8++, eax);
    eax >>= 8;
    bx_outp(imm8++, eax);
    eax >>= 8;
    bx_outp(imm8, eax);
    }
  else {
    ax = AX;
    bx_outp(imm8++, ax);
    bx_outp(imm8, ax >> 8);
    }
}

  void
bx_IN_ALDX()
{
  AL = bx_inp(DX);
}

  void
bx_IN_eAXDX()
{
  Bit16u dx;
 
  dx = DX;

  if (bx_32bit_opsize) {
    EAX = 	bx_inp(dx++) | 
		(bx_inp(dx++) << 8) | 
		(bx_inp(dx++) << 16) |
		(bx_inp(dx) << 24);
    }
  else {
    AX = bx_inp(dx++) | (bx_inp(dx) << 8);
    }
}

  void
bx_OUT_DXAL()
{
  Bit16u dx;
  Bit8u al;

  dx = DX;
  al = AL;

  bx_outp(dx, al);
}

  void
bx_OUT_DXeAX()
{
  Bit16u dx;
  Bit32u eax;

  dx = DX;

  if (bx_32bit_opsize) {
    eax = EAX;

    bx_outp(dx++, eax);
    eax >>= 8;
    bx_outp(dx++, eax);
    eax >>= 8;
    bx_outp(dx++, eax);
    eax >>= 8;
    bx_outp(dx, eax);
    }
  else {
    eax = AX;  /* only 16bits used */

    bx_outp(dx++, eax);
    bx_outp(dx, eax >> 8);
    }
}
