/*
Copyright Notice
================
BOCHS is Copyright 1994 by Kevin P. Lawton.

BOCHS is shareware for PERSONAL USE only.

For more information, read the file 'LICENSE' included in the bochs
distribution.  If you don't have access to this file, or have questions
regarding the licensing policy, the author may be contacted via:

    US Mail:  Kevin Lawton
              528 Lexington St.
              Waltham, MA 02154

    EMail:    bochs@tiac.net
*/







#include "bx_bochs.h"


void bx_BOUND_GvMa() {bx_invalid_instruction();}

  void
bx_INT3()
{
  Bit16u cs, ip;

  if (bx_32bit_opsize) {
    bx_PUSHF_Fv();
    }
  else {
    bx_PUSHF_Fv();
    }

  cs = bx_cpu.cs.selector.value;
  bx_push_16(cs);
  if (bx_32bit_addrsize) {
    bx_push_32(bx_cpu.eip);
    }
  else {
    ip = bx_cpu.eip;
    bx_push_16(ip);
    }

  bx_access_physical(3 * 4,     2, BX_READ, &ip);
  bx_cpu.eip = ip;
  bx_access_physical(3 * 4 + 2, 2, BX_READ, &cs);
  bx_load_seg_reg(&bx_cpu.cs, cs);


  /* INT3 affects the following flags: I,T */
  bx_cpu.eflags.if_ = 0;
  bx_cpu.eflags.tf  = 0;
#ifdef BX_DEBUG
bx_printf(0, "*** calling INT %02x\n", 3);
bx_printf(0, "*** AH:%02x AL:%02x BH:%02x BL:%02x CH:%02x CL:%02x DH:%02x DL:%02x\n",
   AH, AL, BH, BL, CH, CL, DH, DL);
#endif
}

  void
bx_INT_Ib()
{
  Bit8u imm8;
  Bit16u cs, ip;

  imm8 = bx_fetch_next_byte();

  if (bx_32bit_opsize) {
    bx_PUSHF_Fv();
    }
  else {
    bx_PUSHF_Fv();
    }

  cs = bx_cpu.cs.selector.value;
  bx_push_16(cs);
  if (bx_32bit_addrsize) {
    bx_push_32(bx_cpu.eip);
    }
  else {
    ip = bx_cpu.eip;
    bx_push_16(ip);
    }

  bx_access_physical(imm8 * 4,     2, BX_READ, &ip);
  bx_cpu.eip = ip;
  bx_access_physical(imm8 * 4 + 2, 2, BX_READ, &cs);
  bx_load_seg_reg(&bx_cpu.cs, cs);

  /* INT affects the following flags: I,T */

  bx_cpu.eflags.if_ = 0;
  bx_cpu.eflags.tf  = 0;
#ifdef BX_DEBUG
bx_printf(0, "*** calling INT %02x\n", (int) imm8);
bx_printf(0, "*** AH:%02x AL:%02x BH:%02x BL:%02x CH:%02x CL:%02x DH:%02x DL:%02x\n",
  AH, AL, BH, BL, CH, CL, DH, DL);
#endif
}

  void
bx_INTO()
{
  Bit16u cs, ip;

  if (bx_cpu.eflags.of) {

    if (bx_32bit_opsize) {
      bx_PUSHF_Fv();
      }
    else {
      bx_PUSHF_Fv();
      }

    cs = bx_cpu.cs.selector.value;
    bx_push_16(cs);
    if (bx_32bit_addrsize) {
      bx_push_32(bx_cpu.eip);
      }
    else {
      ip = bx_cpu.eip;
      bx_push_16(ip);
      }

    bx_access_physical(4 * 4,     2, BX_READ, &ip);
    bx_cpu.eip = ip;
    bx_access_physical(4 * 4 + 2, 2, BX_READ, &cs);
    bx_load_seg_reg(&bx_cpu.cs, cs);

    /* INTO affects the following flags: I,T */

    bx_cpu.eflags.if_ = 0;
    bx_cpu.eflags.tf  = 0;
#ifdef BX_DEBUG
bx_printf(0, "*** calling INT %02x\n", (int) 4);
bx_printf(0, "*** AH:%02x AL:%02x BH:%02x BL:%02x CH:%02x CL:%02x DH:%02x DL:%02x\n",
  AH, AL, BH, BL, CH, CL, DH, DL);
#endif
    }
}

