/*
Copyright Notice
================
BOCHS is Copyright 1994 by Kevin P. Lawton.

BOCHS is shareware for PERSONAL USE only.

For more information, read the file 'LICENSE' included in the bochs
distribution.  If you don't have access to this file, or have questions
regarding the licensing policy, the author may be contacted via:

    US Mail:  Kevin Lawton
              528 Lexington St.
              Waltham, MA 02154

    EMail:    bochs@tiac.net
*/







#include <stdio.h>
#include <assert.h>

#include "bx_bochs.h"
#include "db_debug.h"




/* end prototypes */
extern FILE *test_fd;



extern Bit8u *bx_8bit_gen_reg[8];
extern Bit16u *bx_16bit_gen_reg[8];
extern Bit32u *bx_32bit_gen_reg[8];

static Boolean bx_32bit_opsize;
static Boolean bx_32bit_addrsize;
static Boolean bx_rep_prefix;
static Boolean bx_repne_prefix;


bx_segment_reg_t *bx_debug_seg_override;





static Bit32u debug_offset;
static bx_segment_reg_t *debug_segptr;


  void
bx_debug_decode(bx_segment_reg_t *seg, Bit32u offset)
{
  int byte_count;
  Bit8u next_byte;
  Bit8u mod_rm_byte, mod, opcode, rm;

  bx_32bit_opsize = 0;   /* assume 16 bit operand sizes for now */
  bx_32bit_addrsize = 0; /* assume 16 bit address sizes for now */
  bx_debug_seg_override = NULL;
  bx_rep_prefix = 0;
  bx_repne_prefix = 0;


  debug_offset = offset;
  debug_segptr = seg;

  /* On the 386 and above, instructions must be a maximum of 15 bytes long.
   * this means redundant prefix codes can put the byte count over 15 and
   * cause an illegal instruction.
   */
  for (byte_count=0; byte_count<15; byte_count++) {
    next_byte = bx_debug_next_byte(); 
    assert(next_byte < 256);
    switch (next_byte) {

      case 0x00: bx_printf(0, "add_ebgb "); bx_debug_EbGb(); return;
      case 0x01: bx_printf(0, "add_evgv "); bx_debug_EvGv(); return;
      case 0x02: bx_printf(0, "add_gbeb "); bx_debug_GbEb(); return;
      case 0x03: bx_printf(0, "add_gvev "); bx_debug_GvEv(); return;
      case 0x04: bx_printf(0, "add_alib "); bx_debug_ALIb(); return;
      case 0x05: bx_printf(0, "add_eaxiv "); bx_debug_eAXIv(); return;
      case 0x06: bx_printf(0, "push_es "); bx_debug_ES(); return;
      case 0x07: bx_printf(0, "pop_es "); bx_debug_ES(); return;
      case 0x08: bx_printf(0, "or_ebgb "); bx_debug_EbGb(); return;
      case 0x09: bx_printf(0, "or_evgv "); bx_debug_EvGv(); return;
      case 0x0A: bx_printf(0, "or_gbeb "); bx_debug_GbEb(); return;
      case 0x0B: bx_printf(0, "or_gvev "); bx_debug_GvEv(); return;
      case 0x0C: bx_printf(0, "or_alib "); bx_debug_ALIb(); return;
      case 0x0D: bx_printf(0, "or_eaxiv "); bx_debug_eAXIv(); return;
      case 0x0E: bx_printf(0, "push_cs "); bx_debug_CS(); return;
      case 0x0F: /* 2-byte escape */
        next_byte = bx_debug_next_byte(); 
        if( ++byte_count >= 15 ) {
          debug_invalid_opcode();
          return;
	  }
        assert(next_byte < 256);
        switch (next_byte) {
          case 0x00: /* Group 6 */
            mod_rm_byte = bx_debug_peek_next_byte();
            BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
            switch (opcode) {
              case 0x00: bx_printf(0, "sldt_ew "); bx_debug_Ew(); return;
              case 0x01: bx_printf(0, "str_ew "); bx_debug_Ew(); return;
              case 0x02: bx_printf(0, "lldt_ew "); bx_debug_Ew(); return;
              case 0x03: bx_printf(0, "ltr_ew "); bx_debug_Ew(); return;
              case 0x04: bx_printf(0, "verr_ew "); bx_debug_Ew(); return;
              case 0x05: bx_printf(0, "verw_ew "); bx_debug_Ew(); return;
              case 0x06: debug_invalid_opcode(); return;
              case 0x07: debug_invalid_opcode(); return;
              default: assert(0); return;
              }
            return;
          case 0x01: /* Group 7 */
            mod_rm_byte = bx_debug_peek_next_byte();
            BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
            switch (opcode) {
              case 0x00: bx_printf(0, "sgdt_ms "); bx_debug_Ms(); return;
              case 0x01: bx_printf(0, "sidt_ms "); bx_debug_Ms(); return;
              case 0x02: bx_printf(0, "lgdt_ms "); bx_debug_Ms(); return;
              case 0x03: bx_printf(0, "lidt_ms "); bx_debug_Ms(); return;
              case 0x04: bx_printf(0, "smsw_ew "); bx_debug_Ew(); return;
              case 0x05: debug_invalid_opcode(); return;
              case 0x06: bx_printf(0, "lmsw_ew "); bx_debug_Ew(); return;
              case 0x07: debug_invalid_opcode(); return;
              default: assert(0); return;
              }
            return;

          case 0x02: bx_printf(0, "lar_gvew "); bx_debug_GvEw(); return;
          case 0x03: bx_printf(0, "lsl_gvew "); bx_debug_GvEw(); return;
          case 0x04: debug_invalid_opcode(); return;
          case 0x05: debug_invalid_opcode(); return;
          case 0x06: bx_printf(0, "clts "); return;
          case 0x07: debug_invalid_opcode(); return;
          case 0x08: bx_printf(0, "invd "); return;
          case 0x09: bx_printf(0, "wbinvd "); return;
	  case 0x0A:
	  case 0x0B:
	  case 0x0C:
	  case 0x0D:
	  case 0x0E:
	  case 0x0F: debug_invalid_opcode(); return;
  
          case 0x10:
	  case 0x11:
	  case 0x12:
	  case 0x13:
	  case 0x14:
	  case 0x15:
	  case 0x16:
	  case 0x17:
	  case 0x18:
	  case 0x19:
	  case 0x1A:
	  case 0x1B:
	  case 0x1C:
	  case 0x1D:
	  case 0x1E:
	  case 0x1F: debug_invalid_opcode(); return;

          case 0x20: bx_printf(0, "mov_rdcd "); bx_debug_RdCd(); return;
          case 0x21: bx_printf(0, "mov_rddd "); bx_debug_RdDd(); return;
          case 0x22: bx_printf(0, "mov_cdrd "); bx_debug_CdRd(); return;
          case 0x23: bx_printf(0, "mov_ddrd "); bx_debug_DdRd(); return;
          case 0x24: bx_printf(0, "mov_rdtd "); bx_debug_RdTd(); return;
          case 0x25: debug_invalid_opcode(); return;
          case 0x26: bx_printf(0, "mov_tdrd "); bx_debug_TdRd(); return;
          case 0x27:
          case 0x28:
          case 0x29:
          case 0x2A:
          case 0x2B:
          case 0x2C:
          case 0x2D:
          case 0x2E:
          case 0x2F: debug_invalid_opcode(); return;

          case 0x30:
	  case 0x31:
	  case 0x32:
	  case 0x33:
	  case 0x34:
	  case 0x35:
	  case 0x36:
	  case 0x37:
	  case 0x38:
	  case 0x39:
	  case 0x3A:
	  case 0x3B:
	  case 0x3C:
	  case 0x3D:
	  case 0x3E:
	  case 0x3F: debug_invalid_opcode(); return;

          case 0x40:
	  case 0x41:
	  case 0x42:
	  case 0x43:
	  case 0x44:
	  case 0x45:
	  case 0x46:
	  case 0x47:
	  case 0x48:
	  case 0x49:
	  case 0x4A:
	  case 0x4B:
	  case 0x4C:
	  case 0x4D:
	  case 0x4E:
	  case 0x4F: debug_invalid_opcode(); return;

          case 0x50:
	  case 0x51:
	  case 0x52:
	  case 0x53:
	  case 0x54:
	  case 0x55:
	  case 0x56:
	  case 0x57:
	  case 0x58:
	  case 0x59:
	  case 0x5A:
	  case 0x5B:
	  case 0x5C:
	  case 0x5D:
	  case 0x5E:
	  case 0x5F: debug_invalid_opcode(); return;

          case 0x60:
	  case 0x61:
	  case 0x62:
	  case 0x63:
	  case 0x64:
	  case 0x65:
	  case 0x66:
	  case 0x67:
	  case 0x68:
	  case 0x69:
	  case 0x6A:
	  case 0x6B:
	  case 0x6C:
	  case 0x6D:
	  case 0x6E:
	  case 0x6F: debug_invalid_opcode(); return;

          case 0x70:
	  case 0x71:
	  case 0x72:
	  case 0x73:
	  case 0x74:
	  case 0x75:
	  case 0x76:
	  case 0x77:
	  case 0x78:
	  case 0x79:
	  case 0x7A:
	  case 0x7B:
	  case 0x7C:
	  case 0x7D:
	  case 0x7E:
	  case 0x7F: debug_invalid_opcode(); return;

          case 0x80: bx_printf(0, "jo_jv "); bx_debug_Jv(); return;
          case 0x81: bx_printf(0, "jno_jv "); bx_debug_Jv(); return;
          case 0x82: bx_printf(0, "jb_jv "); bx_debug_Jv(); return;
          case 0x83: bx_printf(0, "jnb_jv "); bx_debug_Jv(); return;
          case 0x84: bx_printf(0, "jz_jv "); bx_debug_Jv(); return;
          case 0x85: bx_printf(0, "jnz_jv "); bx_debug_Jv(); return;
          case 0x86: bx_printf(0, "jbe_jv "); bx_debug_Jv(); return;
          case 0x87: bx_printf(0, "jnbe_jv "); bx_debug_Jv(); return;
          case 0x88: bx_printf(0, "js_jv "); bx_debug_Jv(); return;
          case 0x89: bx_printf(0, "jns_jv "); bx_debug_Jv(); return;
          case 0x8A: bx_printf(0, "jp_jv "); bx_debug_Jv(); return;
          case 0x8B: bx_printf(0, "jnp_jv "); bx_debug_Jv(); return;
          case 0x8C: bx_printf(0, "jl_jv "); bx_debug_Jv(); return;
          case 0x8D: bx_printf(0, "jnl_jv "); bx_debug_Jv(); return;
          case 0x8E: bx_printf(0, "jle_jv "); bx_debug_Jv(); return;
          case 0x8F: bx_printf(0, "jnle_jv "); bx_debug_Jv(); return;

          case 0x90: bx_printf(0, "seto_eb "); bx_debug_Eb(); return;
          case 0x91: bx_printf(0, "setno_eb "); bx_debug_Eb(); return;
          case 0x92: bx_printf(0, "setb_eb "); bx_debug_Eb(); return;
          case 0x93: bx_printf(0, "setnb_eb "); bx_debug_Eb(); return;
          case 0x94: bx_printf(0, "setz_eb "); bx_debug_Eb(); return;
          case 0x95: bx_printf(0, "setnz_eb "); bx_debug_Eb(); return;
          case 0x96: bx_printf(0, "setbe_eb "); bx_debug_Eb(); return;
          case 0x97: bx_printf(0, "setnbe_eb "); bx_debug_Eb(); return;
          case 0x98: bx_printf(0, "sets_eb "); bx_debug_Eb(); return;
          case 0x99: bx_printf(0, "setns_eb "); bx_debug_Eb(); return;
          case 0x9A: bx_printf(0, "setp_eb "); bx_debug_Eb(); return;
          case 0x9B: bx_printf(0, "setnp_eb "); bx_debug_Eb(); return;
          case 0x9C: bx_printf(0, "setl_eb "); bx_debug_Eb(); return;
          case 0x9D: bx_printf(0, "setnl_eb "); bx_debug_Eb(); return;
          case 0x9E: bx_printf(0, "setle_eb "); bx_debug_Eb(); return;
          case 0x9F: bx_printf(0, "setnle_eb "); bx_debug_Eb(); return;

          case 0xA0: bx_printf(0, "push_fs "); bx_debug_FS(); return;
          case 0xA1: bx_printf(0, "pop_fs "); bx_debug_FS(); return;
          case 0xA2: debug_invalid_opcode(); return;
          case 0xA3: bx_printf(0, "bt_evgv "); bx_debug_EvGv(); return;
          case 0xA4: bx_printf(0, "shld_evgvib "); bx_debug_EvGvIb(); return;
          case 0xA5: bx_printf(0, "shld_evgvcl "); bx_debug_EvGvCL(); return;
          case 0xA6: bx_printf(0, "cmpxchg_xbts "); bx_debug_XBTS(); return;
          case 0xA7: bx_printf(0, "cmpxchg_ibts "); bx_debug_IBTS(); return;
          case 0xA8: bx_printf(0, "push_gs "); bx_debug_GS(); return;
          case 0xA9: bx_printf(0, "pop_gs "); bx_debug_GS(); return;
          case 0xAA: debug_invalid_opcode(); return;
          case 0xAB: bx_printf(0, "bts_evgv "); bx_debug_EvGv(); return;
          case 0xAC: bx_printf(0, "shrd_evgvib "); bx_debug_EvGvIb(); return;
          case 0xAD: bx_printf(0, "shrd_evgvcl "); bx_debug_EvGvCL(); return;
          case 0xAE: debug_invalid_opcode(); return;
          case 0xAF: bx_printf(0, "imul_gvev "); bx_debug_GvEv(); return;

          case 0xB0: bx_printf(0, "cmpxchg_ebgb "); bx_debug_EbGb(); return;
          case 0xB1: bx_printf(0, "cmpxchg_evgv "); bx_debug_EvGv(); return;
          case 0xB2: bx_printf(0, "lss_mp "); bx_debug_Mp(); return;
          case 0xB3: bx_printf(0, "btr_evgv "); bx_debug_EvGv(); return;
          case 0xB4: bx_printf(0, "lfs_mp "); bx_debug_Mp(); return;
          case 0xB5: bx_printf(0, "lgs_mp "); bx_debug_Mp(); return;
          case 0xB6: bx_printf(0, "movzx_gveb "); bx_debug_GvEb(); return;
          case 0xB7: bx_printf(0, "movzx_gvew "); bx_debug_GvEw(); return;
          case 0xB8: debug_invalid_opcode(); return;
          case 0xB9: debug_invalid_opcode(); return;
          case 0xBA: /* Group 8 Ev,Ib */
            mod_rm_byte = bx_debug_peek_next_byte();
            BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
            switch (opcode) {
              case 0x00:
              case 0x01:
              case 0x02:
              case 0x03: debug_invalid_opcode(); return;
              case 0x04: bx_printf(0, "bt_evib "); bx_debug_EvIb(); return;
              case 0x05: bx_printf(0, "bts_evib "); bx_debug_EvIb(); return;
              case 0x06: bx_printf(0, "btr_evib "); bx_debug_EvIb(); return;
              case 0x07: bx_printf(0, "btc_evib "); bx_debug_EvIb(); return;
              default: assert(0); return;
              }
            return;

          case 0xBB: bx_printf(0, "btc_evgv "); bx_debug_EvGv(); return;
          case 0xBC: bx_printf(0, "bsf_gvev "); bx_debug_GvEv(); return;
          case 0xBD: bx_printf(0, "bsr_gvev "); bx_debug_GvEv(); return;
          case 0xBE: bx_printf(0, "movsx_gveb "); bx_debug_GvEb(); return;
          case 0xBF: bx_printf(0, "movsx_gvew "); bx_debug_GvEw(); return;

          case 0xC0: bx_printf(0, "xadd_ebgb "); bx_debug_EbGb(); return;
          case 0xC1: bx_printf(0, "xadd_evgv "); bx_debug_EvGv(); return;
          case 0xC2: 
          case 0xC3: 
          case 0xC4: 
          case 0xC5: 
          case 0xC6: 
          case 0xC7: debug_invalid_opcode(); return;
          case 0xC8: bx_printf(0, "bswap_eax "); bx_debug_eAX(); return;
          case 0xC9: bx_printf(0, "bswap_ecx "); bx_debug_eCX(); return;
          case 0xCA: bx_printf(0, "bswap_edx "); bx_debug_eDX(); return;
          case 0xCB: bx_printf(0, "bswap_ebx "); bx_debug_eBX(); return;
          case 0xCC: bx_printf(0, "bswap_esp "); bx_debug_eSP(); return;
          case 0xCD: bx_printf(0, "bswap_ebp "); bx_debug_eBP(); return;
          case 0xCE: bx_printf(0, "bswap_esi "); bx_debug_eSI(); return;
          case 0xCF: bx_printf(0, "bswap_edi "); bx_debug_eDI(); return;
       
          case 0xD0:
	  case 0xD1:
	  case 0xD2:
	  case 0xD3:
	  case 0xD4:
	  case 0xD5:
	  case 0xD6:
	  case 0xD7:
	  case 0xD8:
	  case 0xD9:
	  case 0xDA:
	  case 0xDB:
	  case 0xDC:
	  case 0xDD:
	  case 0xDE:
	  case 0xDF: debug_invalid_opcode(); return;

          case 0xE0:
	  case 0xE1:
	  case 0xE2:
	  case 0xE3:
	  case 0xE4:
	  case 0xE5:
	  case 0xE6:
	  case 0xE7:
	  case 0xE8:
	  case 0xE9:
	  case 0xEA:
	  case 0xEB:
	  case 0xEC:
	  case 0xED:
	  case 0xEE:
	  case 0xEF: debug_invalid_opcode(); return;

          case 0xF0:
	  case 0xF1:
	  case 0xF2:
	  case 0xF3:
	  case 0xF4:
	  case 0xF5:
	  case 0xF6:
	  case 0xF7:
	  case 0xF8:
	  case 0xF9:
	  case 0xFA:
	  case 0xFB:
	  case 0xFC:
	  case 0xFD:
	  case 0xFE:
	  case 0xFF: debug_invalid_opcode(); return;

          default: assert(0); return;
          }
        return;

      case 0x10: bx_printf(0, "adc_ebgb "); bx_debug_EbGb(); return;
      case 0x11: bx_printf(0, "adc_evgv "); bx_debug_EvGv(); return;
      case 0x12: bx_printf(0, "adc_gbeb "); bx_debug_GbEb(); return;
      case 0x13: bx_printf(0, "adc_gvev "); bx_debug_GvEv(); return;
      case 0x14: bx_printf(0, "adc_alib "); bx_debug_ALIb(); return;
      case 0x15: bx_printf(0, "adc_eaxiv "); bx_debug_eAXIv(); return;
      case 0x16: bx_printf(0, "push_ss "); bx_debug_SS(); return;
      case 0x17: bx_printf(0, "pop_ss "); bx_debug_SS(); return;
      case 0x18: bx_printf(0, "sbb_ebgb "); bx_debug_EbGb(); return;
      case 0x19: bx_printf(0, "sbb_evgv "); bx_debug_EvGv(); return;
      case 0x1A: bx_printf(0, "sbb_gbeb "); bx_debug_GbEb(); return;
      case 0x1B: bx_printf(0, "sbb_gvev "); bx_debug_GvEv(); return;
      case 0x1C: bx_printf(0, "sbb_alib "); bx_debug_ALIb(); return;
      case 0x1D: bx_printf(0, "sbb_eaxiv "); bx_debug_eAXIv(); return;
      case 0x1E: bx_printf(0, "push_ds "); bx_debug_DS(); return;
      case 0x1F: bx_printf(0, "pop_ds "); bx_debug_DS(); return;


      case 0x20: bx_printf(0, "and_ebgb "); bx_debug_EbGb(); return;
      case 0x21: bx_printf(0, "and_evgv "); bx_debug_EvGv(); return;
      case 0x22: bx_printf(0, "and_gveb "); bx_debug_GbEb(); return;
      case 0x23: bx_printf(0, "and_gvev "); bx_debug_GvEv(); return;
      case 0x24: bx_printf(0, "and_alib "); bx_debug_ALIb(); return;
      case 0x25: bx_printf(0, "and_eaxiv "); bx_debug_eAXIv(); return;
      case 0x26: 
        bx_debug_seg_override = &bx_cpu.es;
        break;
      case 0x27: bx_printf(0, "daa "); return;
      case 0x28: bx_printf(0, "sub_ebgb "); bx_debug_EbGb(); return;
      case 0x29: bx_printf(0, "sub_evgv "); bx_debug_EvGv(); return;
      case 0x2A: bx_printf(0, "sub_gbeb "); bx_debug_GbEb(); return;
      case 0x2B: bx_printf(0, "sub_gvev "); bx_debug_GvEv(); return;
      case 0x2C: bx_printf(0, "sub_alib "); bx_debug_ALIb(); return;
      case 0x2D: bx_printf(0, "sub_eaxiv "); bx_debug_eAXIv(); return;
      case 0x2E:
        bx_debug_seg_override = &bx_cpu.cs;
        break;
      case 0x2F: bx_printf(0, "das "); return;

      case 0x30: bx_printf(0, "xor_ebgb "); bx_debug_EbGb(); return;
      case 0x31: bx_printf(0, "xor_evgv "); bx_debug_EvGv(); return;
      case 0x32: bx_printf(0, "xor_gbeb "); bx_debug_GbEb(); return;
      case 0x33: bx_printf(0, "xor_gvev "); bx_debug_GvEv(); return;
      case 0x34: bx_printf(0, "xor_alib "); bx_debug_ALIb(); return;
      case 0x35: bx_printf(0, "xor_eaxiv "); bx_debug_eAXIv(); return;
      case 0x36: 
        bx_debug_seg_override = &bx_cpu.ss;
        break;
      case 0x37: bx_printf(0, "aaa "); return;
      case 0x38: bx_printf(0, "cmp_ebgb "); bx_debug_EbGb(); return;
      case 0x39: bx_printf(0, "cmp_evgv "); bx_debug_EvGv(); return;
      case 0x3A: bx_printf(0, "cmp_gbeb "); bx_debug_GbEb(); return;
      case 0x3B: bx_printf(0, "cmp_gvev "); bx_debug_GvEv(); return;
      case 0x3C: bx_printf(0, "cmp_alib "); bx_debug_ALIb(); return;
      case 0x3D: bx_printf(0, "cmp_eaxiv "); bx_debug_eAXIv(); return;
      case 0x3E: 
        bx_debug_seg_override = &bx_cpu.ds;
        break;
      case 0x3F: bx_printf(0, "aas "); return;

      case 0x40: bx_printf(0, "inc_eax "); bx_debug_eAX(); return;
      case 0x41: bx_printf(0, "inc_ecx "); bx_debug_eCX(); return;
      case 0x42: bx_printf(0, "inc_edx "); bx_debug_eDX(); return;
      case 0x43: bx_printf(0, "inc_ebx "); bx_debug_eBX(); return;
      case 0x44: bx_printf(0, "inc_esp "); bx_debug_eSP(); return;
      case 0x45: bx_printf(0, "inc_ebp "); bx_debug_eBP(); return;
      case 0x46: bx_printf(0, "inc_esi "); bx_debug_eSI(); return;
      case 0x47: bx_printf(0, "inc_edi "); bx_debug_eDI(); return;
      case 0x48: bx_printf(0, "dec_eax "); bx_debug_eAX(); return;
      case 0x49: bx_printf(0, "dec_ecx "); bx_debug_eCX(); return;
      case 0x4A: bx_printf(0, "dec_edx "); bx_debug_eDX(); return;
      case 0x4B: bx_printf(0, "dec_ebx "); bx_debug_eBX(); return;
      case 0x4C: bx_printf(0, "dec_esp "); bx_debug_eSP(); return;
      case 0x4D: bx_printf(0, "dec_ebp "); bx_debug_eBP(); return;
      case 0x4E: bx_printf(0, "dec_esi "); bx_debug_eSI(); return;
      case 0x4F: bx_printf(0, "dec_edi "); bx_debug_eDI(); return;
 

      case 0x50: bx_printf(0, "push_eax "); bx_debug_eAX(); return;
      case 0x51: bx_printf(0, "push_ecx "); bx_debug_eCX(); return;
      case 0x52: bx_printf(0, "push_edx "); bx_debug_eDX(); return;
      case 0x53: bx_printf(0, "push_ebx "); bx_debug_eBX(); return;
      case 0x54: bx_printf(0, "push_esp "); bx_debug_eSP(); return;
      case 0x55: bx_printf(0, "push_ebp "); bx_debug_eBP(); return;
      case 0x56: bx_printf(0, "push_esi "); bx_debug_eSI(); return;
      case 0x57: bx_printf(0, "push_edi "); bx_debug_eDI(); return;
      case 0x58: bx_printf(0, "pop_eax "); bx_debug_eAX(); return;
      case 0x59: bx_printf(0, "pop_ecx "); bx_debug_eCX(); return;
      case 0x5A: bx_printf(0, "pop_edx "); bx_debug_eDX(); return;
      case 0x5B: bx_printf(0, "pop_ebx "); bx_debug_eBX(); return;
      case 0x5C: bx_printf(0, "pop_esp "); bx_debug_eSP(); return;
      case 0x5D: bx_printf(0, "pop_ebp "); bx_debug_eBP(); return;
      case 0x5E: bx_printf(0, "pop_esi "); bx_debug_eSI(); return;
      case 0x5F: bx_printf(0, "pop_edi "); bx_debug_eDI(); return;


      case 0x60: bx_printf(0, "pushad "); return;
      case 0x61: bx_printf(0, "popad "); return;
      case 0x62: bx_printf(0, "bound_gvma "); bx_debug_GvMa(); return;
      case 0x63: bx_printf(0, "arpl_ewrw "); bx_debug_EwRw(); return;
      case 0x64: 
        bx_debug_seg_override = &bx_cpu.fs;
        break;
      case 0x65: 
        bx_debug_seg_override = &bx_cpu.gs;
        break;
      case 0x66:
        bx_32bit_opsize = 1;
        break;
      case 0x67:
        bx_32bit_addrsize = 1;
        break;
      case 0x68: bx_printf(0, "push_iv "); bx_debug_Iv(); return;
      case 0x69: bx_printf(0, "imul_gveviv "); bx_debug_GvEvIv(); return;
      case 0x6A: bx_printf(0, "push_ib "); bx_debug_Ib(); return;
      case 0x6B: bx_printf(0, "imul_gvevib "); bx_debug_GvEvIb(); return;
      case 0x6C: bx_printf(0, "insb_ybdx "); bx_debug_YbDX(); return;
      case 0x6D: bx_printf(0, "insw_yvdx "); bx_debug_YvDX(); return;
      case 0x6E: bx_printf(0, "outsb_dxxb "); bx_debug_DXXb(); return;
      case 0x6F: bx_printf(0, "outsw_dxxv "); bx_debug_DXXv(); return;


      case 0x70: bx_printf(0, "jo_jb "); bx_debug_Jb(); return;
      case 0x71: bx_printf(0, "jno_jb "); bx_debug_Jb(); return;
      case 0x72: bx_printf(0, "jb_jb "); bx_debug_Jb(); return;
      case 0x73: bx_printf(0, "jnb_jb "); bx_debug_Jb(); return;
      case 0x74: bx_printf(0, "jz_jb "); bx_debug_Jb(); return;
      case 0x75: bx_printf(0, "jnz_jb "); bx_debug_Jb(); return;
      case 0x76: bx_printf(0, "jbe_jb "); bx_debug_Jb(); return;
      case 0x77: bx_printf(0, "jnbe_jb "); bx_debug_Jb(); return;
      case 0x78: bx_printf(0, "js_jb "); bx_debug_Jb(); return;
      case 0x79: bx_printf(0, "jns_jb "); bx_debug_Jb(); return;
      case 0x7A: bx_printf(0, "jp_jb "); bx_debug_Jb(); return;
      case 0x7B: bx_printf(0, "jnp_jb "); bx_debug_Jb(); return;
      case 0x7C: bx_printf(0, "jl_jb "); bx_debug_Jb(); return;
      case 0x7D: bx_printf(0, "jnl_jb "); bx_debug_Jb(); return;
      case 0x7E: bx_printf(0, "jle_jb "); bx_debug_Jb(); return;
      case 0x7F: bx_printf(0, "jnle_jb "); bx_debug_Jb(); return;

      case 0x80: /* Immdediate Grp 1 EbIb */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "add_ebib "); bx_debug_EbIb(); return;
          case 0x01: bx_printf(0, "or_ebib "); bx_debug_EbIb();  return;
          case 0x02: bx_printf(0, "adc_ebib "); bx_debug_EbIb(); return;
          case 0x03: bx_printf(0, "sbb_ebib "); bx_debug_EbIb(); return;
          case 0x04: bx_printf(0, "and_ebib "); bx_debug_EbIb(); return;
          case 0x05: bx_printf(0, "sub_ebib "); bx_debug_EbIb(); return;
          case 0x06: bx_printf(0, "xor_ebib "); bx_debug_EbIb(); return;
          case 0x07: bx_printf(0, "cmp_ebib "); bx_debug_EbIb(); return;
          default: assert(0); return;
          }
        return;
        break;

      case 0x81: /* Immdediate Grp 1 EvIv */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "add_eviv "); bx_debug_EvIv(); return;
          case 0x01: bx_printf(0, "or_eviv "); bx_debug_EvIv(); return;
          case 0x02: bx_printf(0, "adc_eviv "); bx_debug_EvIv(); return;
          case 0x03: bx_printf(0, "sbb_eviv "); bx_debug_EvIv(); return;
          case 0x04: bx_printf(0, "and_eviv "); bx_debug_EvIv(); return;
          case 0x05: bx_printf(0, "sub_eviv "); bx_debug_EvIv(); return;
          case 0x06: bx_printf(0, "xor_eviv "); bx_debug_EvIv(); return;
          case 0x07: bx_printf(0, "cmp_eviv "); bx_debug_EvIv(); return;
          default: assert(0); return;
          }
        return;

      case 0x82: debug_invalid_opcode(); return;

      case 0x83: /* Immdediate Grp 1 EvIb */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "add_evib "); bx_debug_EvIb(); return;
          case 0x01: bx_printf(0, "or_evib "); bx_debug_EvIb(); return;
          case 0x02: bx_printf(0, "adc_evib "); bx_debug_EvIb(); return;
          case 0x03: bx_printf(0, "sbb_evib "); bx_debug_EvIb(); return;
          case 0x04: bx_printf(0, "and_evib "); bx_debug_EvIb(); return;
          case 0x05: bx_printf(0, "sub_evib "); bx_debug_EvIb(); return;
          case 0x06: bx_printf(0, "xor_evib "); bx_debug_EvIb(); return;
          case 0x07: bx_printf(0, "cmp_evib "); bx_debug_EvIb(); return;
          default: assert(0); return;
          }
        return;

      case 0x84: bx_printf(0, "test_ebgb "); bx_debug_EbGb(); return;
      case 0x85: bx_printf(0, "test_evgv "); bx_debug_EvGv(); return;
      case 0x86: bx_printf(0, "xchg_ebgb "); bx_debug_EbGb(); return;
      case 0x87: bx_printf(0, "xchg_evgv "); bx_debug_EvGv(); return;
      case 0x88: bx_printf(0, "mov_ebgb "); bx_debug_EbGb(); return;
      case 0x89: bx_printf(0, "mov_evgv "); bx_debug_EvGv(); return;
      case 0x8A: bx_printf(0, "mov_gbeb "); bx_debug_GbEb(); return;
      case 0x8B: bx_printf(0, "mov_gvev "); bx_debug_GvEv(); return;
      case 0x8C: bx_printf(0, "mov_ewsw "); bx_debug_EwSw(); return;
      case 0x8D: bx_printf(0, "lea_gvm "); bx_debug_GvM(); return;
      case 0x8E: bx_printf(0, "mov_swew "); bx_debug_SwEw(); return;
      case 0x8F: bx_printf(0, "pop_ev "); bx_debug_Ev(); return;
 

      case 0x90: /* NOP */ return;
      case 0x91: bx_printf(0, "xchg_ecxeax "); bx_debug_eCXeAX(); return;
      case 0x92: bx_printf(0, "xchg_edxeax "); bx_debug_eDXeAX(); return;
      case 0x93: bx_printf(0, "xchg_ebxeax "); bx_debug_eBXeAX(); return;
      case 0x94: bx_printf(0, "xchg_espeax "); bx_debug_eSPeAX(); return;
      case 0x95: bx_printf(0, "xchg_ebpeax "); bx_debug_eBPeAX(); return;
      case 0x96: bx_printf(0, "xchg_esieax "); bx_debug_eSIeAX(); return;
      case 0x97: bx_printf(0, "xchg_edieax "); bx_debug_eDIeAX(); return;
      case 0x98: bx_printf(0, "cbw "); return;
      case 0x99: bx_printf(0, "cwd "); return;
      case 0x9A: bx_printf(0, "call_ap "); bx_debug_Ap(); return;
      case 0x9B: bx_printf(0, "wait "); return;
      case 0x9C: bx_printf(0, "pushf_fv "); bx_debug_Fv(); return;
      case 0x9D: bx_printf(0, "popf_fv "); bx_debug_Fv(); return;
      case 0x9E: bx_printf(0, "sahf "); return;
      case 0x9F: bx_printf(0, "lahf "); return;
 

      case 0xA0: bx_printf(0, "mov_alob "); bx_debug_ALOb(); return;
      case 0xA1: bx_printf(0, "mov_eaxov "); bx_debug_eAXOv(); return;
      case 0xA2: bx_printf(0, "mov_obal "); bx_debug_ObAL(); return;
      case 0xA3: bx_printf(0, "mov_oveax "); bx_debug_OveAX(); return;
      case 0xA4: bx_printf(0, "movsb_xbyb "); bx_debug_XbYb(); return;
      case 0xA5: bx_printf(0, "movsw_xvyv "); bx_debug_XvYv(); return;
      case 0xA6: bx_printf(0, "cmpsb_xbyb "); bx_debug_XbYb(); return;
      case 0xA7: bx_printf(0, "cmpsw_xvyv "); bx_debug_XvYv(); return;
      case 0xA8: bx_printf(0, "test_alib "); bx_debug_ALIb(); return;
      case 0xA9: bx_printf(0, "test_eaxiv "); bx_debug_eAXIv(); return;
      case 0xAA: bx_printf(0, "stosb_ybal "); bx_debug_YbAL(); return;
      case 0xAB: bx_printf(0, "stosw_yveax "); bx_debug_YveAX(); return;
      case 0xAC: bx_printf(0, "lodsb_alxb "); bx_debug_ALXb(); return;
      case 0xAD: bx_printf(0, "lodsw_eaxxv "); bx_debug_eAXXv(); return;
      case 0xAE: bx_printf(0, "scasb_alxb "); bx_debug_ALXb(); return;
      case 0xAF: bx_printf(0, "scasw_eaxxv "); bx_debug_eAXXv(); return;
 

      case 0xB0: bx_printf(0, "mov_alib "); bx_debug_ALIb(); return;
      case 0xB1: bx_printf(0, "mov_clib "); bx_debug_CLIb(); return;
      case 0xB2: bx_printf(0, "mov_dlib "); bx_debug_DLIb(); return;
      case 0xB3: bx_printf(0, "mov_blib "); bx_debug_BLIb(); return;
      case 0xB4: bx_printf(0, "mov_ahib "); bx_debug_AHIb(); return;
      case 0xB5: bx_printf(0, "mov_chib "); bx_debug_CHIb(); return;
      case 0xB6: bx_printf(0, "mov_dhib "); bx_debug_DHIb(); return;
      case 0xB7: bx_printf(0, "mov_bhib "); bx_debug_BHIb(); return;
      case 0xB8: bx_printf(0, "mov_eaxiv "); bx_debug_eAXIv(); return;
      case 0xB9: bx_printf(0, "mov_ecxiv "); bx_debug_eCXIv(); return;
      case 0xBA: bx_printf(0, "mov_edxiv "); bx_debug_eDXIv(); return;
      case 0xBB: bx_printf(0, "mov_ebxiv "); bx_debug_eBXIv(); return;
      case 0xBC: bx_printf(0, "mov_espiv "); bx_debug_eSPIv(); return;
      case 0xBD: bx_printf(0, "mov_ebpiv "); bx_debug_eBPIv(); return;
      case 0xBE: bx_printf(0, "mov_esiiv "); bx_debug_eSIIv(); return;
      case 0xBF: bx_printf(0, "mov_ediiv "); bx_debug_eDIIv(); return;
 
      case 0xC0: /* Group 2 Eb,Ib */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "rol_ebib "); bx_debug_EbIb(); return;
          case 0x01: bx_printf(0, "ror_ebib "); bx_debug_EbIb(); return;
          case 0x02: bx_printf(0, "rcl_ebib "); bx_debug_EbIb(); return;
          case 0x03: bx_printf(0, "rcr_ebib "); bx_debug_EbIb(); return;
          case 0x04: bx_printf(0, "shl_ebib "); bx_debug_EbIb(); return;
          case 0x05: bx_printf(0, "shr_ebib "); bx_debug_EbIb(); return;
          case 0x06: debug_invalid_opcode(); return;
          case 0x07: bx_printf(0, "sar_ebib "); bx_debug_EbIb(); return;
          default: assert(0); return;
          }
        return;

      case 0xC1: /* Group 2 Ev,Ib */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "rol_evib "); bx_debug_EvIb(); return;
          case 0x01: bx_printf(0, "ror_evib "); bx_debug_EvIb(); return;
          case 0x02: bx_printf(0, "rcl_evib "); bx_debug_EvIb(); return;
          case 0x03: bx_printf(0, "rcr_evib "); bx_debug_EvIb(); return;
          case 0x04: bx_printf(0, "shl_evib "); bx_debug_EvIb(); return;
          case 0x05: bx_printf(0, "shr_evib "); bx_debug_EvIb(); return;
          case 0x06: debug_invalid_opcode(); return;
          case 0x07: bx_printf(0, "sar_evib "); bx_debug_EvIb(); return;
          default: assert(0); return;
          }
        return;

      case 0xC2: bx_printf(0, "ret_neariw "); bx_debug_Iw(); return;
      case 0xC3: bx_printf(0, "ret_near "); return;
      case 0xC4: bx_printf(0, "les_gvmp "); bx_debug_GvMp(); return;
      case 0xC5: bx_printf(0, "lds_gvmp "); bx_debug_GvMp(); return;
      case 0xC6: bx_printf(0, "mov_ebib "); bx_debug_EbIb(); return;
      case 0xC7: bx_printf(0, "mov_eviv "); bx_debug_EvIv(); return;
      case 0xC8: bx_printf(0, "enter_iwib "); bx_debug_IwIb(); return;
      case 0xC9: bx_printf(0, "leave "); return;
      case 0xCA: bx_printf(0, "ret_fariw "); bx_debug_Iw(); return;
      case 0xCB: bx_printf(0, "ret_far "); return;
      case 0xCC: bx_printf(0, "int_3 "); return;
      case 0xCD: bx_printf(0, "int_ib "); bx_debug_Ib(); return;
      case 0xCE: bx_printf(0, "into "); return;
      case 0xCF: bx_printf(0, "iret "); return;
 

      case 0xD0: /* Group 2 Eb,1 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "rol_eb1 "); bx_debug_Eb1(); return;
          case 0x01: bx_printf(0, "ror_eb1 "); bx_debug_Eb1(); return;
          case 0x02: bx_printf(0, "rcl_eb1 "); bx_debug_Eb1(); return;
          case 0x03: bx_printf(0, "rcr_eb1 "); bx_debug_Eb1(); return;
          case 0x04: bx_printf(0, "shl_eb1 "); bx_debug_Eb1(); return;
          case 0x05: bx_printf(0, "shr_eb1 "); bx_debug_Eb1(); return;
          case 0x06: debug_invalid_opcode(); return;
          case 0x07: bx_printf(0, "sar_eb1 "); bx_debug_Eb1(); return;
          default: assert(0); return;
          }
        return;

      case 0xD1: /* group2 Ev,1 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "rol_ev1 "); bx_debug_Ev1(); return;
          case 0x01: bx_printf(0, "ror_ev1 "); bx_debug_Ev1(); return;
          case 0x02: bx_printf(0, "rcl_ev1 "); bx_debug_Ev1(); return;
          case 0x03: bx_printf(0, "rcr_ev1 "); bx_debug_Ev1(); return;
          case 0x04: bx_printf(0, "shl_ev1 "); bx_debug_Ev1(); return;
          case 0x05: bx_printf(0, "shr_ev1 "); bx_debug_Ev1(); return;
          case 0x06: debug_invalid_opcode(); return;
          case 0x07: bx_printf(0, "sar_ev1 "); bx_debug_Ev1(); return;
          default: assert(0); return;
          }
        return;

      case 0xD2: /* group2 Eb,CL */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "rol_ebcl "); bx_debug_EbCL(); return;
          case 0x01: bx_printf(0, "ror_ebcl "); bx_debug_EbCL(); return;
          case 0x02: bx_printf(0, "rcl_ebcl "); bx_debug_EbCL(); return;
          case 0x03: bx_printf(0, "rcr_ebcl "); bx_debug_EbCL(); return;
          case 0x04: bx_printf(0, "shl_ebcl "); bx_debug_EbCL(); return;
          case 0x05: bx_printf(0, "shr_ebcl "); bx_debug_EbCL(); return;
          case 0x06: debug_invalid_opcode(); return;
          case 0x07: bx_printf(0, "sar_ebcl "); bx_debug_EbCL(); return;
          default: assert(0); return;
          }
        return;

      case 0xD3: /* group2 Ev,CL */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "rol_evcl "); bx_debug_EvCL(); return;
          case 0x01: bx_printf(0, "ror_evcl "); bx_debug_EvCL(); return;
          case 0x02: bx_printf(0, "rcl_evcl "); bx_debug_EvCL(); return;
          case 0x03: bx_printf(0, "rcr_evcl "); bx_debug_EvCL(); return;
          case 0x04: bx_printf(0, "shl_evcl "); bx_debug_EvCL(); return;
          case 0x05: bx_printf(0, "shr_evcl "); bx_debug_EvCL(); return;
          case 0x06: debug_invalid_opcode(); return;
          case 0x07: bx_printf(0, "sar_evcl "); bx_debug_EvCL(); return;
          default: assert(0); return;
          }
        return;

      case 0xD4: bx_printf(0, "aam "); return;
      case 0xD5: bx_printf(0, "aad "); return;
      case 0xD6: debug_invalid_opcode(); return;
      case 0xD7: bx_printf(0, "xlat "); return;

      case 0xD8: /* ESC0 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        if (mod != 3) {
          switch (opcode) {
            case 0x00: bx_printf(0, "fadd_es "); bx_debug_Es(); return;
            case 0x01: bx_printf(0, "fmul_es "); bx_debug_Es(); return;
            case 0x02: bx_printf(0, "fcom_es "); bx_debug_Es(); return;
            case 0x03: bx_printf(0, "fcomp_es "); bx_debug_Es(); return;
            case 0x04: bx_printf(0, "fsub_es "); bx_debug_Es(); return;
            case 0x05: bx_printf(0, "fsubr_es "); bx_debug_Es(); return;
            case 0x06: bx_printf(0, "fdiv_es "); bx_debug_Es(); return;
            case 0x07: bx_printf(0, "fdivr_es "); bx_debug_Es(); return;
            default: assert(0); return;
            }
          }
        else { /* mod == 3 */
          switch (opcode) {
            case 0x00: bx_printf(0, "fadd_st_sti "); bx_debug_ST_STi(); return;
            case 0x01: bx_printf(0, "fmul_st_sti "); bx_debug_ST_STi(); return;
            case 0x02: bx_printf(0, "fcom_st_sti "); bx_debug_ST_STi(); return;
            case 0x03: bx_printf(0, "fcomp_st_sti "); bx_debug_ST_STi(); return;
            case 0x04: bx_printf(0, "fsub_st_sti "); bx_debug_ST_STi(); return;
            case 0x05: bx_printf(0, "fsubr_st_sti "); bx_debug_ST_STi(); return;
            case 0x06: bx_printf(0, "fdiv_st_sti "); bx_debug_ST_STi(); return;
            case 0x07: bx_printf(0, "fdivr_st_sti "); bx_debug_ST_STi(); return;
            default: assert(0); return;
            }
          }
        return;

      case 0xD9: /* ESC1 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        if (mod != 3) {
          switch (opcode) {
            case 0x00: bx_printf(0, "fld_es "); bx_debug_Es(); return;
            case 0x01: debug_invalid_opcode(); return;
            case 0x02: bx_printf(0, "fst_es "); bx_debug_Es(); return;
            case 0x03: bx_printf(0, "fstp_es "); bx_debug_Es(); return;
            case 0x04: bx_printf(0, "fldenv_ea "); bx_debug_Ea(); return;
            case 0x05: bx_printf(0, "fldcw_ew "); bx_debug_Ew(); return;
            case 0x06: bx_printf(0, "fstenv_ea "); bx_debug_Ea(); return;
            case 0x07: bx_printf(0, "fstcw_ew "); bx_debug_Ew(); return;
            default: assert(0); return;
            }
          }
        else { /* mod == 3 */
          switch (opcode) {
            case 0x00:
              bx_printf(0, "fld_sti "); bx_debug_STi(); return;
            case 0x01:
              bx_printf(0, "fxch_sti "); bx_debug_STi(); return;
            case 0x02:
              if (rm == 0) {
                bx_printf(0, "fnop "); return;
	        }
              else {
                debug_invalid_opcode(); return;
	        }
            case 0x03:
              bx_printf(0, "fstp_sti "); bx_debug_STi(); return;

            case 0x04:
              switch (rm) {
                case 0x00: bx_printf(0, "fchs "); return;
                case 0x01: bx_printf(0, "fabs "); return;
                case 0x02:
                case 0x03: debug_invalid_opcode(); return;
                case 0x04: bx_printf(0, "ftst "); return;
                case 0x05: bx_printf(0, "fxam "); return;
                case 0x06:
                case 0x07: debug_invalid_opcode(); return;
                }
            case 0x05:
              switch (rm) {
                case 0x00: bx_printf(0, "fld1 "); return;
                case 0x01: bx_printf(0, "fldl2t "); return;
                case 0x02: bx_printf(0, "fldl2e "); return;
                case 0x03: bx_printf(0, "fldpi "); return;
                case 0x04: bx_printf(0, "fldlg2 "); return;
                case 0x05: bx_printf(0, "fldln2 "); return;
                case 0x06: bx_printf(0, "fldz "); return;
                case 0x07: debug_invalid_opcode(); return;
                }
            case 0x06:
              switch (rm) {
                case 0x00: bx_printf(0, "f2xm1 "); return;
                case 0x01: bx_printf(0, "fyl2x "); return;
                case 0x02: bx_printf(0, "fptan "); return;
                case 0x03: bx_printf(0, "fpatan "); return;
                case 0x04: bx_printf(0, "fxtract "); return;
                case 0x05: bx_printf(0, "fprem1 "); return;
                case 0x06: bx_printf(0, "fdecstp "); return;
                case 0x07: bx_printf(0, "fincstp "); return;
                }
            case 0x07:
              switch (rm) {
                case 0x00: bx_printf(0, "fprem "); return;
                case 0x01: bx_printf(0, "fyl2xp1 "); return;
                case 0x02: bx_printf(0, "fsqrt "); return;
                case 0x03: bx_printf(0, "fsincos "); return;
                case 0x04: bx_printf(0, "frndint "); return;
                case 0x05: bx_printf(0, "fscale "); return;
                case 0x06: bx_printf(0, "fsin "); return;
                case 0x07: bx_printf(0, "fcos "); return;
                }
            default: assert(0); return;
            }
          }
        return;

      case 0xDA: /* ESC2 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        if (mod != 3) {
          switch (opcode) {
            case 0x00: bx_printf(0, "fiadd_ed "); bx_debug_Ed(); return;
            case 0x01: bx_printf(0, "fimul_ed "); bx_debug_Ed(); return;
            case 0x02: bx_printf(0, "ficom_ed "); bx_debug_Ed(); return;
            case 0x03: bx_printf(0, "ficomp_ed "); bx_debug_Ed(); return;
            case 0x04: bx_printf(0, "fisub_ed "); bx_debug_Ed(); return;
            case 0x05: bx_printf(0, "fisubr_ed "); bx_debug_Ed(); return;
            case 0x06: bx_printf(0, "fidiv_ed "); bx_debug_Ed(); return;
            case 0x07: bx_printf(0, "fidivr_ed "); bx_debug_Ed(); return;
            default: assert(0); return;
            }
          }
        else { /* mod == 3 */
          switch (opcode) {
            case 0x05:
              if (rm == 1) {
                bx_printf(0, "fucompp "); return;
	        }
              else {
                debug_invalid_opcode(); return;
                }
            default: debug_invalid_opcode(); return;
            }
          }

      case 0xDB: /* ESC3 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        if (mod != 3) {
          switch (opcode) {
            case 0x00: bx_printf(0, "fild_ed "); bx_debug_Ed(); return;
            case 0x01: debug_invalid_opcode(); return;
            case 0x02: bx_printf(0, "fist_ed "); bx_debug_Ed(); return;
            case 0x03: bx_printf(0, "fistp_ed "); bx_debug_Ed(); return;
            case 0x04: debug_invalid_opcode(); return;
            case 0x05: bx_printf(0, "fld_et "); bx_debug_Et(); return;
            case 0x06: debug_invalid_opcode(); return;
            case 0x07: bx_printf(0, "fstp_et "); bx_debug_Et(); return;
            default: assert(0); return;
            }
          }
        else { /* mod == 3 */
          switch (opcode) {
            case 0x04:
              switch (rm) {
                case 0x00: bx_printf(0, "feni "); return;
                case 0x01: bx_printf(0, "fdisi "); return;
                case 0x02: bx_printf(0, "fclex "); return;
                case 0x03: bx_printf(0, "finit "); return;
                case 0x04: bx_printf(0, "fsetpm "); return;
                default: debug_invalid_opcode(); return;
                }
            default: debug_invalid_opcode(); return;
            }
          }

      case 0xDC: /* ESC4 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        if (mod != 3) {
          switch (opcode) {
            case 0x00: bx_printf(0, "fadd_el "); bx_debug_El(); return;
            case 0x01: bx_printf(0, "fmul_el "); bx_debug_El(); return;
            case 0x02: bx_printf(0, "fcom_el "); bx_debug_El(); return;
            case 0x03: bx_printf(0, "fcomp_el "); bx_debug_El(); return;
            case 0x04: bx_printf(0, "fsub_el "); bx_debug_El(); return;
            case 0x05: bx_printf(0, "fsubr_el "); bx_debug_El(); return;
            case 0x06: bx_printf(0, "fdiv_el "); bx_debug_El(); return;
            case 0x07: bx_printf(0, "fdivr_el "); bx_debug_El(); return;
            default: assert(0); return;
            }
          }
        else { /* mod == 3 */
          switch (opcode) {
            case 0x00: bx_printf(0, "fadd_sti_st "); bx_debug_STi_ST(); return;
            case 0x01: bx_printf(0, "fmul_sti_st "); bx_debug_STi_ST(); return;
            case 0x02: bx_printf(0, "fcom_sti_st "); bx_debug_STi_ST(); return;
            case 0x03: bx_printf(0, "fcomp_sti_st "); bx_debug_STi_ST(); return;
            case 0x04: bx_printf(0, "fsubr_sti_st "); bx_debug_STi_ST(); return;
            case 0x05: bx_printf(0, "fsub_sti_st "); bx_debug_STi_ST(); return;
            case 0x06: bx_printf(0, "fdivr_sti_st "); bx_debug_STi_ST(); return;
            case 0x07: bx_printf(0, "fdiv_sti_st "); bx_debug_STi_ST(); return;
            default: debug_invalid_opcode(); return;
            }
          }


      case 0xDD: /* ESC5 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        if (mod != 3) {
          switch (opcode) {
            case 0x00: bx_printf(0, "fld_el "); bx_debug_El(); return;
            case 0x01: debug_invalid_opcode(); return;
            case 0x02: bx_printf(0, "fst_el "); bx_debug_El(); return;
            case 0x03: bx_printf(0, "fstp_el "); bx_debug_El(); return;
            case 0x04: bx_printf(0, "frstor_ea "); bx_debug_Ea(); return;
            case 0x05: debug_invalid_opcode(); return;
            case 0x06: bx_printf(0, "fsave_ea "); bx_debug_Ea(); return;
            case 0x07: bx_printf(0, "fstsw_ew "); bx_debug_Ew(); return;
            default: assert(0); return;
            }
          }
        else { /* mod == 3 */
          switch (opcode) {
            case 0x00: bx_printf(0, "ffree_sti "); bx_debug_STi(); return;
            case 0x01: bx_printf(0, "fxch_sti "); bx_debug_STi(); return;
            case 0x02: bx_printf(0, "fst_sti "); bx_debug_STi(); return;
            case 0x03: bx_printf(0, "fstp_sti "); bx_debug_STi(); return;
            case 0x04: bx_printf(0, "fucom_sti_st "); bx_debug_STi_ST(); return;
            case 0x05: bx_printf(0, "fucomp_sti "); bx_debug_STi(); return;
            case 0x06: debug_invalid_opcode(); return;
            case 0x07: debug_invalid_opcode(); return;
            default: debug_invalid_opcode(); return;
            }
          }

      case 0xDE: /* ESC6 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        if (mod != 3) {
          switch (opcode) {
            case 0x00: bx_printf(0, "fiadd_ew "); bx_debug_Ew(); return;
            case 0x01: bx_printf(0, "fimul_ew "); bx_debug_Ew(); return;
            case 0x02: bx_printf(0, "ficom_ew "); bx_debug_Ew(); return;
            case 0x03: bx_printf(0, "ficomp_ew "); bx_debug_Ew(); return;
            case 0x04: bx_printf(0, "fisub_ew "); bx_debug_Ew(); return;
            case 0x05: bx_printf(0, "fisubr_ew "); bx_debug_Ew(); return;
            case 0x06: bx_printf(0, "fidiv_ew "); bx_debug_Ew(); return;
            case 0x07: bx_printf(0, "fidivr_ew "); bx_debug_Ew(); return;
            default: assert(0); return;
            }
          }
        else { /* mod == 3 */
          switch (opcode) {
            case 0x00: bx_printf(0, "faddp_sti_st "); bx_debug_STi_ST(); return;
            case 0x01: bx_printf(0, "fmulp_sti_st "); bx_debug_STi_ST(); return;
            case 0x02: bx_printf(0, "fcomp_sti "); bx_debug_STi(); return;
            case 0x03:
              switch (rm) {
                case 0x01: bx_printf(0, "fcompp "); return;
                default: debug_invalid_opcode(); return;
                }
            case 0x04: bx_printf(0, "fsubrp_sti_st "); bx_debug_STi_ST(); return;
            case 0x05: bx_printf(0, "fsubp_sti_si "); bx_debug_STi_ST(); return;
            case 0x06: bx_printf(0, "fdivrp_sti_st "); bx_debug_STi_ST(); return;
            case 0x07: bx_printf(0, "fdivp_sti_st "); bx_debug_STi_ST(); return;
            default: debug_invalid_opcode(); return;
            }
          }

      case 0xDF: /* ESC7 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        if (mod != 3) {
          switch (opcode) {
            case 0x00: bx_printf(0, "fild_ew "); bx_debug_Ew(); return;
            case 0x01: debug_invalid_opcode(); return;
            case 0x02: bx_printf(0, "fist_ew "); bx_debug_Ew(); return;
            case 0x03: bx_printf(0, "fistp_ew "); bx_debug_Ew(); return;
            case 0x04: bx_printf(0, "fbld_eb "); bx_debug_Eb(); return;
            case 0x05: bx_printf(0, "fild_eq "); bx_debug_Eq(); return;
            case 0x06: bx_printf(0, "fbstp_eb "); bx_debug_Eb(); return;
            case 0x07: bx_printf(0, "fistp_eq "); bx_debug_Eq(); return;
            default: assert(0); return;
            }
          }
        else { /* mod == 3 */
          switch (opcode) {
            case 0x00: bx_printf(0, "ffree_sti "); bx_debug_STi(); return;
            case 0x01: bx_printf(0, "fxch_sti "); bx_debug_STi(); return;
	    case 0x02: bx_printf(0, "fst_sti "); bx_debug_STi(); return;
	    case 0x03: bx_printf(0, "fstp_sti "); bx_debug_STi(); return;
            case 0x04:
              switch (rm) {
                case 0x01: bx_printf(0, "fstsw_ax "); bx_debug_AX(); return;
                default: debug_invalid_opcode(); return;
                }
            default: debug_invalid_opcode(); return;
            }
          }
 

      case 0xE0: bx_printf(0, "loopne_jb "); bx_debug_Jb(); return;
      case 0xE1: bx_printf(0, "loope_jb "); bx_debug_Jb(); return;
      case 0xE2: bx_printf(0, "loop_jb "); bx_debug_Jb(); return;
      case 0xE3: bx_printf(0, "jcxz_jb "); bx_debug_Jb(); return;
      case 0xE4: bx_printf(0, "in_alib "); bx_debug_ALIb(); return;
      case 0xE5: bx_printf(0, "in_eaxib "); bx_debug_eAXIb(); return;
      case 0xE6: bx_printf(0, "out_ibal "); bx_debug_IbAL(); return;
      case 0xE7: bx_printf(0, "out_ibeax "); bx_debug_IbeAX(); return;
      case 0xE8: bx_printf(0, "call_av "); bx_debug_Av(); return;
      case 0xE9: bx_printf(0, "jmp_jv "); bx_debug_Jv(); return;
      case 0xEA: bx_printf(0, "jmp_ap "); bx_debug_Ap(); return;
      case 0xEB: bx_printf(0, "jmp_jb "); bx_debug_Jb(); return;
      case 0xEC: bx_printf(0, "in_aldx "); bx_debug_ALDX(); return;
      case 0xED: bx_printf(0, "in_eaxdx "); bx_debug_eAXDX(); return;
      case 0xEE: bx_printf(0, "out_dxal "); bx_debug_DXAL(); return;
      case 0xEF: bx_printf(0, "out_dxeax "); bx_debug_DXeAX(); return;

      case 0xF0: /* LOCK */
        break;
      case 0xF1: debug_invalid_opcode(); return;
      case 0xF2: /* REPNE/REPNZ */
        bx_repne_prefix = 1;
        break;
      case 0xF3: /* REP/REPE/REPZ */
        bx_rep_prefix = 1;
        break;
      case 0xF4: bx_printf(0, "hlt "); return;
      case 0xF5: bx_printf(0, "cmc "); return;
      case 0xF6: /* Group 3 Eb */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "test_ebib "); bx_debug_EbIb(); return;
          case 0x01: debug_invalid_opcode(); return;
          case 0x02: bx_printf(0, "not_eb "); bx_debug_Eb(); return;
          case 0x03: bx_printf(0, "neg_eb "); bx_debug_Eb(); return;
          case 0x04: bx_printf(0, "mul_aleb "); bx_debug_ALEb(); return;
          case 0x05: bx_printf(0, "imul_aleb "); bx_debug_ALEb(); return;
          case 0x06: bx_printf(0, "div_aleb "); bx_debug_ALEb(); return;
          case 0x07: bx_printf(0, "idiv_aleb "); bx_debug_ALEb(); return;
          default: assert(0); return;
          }
        return;

      case 0xF7: /* GROUP3 Ev */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "test_eviv "); bx_debug_EvIv(); return;
          case 0x01: debug_invalid_opcode(); return;
          case 0x02: bx_printf(0, "not_ev "); bx_debug_Ev(); return;
          case 0x03: bx_printf(0, "neg_ev "); bx_debug_Ev(); return;
          case 0x04: bx_printf(0, "mul_eaxev "); bx_debug_eAXEv(); return;
          case 0x05: bx_printf(0, "imul_eaxev "); bx_debug_eAXEv(); return;
          case 0x06: bx_printf(0, "div_eaxev "); bx_debug_eAXEv(); return;
          case 0x07: bx_printf(0, "idiv_eaxev "); bx_debug_eAXEv(); return;
          default: assert(0); return;
          }
        return;
      case 0xF8: bx_printf(0, "clc "); return;
      case 0xF9: bx_printf(0, "stc "); return;
      case 0xFA: bx_printf(0, "cli "); return;
      case 0xFB: bx_printf(0, "sti "); return;
      case 0xFC: bx_printf(0, "cld "); return;
      case 0xFD: bx_printf(0, "std "); return;
      case 0xFE: /* GROUP4 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "inc_eb "); bx_debug_Eb(); return;
          case 0x01: bx_printf(0, "dec_eb "); bx_debug_Eb(); return;
          default: debug_invalid_opcode(); return;
          }
        return;

      case 0xFF: /* GROUP 5 */
        mod_rm_byte = bx_debug_peek_next_byte();
        BX_DECODE_MODRM(mod_rm_byte, mod, opcode, rm);
        switch (opcode) {
          case 0x00: bx_printf(0, "inc_ev "); bx_debug_Ev(); return;
          case 0x01: bx_printf(0, "dec_ev "); bx_debug_Ev(); return;
          case 0x02: bx_printf(0, "call_ev "); bx_debug_Ev(); return;
          case 0x03: bx_printf(0, "call_ep "); bx_debug_Ep(); return;
          case 0x04: bx_printf(0, "jmp_ev "); bx_debug_Ev(); return;
          case 0x05: bx_printf(0, "jmp_ep "); bx_debug_Ep(); return;
          case 0x06: bx_printf(0, "push_ev "); bx_debug_Ev(); return;
          default: debug_invalid_opcode(); return;
          }
        return;

      default: /* only invalid instructions left */
        assert(0);
        return;
        break;
      } /* switch (next_byte) */
    } /* for (byte_count... */
  debug_invalid_opcode();
}



  Bit8u
bx_debug_next_byte()
{
  Bit8u next_byte;

  bx_access_virtual(debug_segptr, debug_offset, 1, BX_READ, &next_byte);
  debug_offset++;
  bx_printf(0, "[%02x] ", (int) next_byte);
  return(next_byte);
}

  Bit8u
bx_debug_peek_next_byte()
{
  Bit8u next_byte;

  bx_access_virtual(debug_segptr, debug_offset, 1, BX_READ, &next_byte);
  bx_printf(0, "[%02x] ", (int) next_byte);
  return(next_byte);
}

  Bit16u
bx_debug_next_word()
{
  Bit16u next_word;

  bx_access_virtual(debug_segptr, debug_offset, 2, BX_READ, &next_word);
  debug_offset += 2;
  bx_printf(0, "[%04x] ", (int) next_word);
  return(next_word);
}

  Bit32u
bx_debug_next_dword()
{
  Bit32u next_dword;

  bx_access_virtual(debug_segptr, debug_offset, 4, BX_READ, &next_dword);
  debug_offset += 4;
  bx_printf(0, "[%08x] ", (int) next_dword); 
  return(next_dword);
}

  void
debug_invalid_opcode()
{
  bx_printf(0, "(INVALID OPCODE)\n");
}
