/*
Copyright Notice
================
BOCHS is Copyright 1994 by Kevin P. Lawton.

BOCHS is shareware for PERSONAL USE only.

For more information, read the file 'LICENSE' included in the bochs
distribution.  If you don't have access to this file, or have questions
regarding the licensing policy, the author may be contacted via:

    US Mail:  Kevin Lawton
              528 Lexington St.
              Waltham, MA 02154

    EMail:    bochs@tiac.net
*/


#include "bx_bochs.h"
#include "db_debug.h"



  void
bx_debug_EbGb()
{
  bx_debug_decode_exgx(BX_GENERAL_8BIT_REG, BX_GENERAL_8BIT_REG);
  bx_printf(0, "\n");
}

  void
bx_debug_EvGv()
{
  if (bx_32bit_opsize)
    bx_debug_decode_exgx(BX_GENERAL_32BIT_REG, BX_GENERAL_32BIT_REG);
  else
    bx_debug_decode_exgx(BX_GENERAL_16BIT_REG, BX_GENERAL_16BIT_REG);
  bx_printf(0, "\n");
}

void bx_debug_GbEb() {  bx_printf(0, "\n");
}

  void
bx_debug_GvEv()
{
  if (bx_32bit_opsize)
    bx_debug_decode_exgx(BX_GENERAL_32BIT_REG, BX_GENERAL_32BIT_REG);
  else
    bx_debug_decode_exgx(BX_GENERAL_16BIT_REG, BX_GENERAL_16BIT_REG);
  bx_printf(0, "\n");
}

void bx_debug_ALIb() {bx_printf(0, "\n");}

  void
bx_debug_eAXIv()
{

  if (bx_32bit_opsize) {
    bx_printf(0, "EAX, #%08x\n", (int) bx_debug_next_dword());
    }
  else {
    bx_printf(0, "AX, #%04x\n", (int) bx_debug_next_word());
    }
}

void bx_debug_ES() {bx_printf(0, "\n");}

void bx_debug_Ew() {bx_printf(0, "\n");}
void bx_debug_Ms() {bx_printf(0, "\n");}
void bx_debug_GvEw() {bx_printf(0, "\n");}
void bx_debug_RdCd() {bx_printf(0, "\n");}
void bx_debug_RdDd() {bx_printf(0, "\n");}
void bx_debug_CdRd() {bx_printf(0, "\n");}
void bx_debug_DdRd() {bx_printf(0, "\n");}
void bx_debug_RdTd() {bx_printf(0, "\n");}
void bx_debug_TdRd() {bx_printf(0, "\n");}

  void
bx_debug_Jv()
{
  Bit32u imm32;
  Bit16u imm16;

  if (bx_32bit_opsize) {
    imm32 = bx_debug_next_dword();
    bx_printf(0, "%08x\n", (int) imm32);
    }
  else {
    imm16 = bx_debug_next_word();
    bx_printf(0, "%04x\n", (int) imm16);
    }
}

void bx_debug_Eb() {bx_printf(0, "\n");}
void bx_debug_FS() {bx_printf(0, "\n");}
void bx_debug_EvGvIb() {bx_printf(0, "\n");}
void bx_debug_EvGvCL() {bx_printf(0, "\n");}
void bx_debug_XBTS() {bx_printf(0, "\n");}
void bx_debug_IBTS() {bx_printf(0, "\n");}
void bx_debug_GS() {bx_printf(0, "\n");}
void bx_debug_Mp() {bx_printf(0, "\n");}

  void
bx_debug_EvIb()
{
  Bit8u imm8;

  if (bx_32bit_opsize) {
    bx_debug_decode_exgx(BX_NO_REG_TYPE, BX_GENERAL_32BIT_REG);
    imm8 = bx_debug_next_byte();
    bx_printf(0, ", #%02x\n", (int) imm8);
    }
  else {
    bx_debug_decode_exgx(BX_NO_REG_TYPE, BX_GENERAL_16BIT_REG);
    imm8 = bx_debug_next_byte();
    bx_printf(0, ", #%02x\n", (int) imm8);
    }
}

void bx_debug_GvEb() {bx_printf(0, "\n");}
void bx_debug_EAX() {bx_printf(0, "\n");}
void bx_debug_ECX() {bx_printf(0, "\n");}
void bx_debug_EDX() {bx_printf(0, "\n");}
void bx_debug_EBX() {bx_printf(0, "\n");}
void bx_debug_ESP() {bx_printf(0, "\n");}
void bx_debug_EBP() {bx_printf(0, "\n");}
void bx_debug_ESI() {bx_printf(0, "\n");}
void bx_debug_EDI() {bx_printf(0, "\n");}
void bx_debug_SS() {bx_printf(0, "\n");}
void bx_debug_DS() {bx_printf(0, "\n");}

void bx_debug_eAX() {bx_printf(0, "\n");}
void bx_debug_eCX() {bx_printf(0, "\n");}
void bx_debug_eDX() {bx_printf(0, "\n");}
void bx_debug_eBX() {bx_printf(0, "\n");}
void bx_debug_eSP() {bx_printf(0, "\n");}
void bx_debug_eBP() {bx_printf(0, "\n");}
void bx_debug_eSI() {bx_printf(0, "\n");}
void bx_debug_eDI() {bx_printf(0, "\n");}
void bx_debug_GvMa() {bx_printf(0, "\n");}
void bx_debug_EwRw() {bx_printf(0, "\n");}
void bx_debug_Iv() {bx_printf(0, "\n");}
void bx_debug_GvEvIv() {bx_printf(0, "\n");}

  void
bx_debug_Ib()
{
  Bit8u imm8;

  imm8 = bx_debug_next_byte();
  bx_printf(0, "#%02x\n", imm8);
}

void bx_debug_GvEvIb() {bx_printf(0, "\n");}
void bx_debug_YbDX() {bx_printf(0, "\n");}
void bx_debug_YvDX() {bx_printf(0, "\n");}
void bx_debug_DXXb() {bx_printf(0, "\n");}
void bx_debug_DXXv() {bx_printf(0, "\n");}

  void
bx_debug_Jb()
{
  Bit8s offset;

  offset = (Bit8s) bx_debug_next_byte();
  bx_printf(0, "(%+d)\n", (int) offset);
}

  void
bx_debug_EbIb()
{
  Bit8u imm8;

  bx_debug_decode_exgx(BX_NO_REG_TYPE, BX_GENERAL_8BIT_REG);
  imm8 = bx_debug_next_byte();
  bx_printf(0, " #%x\n", (int) imm8);
}

  void
bx_debug_EvIv()
{
  Bit16u imm16;
  Bit32u imm32;

  if (bx_32bit_opsize) {
    bx_debug_decode_exgx(BX_NO_REG_TYPE, BX_GENERAL_32BIT_REG);
    imm32 = bx_debug_next_dword();
    }
  else {
    bx_debug_decode_exgx(BX_NO_REG_TYPE, BX_GENERAL_16BIT_REG);
    imm16 = bx_debug_next_word();
    }
  bx_printf(0, "\n");
}

void bx_debug_EwSw() {bx_printf(0, "\n");}
void bx_debug_GvM() {bx_printf(0, "\n");}

  void
bx_debug_SwEw()
{
  bx_debug_decode_exgx(BX_SEGMENT_REG, BX_GENERAL_16BIT_REG);
  bx_printf(0, "\n");
}

void bx_debug_Ev() {bx_printf(0, "\n");}
void bx_debug_ECXeAX() {bx_printf(0, "\n");}
void bx_debug_eDXeAX() {bx_printf(0, "\n");}
void bx_debug_eBXeAX() {bx_printf(0, "\n");}
void bx_debug_eSPeAX() {bx_printf(0, "\n");}
void bx_debug_eBPeAX() {bx_printf(0, "\n");}
void bx_debug_eDIeAX() {bx_printf(0, "\n");}
void bx_debug_Ap() {bx_printf(0, "\n");}
void bx_debug_Fv() {bx_printf(0, "\n");}
void bx_debug_ALOb() {bx_printf(0, "\n");}
void bx_debug_eAXOv() {bx_printf(0, "\n");}
void bx_debug_ObAL() {bx_printf(0, "\n");}
void bx_debug_OveAX() {bx_printf(0, "\n");}

  void
bx_debug_XbYb()
{
  bx_printf(0, "DS:[SI] ES:[DI]\n");
}

void bx_debug_XvYv() {bx_printf(0, "\n");}
void bx_debug_YbAL() {bx_printf(0, "\n");}
void bx_debug_YveAX() {bx_printf(0, "\n");}
void bx_debug_ALXb() {bx_printf(0, "\n");}
void bx_debug_eAXXv() {bx_printf(0, "\n");}

void bx_debug_eCXeAX() {bx_printf(0, "\n");}

void bx_debug_CLIb() {bx_printf(0, "\n");}
void bx_debug_BLIb() {bx_printf(0, "\n");}
void bx_debug_AHIb() {bx_printf(0, "\n");}
void bx_debug_CHIb() {bx_printf(0, "\n");}
void bx_debug_DHIb() {bx_printf(0, "\n");}
void bx_debug_BSIb() {bx_printf(0, "\n");}

  void
bx_debug_eCXIv()
{
  Bit16u imm16;
  Bit32u imm32;

  if (bx_32bit_opsize) {
    imm32 = bx_debug_next_dword();
    bx_printf(0, "ECX, %x\n", imm32);
    }
  else {
    imm16 = bx_debug_next_word();
    bx_printf(0, "CX, %x\n", imm16);
    }
}

  void
bx_debug_eDXIv()
{
  Bit16u imm16;
  Bit32u imm32;

  if (bx_32bit_opsize) {
    imm32 = bx_debug_next_dword();
    bx_printf(0, "EDX, %x\n", imm32);
    }
  else {
    imm16 = bx_debug_next_word();
    bx_printf(0, "DX, %x\n", imm16);
    }
}

  void
bx_debug_eBXIv()
{
  Bit16u imm16;
  Bit32u imm32;

  if (bx_32bit_opsize) {
    imm32 = bx_debug_next_dword();
    bx_printf(0, "EBX, %x\n", imm32);
    }
  else {
    imm16 = bx_debug_next_word();
    bx_printf(0, "BX, %x\n", imm16);
    }
}

void bx_debug_eSIIv() {bx_printf(0, "\n");}

  void
bx_debug_eDIIv()
{
  Bit16u imm16;
  Bit32u imm32;

  if (bx_32bit_opsize) {
    imm32 = bx_debug_next_dword();
    bx_printf(0, "EDI, %x\n", imm32);
    }
  else {
    imm16 = bx_debug_next_word();
    bx_printf(0, "DI, %x\n", imm16);
    }
}

void bx_debug_eSIeAX() {bx_printf(0, "\n");}
void bx_debug_DLIb() {bx_printf(0, "\n");}
void bx_debug_BHIb() {bx_printf(0, "\n");}

  void
bx_debug_eSPIv()
{
  Bit16u imm16;
  Bit32u imm32;

  if (bx_32bit_opsize) {
    imm32 = bx_debug_next_dword();
    bx_printf(0, "ESP, %x\n", imm32);
    }
  else {
    imm16 = bx_debug_next_word();
    bx_printf(0, "SP, %x\n", imm16);
    }
}

void bx_debug_eBPIv() {bx_printf(0, "\n");}
void bx_debug_Iw() {bx_printf(0, "\n");}

  void
bx_debug_GvMp()
{
  if (bx_32bit_opsize)
    bx_debug_decode_exgx(BX_GENERAL_32BIT_REG, BX_GENERAL_32BIT_REG);
  else
    bx_debug_decode_exgx(BX_GENERAL_16BIT_REG, BX_GENERAL_16BIT_REG);
  bx_printf(0, "\n");
}

void bx_debug_IwIb() {bx_printf(0, "\n");}
void bx_debug_Eb1() {bx_printf(0, "\n");}
void bx_debug_Ev1() {bx_printf(0, "\n");}
void bx_debug_EbCL() {bx_printf(0, "\n");}
void bx_debug_EvCL() {bx_printf(0, "\n");}
void bx_debug_Es() {bx_printf(0, "\n");}
void bx_debug_ST_STi() {bx_printf(0, "\n");}

void bx_debug_CS() {bx_printf(0, "\n");}
void bx_debug_Ea() {bx_printf(0, "\n");}
void bx_debug_STi() {bx_printf(0, "\n");}
void bx_debug_Et() {bx_printf(0, "\n");}
void bx_debug_Ed() {bx_printf(0, "\n");}
void bx_debug_El() {bx_printf(0, "\n");}
void bx_debug_AX() {bx_printf(0, "\n");}
void bx_debug_eAXIb() {bx_printf(0, "\n");}

  void
bx_debug_IbAL()
{
  Bit8u imm8;

  imm8 = bx_debug_next_byte();
  bx_printf(0, "#%02x, AL\n", imm8, AL);
}

void bx_debug_IbeAX() {bx_printf(0, "\n");}

void bx_debug_STi_ST() {bx_printf(0, "\n");}
void bx_debug_Eq() {bx_printf(0, "\n");}
void bx_debug_Av() {bx_printf(0, "\n");}
void bx_debug_ALDX() {bx_printf(0, "\n");}
void bx_debug_eAXDX() {bx_printf(0, "\n");}
void bx_debug_DXAL() {bx_printf(0, "\n");}
void bx_debug_DXeAX() {bx_printf(0, "\n");}
void bx_debug_ALEb() {bx_printf(0, "\n");}

  void
bx_debug_eAXEv()
{
  if (bx_32bit_opsize) {
    bx_printf(0, "EAX, ");
    bx_debug_decode_exgx(BX_NO_REG_TYPE, BX_GENERAL_32BIT_REG);
    }
  else {
    bx_printf(0, "AX, ");
    bx_debug_decode_exgx(BX_NO_REG_TYPE, BX_GENERAL_16BIT_REG);
    }
  bx_printf(0, "\n");
}

  void
bx_debug_Ep()
{
  if (bx_32bit_opsize) {
    bx_debug_decode_exgx(BX_NO_REG_TYPE, BX_GENERAL_32BIT_REG);
    }
  else {
    bx_debug_decode_exgx(BX_NO_REG_TYPE, BX_GENERAL_16BIT_REG);
    }

  bx_printf(0, "\n");
}

