/*
Copyright Notice
================
BOCHS is Copyright 1994 by Kevin P. Lawton.

BOCHS is shareware for PERSONAL USE only.

For more information, read the file 'LICENSE' included in the bochs
distribution.  If you don't have access to this file, or have questions
regarding the licensing policy, the author may be contacted via:

    US Mail:  Kevin Lawton
              528 Lexington St.
              Waltham, MA 02154

    EMail:    bochs@tiac.net
*/



#include <stdio.h>

#include "bx_bochs.h"


static char command_line[128];

void bx_debug_decode(bx_segment_reg_t *seg, Bit32u offset);

Boolean debug_on = 0;

static Boolean continu = 0;



  void
bx_debug(bx_segment_reg_t *seg, Bit32u offset)
{
if (!debug_on) return;
/*
if (bx_cpu.eflags.cf > 1) {
  bx_printf(1, "=== CF > 1 encountered!!!\n");
  }
*/


  fprintf(bx_logfd, "\n| AX=%04x  BX=%04x  CX=%04x  DX=%04x  SP=%04x  BP=%04x  SI=%04x  DI=%04x\n",
    (int) AX, (int) BX, (int) CX, (int) DX, (int) SP, (int) BP, (int) SI,
    (int) DI);
  fprintf(bx_logfd, "| DS=%04x  ES=%04x  SS=%04x  CS=%04x  IP=%04x   ",
    (int) bx_cpu.ds.selector.value,
    (int) bx_cpu.es.selector.value,
    (int) bx_cpu.ss.selector.value,
    (int) bx_cpu.cs.selector.value,
    (int) bx_cpu.eip);
  fprintf(bx_logfd, "%s %s %s %s %s %s %s %s\n",
    "NV",
    "UP",
    bx_cpu.eflags.if_ ? "EI" : "DI",
    bx_cpu.eflags.sf  ? "NG" : "PL",
    bx_cpu.eflags.zf  ? "ZR" : "NZ",
    bx_cpu.eflags.af  ? "AC" : "NA",
    bx_cpu.eflags.pf  ? "PE" : "PO",
    bx_cpu.eflags.cf  ? "CY" : "NC");


  fprintf(bx_logfd, ">> [%x:%x] ", (int) seg->selector.value,
    (int) offset);

  bx_debug_decode(seg, offset);

return;
  if (continu) return;

  fprintf(bx_logfd, "\ndebug> ");
  scanf(" %[^\n]", command_line);
  if (!strcmp(command_line, "continue")) {
    continu = 1;
    }
}
