/*
Copywrite 1994 by Kevin P. Lawton 

This file is part of the IODEV (Input Output DEVices) component of BOCHS.

The IODEV component is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The IODEV component is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the IODEV component; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include "iodev.h"



  Bit8u
bx_hard_drive_io_read_handler(Bit32u address)
{
  /* HARD DRIVE 0 */
  return(0);
}

  void
bx_hard_drive_io_write_handler(Bit32u address, Bit8u value)
{
  /* HARD DRIVE 0 */
}

  void
bx_hard_drv_int_handler(int vector)
{
}


  void
bx_init_hard_drive(void)
{
  Bit8u zero8;

  typical_int_code[2] = 0x76;
  bx_register_int_vector(0x76, typical_int_code, sizeof(typical_int_code),
      bx_hard_drv_int_handler);

  zero8 = 0;

  /* hard disk status of last operation */
  bx_access_physical(0x474, 1, BX_WRITE, &zero8);

  /* hard disk number attached */
  bx_access_physical(0x475, 1, BX_WRITE, &zero8);

  /* hard disk control byte */
  bx_access_physical(0x476, 1, BX_WRITE, &zero8);

  /* hard disk port offset (XT only ???) */
  bx_access_physical(0x477, 1, BX_WRITE, &zero8);

  /* hard disk status register */
  bx_access_physical(0x48C, 1, BX_WRITE, &zero8);

  /* hard disk error register */
  bx_access_physical(0x48D, 1, BX_WRITE, &zero8);

  /* hard disk task complete flag */
  bx_access_physical(0x48E, 1, BX_WRITE, &zero8);
}
