/*
Copywrite 1994 by Kevin P. Lawton 

This file is part of the IODEV (Input Output DEVices) component of BOCHS.

The IODEV component is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The IODEV component is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the IODEV component; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include "iodev.h"


  Bit8u
bx_parallel_io_read_handler(Bit32u address)
{
  /* PARALLEL PORT 1 */
  return(0);
}

  void
bx_parallel_io_write_handler(Bit32u address, Bit8u value)
{
  /* PARALLEL PORT 1 */
}

  void
bx_parallel_int_handler(int vector)
{
}


  void
bx_init_parallel(void)
{
  Bit16u zero16;
  Bit8u  zero8;

  typical_int_code[2] = 0x0F;
  bx_register_int_vector(0x0F, typical_int_code, sizeof(typical_int_code),
      bx_parallel_int_handler);

  zero16 = 0;

  /* Parallel I/O address, port 1 */
  bx_access_physical(0x408, 2, BX_WRITE, &zero16);

  /* Parallel I/O address, port 2 */
  bx_access_physical(0x40A, 2, BX_WRITE, &zero16);

  /* Parallel I/O address, port 3 */
  bx_access_physical(0x40C, 2, BX_WRITE, &zero16);

  zero8 = 0;

  /* parallel printer 1, timeout */
  bx_access_physical(0x478, 1, BX_WRITE, &zero8);

  /* parallel printer 2, timeout */
  bx_access_physical(0x479, 1, BX_WRITE, &zero8);

  /* parallel printer 3, timeout */
  bx_access_physical(0x47A, 1, BX_WRITE, &zero8);

  /* parallel printer 4, timeout */
  bx_access_physical(0x47B, 1, BX_WRITE, &zero8);
}
