/*
Copywrite 1994 by Kevin P. Lawton 

This file is part of the IODEV (Input Output DEVices) component of BOCHS.

The IODEV component is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The IODEV component is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the IODEV component; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <sys/time.h>

#include "iodev.h"

#define BX_PIT_XFER_MODE_LSB   10
#define BX_PIT_XFER_MODE_MSB   11
#define BX_PIT_XFER_MODE_16BIT 12

#define BX_PIT_STATE_ACTIVE        10
#define BX_PIT_STATE_PENDING_READ  11
#define BX_PIT_STATE_PENDING_WRITE 12


typedef struct {
  Bit8u      mode;
  Bit8u      xfer_mode;
  Bit8u      state;
  Bit16u     latch_value;
  Bit8u      xfer_bytes_remaining;
  Bit16u     counter_max;
  Boolean    bcd_mode;
  } bx_pit_t;

static bx_pit_t timer0;

static Bit8u int08_code[] = {
  0x0F,
  0x1F,
  0x08,
  0xCF    /* IRET */
  };



  Bit8u
bx_pit_io_read_handler(Bit32u address)
{
  return(0);
}

  void
bx_pit_io_write_handler(Bit32u address, Bit8u value)
{
}

  void
bx_pit_int_handler(int vector)
{
  Bit32u ticks;

  bx_access_physical(0x046c, 4, BX_READ, &ticks);
  ticks++;
  bx_access_physical(0x046c, 4, BX_WRITE, &ticks);
  bx_outp(0x20, 0x20); /* send End Of Interrupt Command */
}

  void
bx_init_pit(void)
{

  bx_register_int_vector(0x08, int08_code, sizeof(int08_code),
      bx_pit_int_handler);


  timer0.mode        = 3;  /* square wave */
  timer0.xfer_mode   = BX_PIT_XFER_MODE_16BIT;
  timer0.state       = BX_PIT_STATE_ACTIVE;
  timer0.latch_value = 0;  /* don't care */
  timer0.xfer_bytes_remaining = 0; /* don't care */
  timer0.counter_max = 0;  /* 0xFFFF + 1 : (1193200 / 65535 = 18.2Hz) */
  timer0.bcd_mode    = 0;  /* binary counting mode */



#if 0
  bx_register_timer( bx_pit_timer_handler, 54945); /* 18.2 Hz */
  bx_register_timer( bx_pit_timer_handler, 200000); /* 18.2 Hz */
#endif
}

  void
bx_pit_timer_handler(void)
{
  bx_trigger_irq(0);
}
