/*
Copywrite 1994 by Kevin P. Lawton 

This file is part of the IODEV (Input Output DEVices) component of BOCHS.

The IODEV component is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The IODEV component is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the IODEV component; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include "iodev.h"


  Bit8u
bx_serial_io_read_handler(Bit32u address)
{
  /* SERIAL PORT 1 */
  return(0);
}

  void
bx_serial_io_write_handler(Bit32u address, Bit8u value)
{
  /* SERIAL PORT 1 */
}

  void
bx_serial_int_handler(int vector)
{
}

  void
bx_init_serial(void)
{
  Bit8u  zero8;
  Bit16u zero16;

  typical_int_code[2] = 0x0C;
  bx_register_int_vector(0x0C, typical_int_code, sizeof(typical_int_code),
      bx_serial_int_handler);

  zero16 = 0;

  /* serial I/O address, port 1 */
  bx_access_physical(0x400, 2, BX_WRITE, &zero16);

  /* serial I/O address, port 2 */
  bx_access_physical(0x402, 2, BX_WRITE, &zero16);

  /* serial I/O address, port 3 */
  bx_access_physical(0x404, 2, BX_WRITE, &zero16);

  /* serial I/O address, port 4 */
  bx_access_physical(0x406, 2, BX_WRITE, &zero16);

  zero8 = 0;

  /* serial 1, timeout */
  bx_access_physical(0x47C, 1, BX_WRITE, &zero8);

  /* serial 2, timeout */
  bx_access_physical(0x47D, 1, BX_WRITE, &zero8);

  /* serial 3, timeout */
  bx_access_physical(0x47E, 1, BX_WRITE, &zero8);

  /* serial 4, timeout */
  bx_access_physical(0x47F, 1, BX_WRITE, &zero8);

}
