/*
Copywrite 1994 by Kevin P. Lawton 

This file is part of the IODEV (Input Output DEVices) component of BOCHS.

The IODEV component is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The IODEV component is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the IODEV component; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


/*
  000 ..   3FF      interrupt vector table
  400 ..   500      BIOS data area
  500 ..   8ff      DOS ???
 7C00 ..            1st 512 bytes of bootstrap program loaded here
B0000 .. B1000      MDA video buffer
E0000 .. FFFFF      ROM BIOS



*/

#define BX_DISK_PARAM_TBL  0xF0000  /* 11-byte disk parameter table location */

  /* location of default interrupt handler.  Initially, all int vectors
     are loaded with this value.  Then supported ones are defined */
#define BX_DEFAULT_INT_HANDLER 0xF0010 

  /* 16 byte video initialization data array.  To be sent to ports
     3b4/3b5 */
#define BX_VIDEO_INIT_ARRAY    0xF0020

#define BX_BIOS_CONFIG_TABLE   0xF0030


