/*
Copywrite 1994 by Kevin P. Lawton 

This file is part of the IODEV (Input Output DEVices) component of BOCHS.

The IODEV component is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The IODEV component is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the IODEV component; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include <stdio.h>
#include "iodev.h"
#include "io_mda.h"



  void
bx_register_io_handlers(void)
{
  bx_iodev_t  io_device;
  bx_memdev_t mem_device;

#if 0
  /* 8237 DMA controller */
  io_device.read_funct   = bx_dma_io_read_handler;
  io_device.write_funct  = bx_dma_io_write_handler;
  io_device.handler_name = "DMA controller";
  io_device.start_addr   = 0x0000;
  io_device.end_addr     = 0x000F;
  io_device.irq          = BX_NO_IRQ;
  bx_register_io_handler(io_device);

  io_device.start_addr   = 0x0081;
  io_device.end_addr     = 0x008F;
  bx_register_io_handler(io_device);

  io_device.start_addr   = 0x00C0;
  io_device.end_addr     = 0x00DF;
  bx_register_io_handler(io_device);
#endif


  /* 8254 PIT (Programmable Interval Timer) */
  io_device.read_funct   = bx_pit_io_read_handler;
  io_device.write_funct  = bx_pit_io_write_handler;
  io_device.handler_name = "8254 PIT";
  io_device.start_addr   = 0x0040;
  io_device.end_addr     = 0x0043;
  io_device.irq          = 0;
  bx_register_io_handler(io_device);


  /* 8259 PIC (Programmable Interrupt Controller) */
  io_device.read_funct   = bx_pic_io_read_handler;
  io_device.write_funct  = bx_pic_io_write_handler;
  io_device.handler_name = "8259 PIC";
  io_device.start_addr   = 0x0020;
  io_device.end_addr     = 0x0021;
  io_device.irq          = BX_NO_IRQ;
  bx_register_io_handler(io_device);

  io_device.start_addr = 0x00A0;
  io_device.end_addr   = 0x00A1;
  bx_register_io_handler(io_device);


  /* 8042 keyboard controller */
  io_device.read_funct   = bx_keyboard_io_read_handler;
  io_device.write_funct  = bx_keyboard_io_write_handler;
  io_device.handler_name = "8042 Keyboard controller";
  io_device.start_addr   = 0x0060;
  io_device.end_addr     = 0x0060;
  io_device.irq          = 1;
  bx_register_io_handler(io_device);

  io_device.start_addr   = 0x0064;
  io_device.end_addr     = 0x0064;
  bx_register_io_handler(io_device);


  /* CMOS RAM & RTC */
  io_device.read_funct   = bx_cmos_ram_io_read_handler;
  io_device.write_funct   = bx_cmos_ram_io_write_handler;
  io_device.handler_name = "CMOS RAM";
  io_device.start_addr   = 0x0070;
  io_device.end_addr     = 0x0071;
  io_device.irq          = BX_NO_IRQ;
  bx_register_io_handler(io_device);


#if 0
  /* HARD DRIVE 0 */
  io_device.read_funct   = bx_hard_drive_io_read_handler;
  io_device.write_funct  = bx_hard_drive_io_write_handler;
  io_device.handler_name = "Hard Drive 0";
  io_device.start_addr   = 0x01F0;
  io_device.end_addr     = 0x01F7;
  io_device.irq          = 14;
  bx_register_io_handler(io_device);


  /* PARALLEL PORT 1 */
  io_device.read_funct   = bx_parallel_io_read_handler;
  io_device.write_funct  = bx_parallel_io_write_handler;
  io_device.handler_name = "Parallel Port 1";
  io_device.start_addr   = 0x03BC;
  io_device.end_addr     = 0x03BE;
  io_device.irq          = 7;
  bx_register_io_handler(io_device);


  /* SERIAL PORT 1 */
  io_device.read_funct   = bx_serial_io_read_handler;
  io_device.write_funct  = bx_serial_io_write_handler;
  io_device.handler_name = "Serial Port 1";
  io_device.start_addr   = 0x03F8;
  io_device.end_addr     = 0x03FF;
  io_device.irq          = 4;
  bx_register_io_handler(io_device);
#endif

  /* FLOPPY DRIVE */
  io_device.read_funct   = bx_floppy_io_read_handler;
  io_device.write_funct  = bx_floppy_io_write_handler;
  io_device.handler_name = "Floppy Drive";
  io_device.start_addr   = 0x03F0;
  io_device.end_addr     = 0x03F7;
  io_device.irq          = 6;
  bx_register_io_handler(io_device);


  /* MDA */
  if (bx_use_video) {

    io_device.read_funct   = bx_mda_io_read_handler;
    io_device.write_funct  = bx_mda_io_write_handler;
    io_device.handler_name = "MDA video";
    io_device.start_addr   = 0x03B4;
    io_device.end_addr     = 0x03B5;
    io_device.irq          = BX_NO_IRQ;
    bx_register_io_handler(io_device);

    io_device.start_addr   = 0x03B8;
    io_device.end_addr     = 0x03B8;
    bx_register_io_handler(io_device);

    io_device.start_addr   = 0x03CA;
    io_device.end_addr     = 0x03CA;
    bx_register_io_handler(io_device);


    mem_device.start_addr   = 0xB0000;
    mem_device.end_addr     = 0xB0FFF;
    mem_device.handler_name = "MDA video";
    mem_device.read_funct   = bx_mda_mem_read;
    mem_device.write_funct  = bx_mda_mem_write;
    bx_register_mem_handler(mem_device);
    }
}

