/*
 *	ole.h	-	Declarations for OLESVR and OLECLI
 */

typedef LPCSTR	OLE_LPCSTR;

typedef enum
{
    OLE_OK=0, /* Yes Sir! */
    OLE_WAIT_FOR_RELEASE,
    OLE_BUSY,
    OLE_ERROR_PROTECT_ONLY,
    OLE_ERROR_MEMORY,
    OLE_ERROR_STREAM,
    OLE_ERROR_STATIC,
    OLE_ERROR_BLANK,
    OLE_ERROR_DRAW,
    OLE_ERROR_METAFILE,
    OLE_ERROR_ABORT,
    OLE_ERROR_CLIPBOARD,
    OLE_ERROR_FORMAT,
    OLE_ERROR_OBJECT,
    OLE_ERROR_OPTION,
    OLE_ERROR_PROTOCOL,
    OLE_ERROR_ADDRESS,
    OLE_ERROR_NOT_EQUAL,
    OLE_ERROR_HANDLE,
    OLE_ERROR_GENERIC,
    OLE_ERROR_CLASS,
    OLE_ERROR_SYNTAX,
    OLE_ERROR_DATATYPE,
    OLE_ERROR_PALETTE,
    OLE_ERROR_NOT_LINK,
    OLE_ERROR_NOT_EMPTY,
    OLE_ERROR_SIZE,
    OLE_ERROR_DRIVE,
    OLE_ERROR_NETWORK,
    OLE_ERROR_NAME,
    OLE_ERROR_TEMPLATE,
    OLE_ERROR_NEW,
    OLE_ERROR_EDIT,
    OLE_ERROR_OPEN,
    OLE_ERROR_NOT_OPEN,
    OLE_ERROR_LAUNCH,
    OLE_ERROR_COMM,
    OLE_ERROR_TERMINATE,
    OLE_ERROR_COMMAND,
    OLE_ERROR_SHOW,
    OLE_ERROR_DOVERB,
    OLE_ERROR_ADVISE_NATIVE,
    OLE_ERROR_ADVISE_PICT,
    OLE_ERROR_ADVISE_RENAME,
    OLE_ERROR_POKE_NATIVE,
    OLE_ERROR_REQUEST_NATIVE,
    OLE_ERROR_REQUEST_PICT,
    OLE_ERROR_SERVER_BLOCKED,
    OLE_ERROR_REGISTRATION,
    OLE_ERROR_ALREADY_REGISTERED,
    OLE_ERROR_TASK,
    OLE_ERROR_OUTOFDATE,
    OLE_ERROR_CANT_UPDATE_CLIENT,
    OLE_ERROR_UPDATE,
    OLE_ERROR_SETDATA_FORMAT,
    OLE_ERROR_STATIC_FROM_OTHER_OS,
    OLE_WARN_DELETE_DATA = 1000
} OLESTATUS;

typedef enum{
	OLE_SERVER_MULTI,
	OLE_SERVER_SINGLE
} OLE_SERVER_USE;
/* dunno if the values are correct, somebody please check */
typedef enum {
	OLE_CHANGED,
	OLE_CLOSED,
	OLE_QUERY_PAINT,
	OLE_QUERY_RETRY,
	OLE_RELEASE,
	OLE_RENAMED,
	OLE_SAVED
} OLE_NOTIFICATION;

typedef	LONG	LHSERVER;
typedef LONG	LHSERVERDOC;
typedef LONG	LHCLIENTDOC;
typedef LONG	OLECLIPFORMAT;/* dunno about this type, please change/add */
typedef LONG	OLEOPT_UPDATE;/* dunno about this type, please change/add */
typedef OLEOPT_UPDATE*	LPOLEOPT_UPDATE;/* dunno about this type, please change/add */
typedef LONG	*OLE_RELEASE_METHOD;/* dunno */

typedef struct _OLETARGETDEVICE {
	UINT	otdDeviceNameOffset;
	UINT	otdDriverNameOffset;
	UINT	otdPortNameOffset;
	UINT	otdExtDevmodeOffset;
	UINT	otdExtDevmodeSize;
	UINT	otdEnvironmentOffset;
	UINT	otdEnvironmentSize;
	BYTE	otdData[1];
	/* ... */
} OLETARGETDEVICE;
typedef struct _OLESTREAM* LPOLESTREAM;
typedef struct _OLESTREAMVTBL {
	DWORD	(CALLBACK* Get)(LPOLESTREAM,LPSTR,DWORD);
	DWORD	(CALLBACK* Put)(LPOLESTREAM,LPSTR,DWORD);
} OLESTREAMVTBL;
typedef OLESTREAMVTBL*	LPOLESTREAMVTBL;
typedef struct _OLESTREAM {
	LPOLESTREAMVTBL	lpstbl;
} OLESTREAM;
typedef struct _OLESERVERDOC*	LPOLESERVERDOC;
typedef struct _OLEOBJECT*	LPOLEOBJECT;
typedef struct _OLECLIENT*	LPOLECLIENT;
typedef struct _OLESERVERDOCVTBL {
	OLESTATUS	(CALLBACK* Save)(LPOLESERVERDOC);
	OLESTATUS	(CALLBACK* Close)(LPOLESERVERDOC);
	OLESTATUS	(CALLBACK* SetHostNames)(LPOLESERVERDOC,OLE_LPCSTR,OLE_LPCSTR);
	OLESTATUS	(CALLBACK* SetDocDimensions)(LPOLESERVERDOC,LPRECT);
	OLESTATUS	(CALLBACK* GetObject)(LPOLESERVERDOC,OLE_LPCSTR,LPOLEOBJECT*,LPOLECLIENT);
	OLESTATUS	(CALLBACK* Release)(LPOLESERVERDOC);
	OLESTATUS	(CALLBACK* SetColorScheme)(LPOLESERVERDOC,LPLOGPALETTE);
	OLESTATUS	(CALLBACK* Execute)(LPOLESERVERDOC,HGLOBAL);
} OLESERVERDOCVTBL;
typedef OLESERVERDOCVTBL*	LPOLESERVERDOCVTBL;
typedef struct _OLESERVERDOC {
	LPOLESERVERDOCVTBL	lpvtbl;
	/* server provided state info */
} OLESERVERDOC;

typedef struct _OLESERVER*	LPOLESERVER;
typedef struct _OLESERVERVTBL {
	OLESTATUS	(CALLBACK* Open)(LPOLESERVER,LHSERVERDOC,OLE_LPCSTR,LPOLESERVERDOC *);
	OLESTATUS	(CALLBACK* Create)(LPOLESERVER,LHSERVERDOC,OLE_LPCSTR,OLE_LPCSTR,LPOLESERVERDOC FAR*);
	OLESTATUS	(CALLBACK* CreateFromTemplate)(LPOLESERVER,LHSERVERDOC,OLE_LPCSTR,OLE_LPCSTR,OLE_LPCSTR,LPOLESERVERDOC *);
	OLESTATUS	(CALLBACK* Edit)(LPOLESERVER,LHSERVERDOC,OLE_LPCSTR,OLE_LPCSTR,LPOLESERVERDOC *);
	OLESTATUS	(CALLBACK* Exit)(LPOLESERVER);
	OLESTATUS	(CALLBACK* Release)(LPOLESERVER); 
	OLESTATUS	(CALLBACK* Execute)(LPOLESERVER); 
} OLESERVERVTBL; 
typedef OLESERVERVTBL	*LPOLESERVERVTBL;
typedef struct _OLESERVER {
	LPOLESERVERVTBL	lpvtbl;
	/* server specific data */
} OLESERVER;
typedef struct _OLECLIENTVTBL {
	int (CALLBACK* CallBack)(LPOLECLIENT,OLE_NOTIFICATION,LPOLEOBJECT);
} OLECLIENTVTBL;
typedef OLECLIENTVTBL	*LPOLECLIENTVTBL;

typedef struct _OLECLIENT {
	LPOLECLIENTVTBL	lpvtbl;
	/* client data... */
} OLECLIENT;

typedef struct _OLEOBJECTVTBL {
	void *	(CALLBACK* QueryProtocol)(LPOLEOBJECT,OLE_LPCSTR);
	OLESTATUS	(CALLBACK* Release)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* Show)(LPOLEOBJECT,BOOL);
	OLESTATUS	(CALLBACK* DoVerb)(LPOLEOBJECT,UINT,BOOL,BOOL);
	OLESTATUS	(CALLBACK* GetData)(LPOLEOBJECT,OLECLIPFORMAT,HANDLE *);
	OLESTATUS	(CALLBACK* SetData)(LPOLEOBJECT,OLECLIPFORMAT,HANDLE);
	OLESTATUS	(CALLBACK* SetTargetDevice)(LPOLEOBJECT,HGLOBAL);
	OLESTATUS	(CALLBACK* SetBounds)(LPOLEOBJECT,LPRECT);
	OLESTATUS	(CALLBACK* EnumFormats)(LPOLEOBJECT,OLECLIPFORMAT);
	OLESTATUS	(CALLBACK* SetColorScheme)(LPOLEOBJECT,LPLOGPALETTE);
	OLESTATUS	(CALLBACK* Delete)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* SetHostNames)(LPOLEOBJECT,OLE_LPCSTR,OLE_LPCSTR);
	OLESTATUS	(CALLBACK* SaveToStream)(LPOLEOBJECT,LPOLESTREAM);
	OLESTATUS	(CALLBACK* Clone)(LPOLEOBJECT,LPOLECLIENT,LHCLIENTDOC,OLE_LPCSTR,LPOLEOBJECT *);
	OLESTATUS	(CALLBACK* CopyFromLink)(LPOLEOBJECT,LPOLECLIENT,LHCLIENTDOC,OLE_LPCSTR,LPOLEOBJECT *);
	OLESTATUS	(CALLBACK* Equal)(LPOLEOBJECT,LPOLEOBJECT);
	OLESTATUS	(CALLBACK* CopyToClipBoard)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* Draw)(LPOLEOBJECT,HDC,LPRECT,LPRECT,HDC);
	OLESTATUS	(CALLBACK* Activate)(LPOLEOBJECT,UINT,BOOL,BOOL,HWND,LPRECT);
	OLESTATUS	(CALLBACK* Execute)(LPOLEOBJECT,HGLOBAL,UINT);
	OLESTATUS	(CALLBACK* Close)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* Update)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* Reconnect)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* ObjectConvert)(LPOLEOBJECT,OLE_LPCSTR,LPOLECLIENT,LHCLIENTDOC,OLE_LPCSTR,LPOLEOBJECT*);
	OLESTATUS	(CALLBACK* GetLinkUpdateOptions)(LPOLEOBJECT,LPOLEOPT_UPDATE);
	OLESTATUS	(CALLBACK* SetLinkUpdateOptions)(LPOLEOBJECT,OLEOPT_UPDATE);
	OLESTATUS	(CALLBACK* Rename)(LPOLEOBJECT,OLE_LPCSTR);
	OLESTATUS	(CALLBACK* QueryName)(LPOLEOBJECT,LPSTR,LPUINT);
	OLESTATUS	(CALLBACK* QueryType)(LPOLEOBJECT,LPLONG);
	OLESTATUS	(CALLBACK* QueryBounds)(LPOLEOBJECT,LPRECT);
	OLESTATUS	(CALLBACK* QuerySize)(LPOLEOBJECT,LPDWORD);
	OLESTATUS	(CALLBACK* QueryOpen)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* QueryOutOfDate)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* QueryReleaseStatus)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* QueryReleaseError)(LPOLEOBJECT);
	OLE_RELEASE_METHOD	(CALLBACK* QueryReleaseMethod)(LPOLEOBJECT);
	OLESTATUS	(CALLBACK* RequestData)(LPOLEOBJECT,OLECLIPFORMAT);
	OLESTATUS	(CALLBACK* ObjectLong)(LPOLEOBJECT,UINT,LPLONG);
} OLEOBJECTVTBL;
typedef OLEOBJECTVTBL*	LPOLEOBJECTVTBL;

typedef struct _OLEOBJECT {
	LPOLEOBJECTVTBL	lpvtbl;
} OLEOBJECT;


OLESTATUS WINAPI OleRegisterServer(LPCSTR,LPOLESERVER,LHSERVER *,HINSTANCE,OLE_SERVER_USE);
OLESTATUS WINAPI OleUnblockServer(LHSERVER,BOOL *);
OLESTATUS WINAPI OleRegisterServerDoc(LHSERVER,LPCSTR,LPOLESERVERDOC,LHSERVERDOC *);
OLESTATUS WINAPI OleRegisterClientDoc(LPCSTR,LPCSTR,LONG,LHCLIENTDOC *);
OLESTATUS WINAPI OleRenameClientDoc(LHCLIENTDOC,LPCSTR);
OLESTATUS WINAPI OleRevokeServerDoc(LHSERVERDOC);
OLESTATUS WINAPI OleRevokeClientDoc(LHCLIENTDOC);
OLESTATUS WINAPI OleRevokeServer(LHSERVER);
