/* common.c */

/* Copyright (C) 1993 Free Software Foundation, Inc.

This file is part of the GNU Accounting Utilities

The GNU Accounting Utilities are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
2, or (at your option) any later version.

The GNU Accounting Utilities are distributed in the hope that they will
be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Accounting Utilities; see the file COPYING.  If
not, write to the Free Software Foundation, 675 Mass Ave, Cambridge,
MA 02139, USA.  */

#include "config.h"
#include <stdio.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <string.h>
#include <math.h>
#include "common.h"

static char rcsid[] = "$Id: common.c,v 1.3 1994/03/23 02:52:39 noel Exp $";

extern char *program_name;

/* Same as `malloc' but report error if no memory available.  */

char *
xmalloc (unsigned size)
{
  register char *value = (char *) malloc (size);
  if (value == 0)
    fatal ("virtual memory exhausted");
  return value;
}

/* Exit the program with error message S */

void
fatal (char *s)
{
  fprintf (stderr, "%s: %s\n", program_name, s);
  exit (1);
}

/* open file FILE_NAME & return a pointer to it */

FILE *
open_binary (char *file_name)
{
  FILE *fp;
  
  if ( (fp = fopen (file_name, "rb")) == NULL )
    {
      char err_txt[255];
      sprintf (err_txt, "couldn't open file '%s'", file_name);
      fatal (err_txt);
    }
  return fp;
}

/* check to see if a name is in the name list */

int
desired_name (char *the_name)
{
  struct name_entry *np;
  extern struct name_entry *name_list;

  for (np = name_list; np != NULL; np = np->next)
    {
      if (strncmp (np->name, the_name, 8) == 0)
	{
	  return 1;             /* success */
	}
    }
  return 0;                     /* failure */
}

#ifdef HAVE_COMP_T

/* convert a comp_t to a double */

double
comp_t_2_double (comp_t c_num)
{
  short ex = 0;			/* the exponent */
  short in = 0;			/* the number part */
  double fl = 0.0;		/* the floating point result */
  
  /* comp_t are strange numbers -- of 16 bits, the first three are are
     the exponent and the last 13 are the number.  The exp is base 8
     (yuck)! */
  
  if (c_num & 0x8000) ex |= 0x0004;
  if (c_num & 0x4000) ex |= 0x0002;
  if (c_num & 0x2000) ex |= 0x0001;
  in = c_num & 0x1fff;
  fl = (double) in * pow (8.0, (double) ex);
  
  /* printf ("%x -> %d %d -> %f\n",
     (int) c_num, (int) ex, (int) in, fl); */
  
  return fl;
}

#endif /* HAVE_COMP_T */
