/* last.h */

/* Copyright (C) 1993 Free Software Foundation, Inc.

This file is part of the GNU Accounting Utilities

The GNU Accounting Utilities are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
2, or (at your option) any later version.

The GNU Accounting Utilities are distributed in the hope that they will
be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Accounting Utilities; see the file COPYING.  If
not, write to the Free Software Foundation, 675 Mass Ave, Cambridge,
MA 02139, USA.  */

#include "config.h"

/* ye olde defines */

#define STILL_ON 0
#define SHUTDOWN 1
#define REBOOT 2
#define REGULAR 3
#define SPECIAL 4
#define SUPPLANT 5

#define BUFFERED_RECS 256

/* define some data structures */

struct hash_entry {
  struct hash_entry *next;
  char ut_line[8];
  long time;
  int fake_entry;
};

/* static stuff */

/* prototypes */

void log_everyone_in (long, int, char *);
void give_usage (void);
void parse_entries (void);
void update_system_time (long);
void init_flags_and_data (void);
void log_out (struct utmp *, int);
void log_in (struct utmp *);
void print_record (struct utmp *, struct hash_entry *, int);
int get_entry (struct utmp **);

#if !defined (SVR4) && !defined (_POSIX_SOURCE)
RETSIGTYPE handler (int, int, struct sigcontext *);
#else
RETSIGTYPE handler (int);
#endif


