/* sa.h */

/* Copyright (C) 1993 Free Software Foundation, Inc.

This file is part of the GNU Accounting Utilities

The GNU Accounting Utilities are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
2, or (at your option) any later version.

The GNU Accounting Utilities are distributed in the hope that they will
be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Accounting Utilities; see the file COPYING.  If
not, write to the Free Software Foundation, 675 Mass Ave, Cambridge,
MA 02139, USA.  */

#include "common.h"		/* get CMD_LEN */

#define CMD_TABLE_SIZE 601	/* yet another prime */

struct sum_entry {
  struct sum_entry *next;
  char name[CMD_LEN];		/* command name */
  char exec_flag;		/* did command do exec after it was forked? */
  double user_time;		/* user time */
  double sys_time;		/* system time */
  double elapsed_time;		/* real time */
  double mem_usage;		/* total memory usage */
  double disk_io;		/* how many disk I/O operations */
  long num_calls;		/* how many times this command called */
};
  
/*
 * THIS SHOULD REALLY BE IN <sys/acct.h>!  I spent a long time trying to
 * figure out what the format was -- it should be public.
 */
struct savacct {
  char name[10];		/* command name */
  long num_calls;		/* number of times command called */
  double elapsed_time;
  double user_time;
  double sys_time;
  double mem_usage;
  double disk_io;
};

/* sort types */

enum {
  sort_sys_plus_user,
  sort_sys_plus_user_div_calls,
  sort_avio,
  sort_tio,
  sort_cpu_mem_average,
  sort_cpu_storage,
  sort_num_calls
};

void main (int, char *[]);
void give_usage (void);
void parse_savacct_entries (void);
void parse_entries (void);
void init_flags_and_data (void);
void setup_devices (void);
int hash_name (char *);
void update_command_list (char *, long, double, double, double,
			  double, double, char);
int compare_sum_entry (struct sum_entry **, struct sum_entry **);
void print_command_list (void);
char *uid_name (int);

