/*
 * --  utils.h
 */
#ifndef _utils_
#define _utils_
#include <pthread.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <dirent.h>
#include <stdio.h>
#if __STDC__
# include <stdarg.h>
#else
# include <varargs.h>       /* It's a BSD system */
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int
fprintf_r( FILE *stream, const char *format, ... );

extern int
printf_r( const char *format, ... );

extern void *
malloc_r( size_t bytes );

extern void
free_r( void *ptr );

extern struct dirent *
readdir_r( DIR *dir );

extern DIR *
opendir_r( const char *name );

extern int
closedir_r( DIR *dp );

extern void
print_system_counters( void );

extern int
create_joinable( pthread_t *th, thread_proc_t proc, void *arg );

extern char *
strchr_r( const char *s, int c );

extern char *
strrchr_r( const char *s, int c );

extern char *
strcpy_r( char *dest, const char *src );

extern char *
strncpy_r( char *dest, const char *src, size_t n );

extern size_t
strlen_r( const char *s );

extern int
strcmp_r( const char *s1, const char *s2 );

extern int
strncmp_r( const char *s1, const char *s2, size_t p );

extern long
strtol_r( const char *nptr, char **endptr, int base );

extern char *
strerror_r( int errno );

extern char *
strcat_r( char *dest, const char *src );

extern char *
strncat_r( char *dest, const char *src, size_t n );

extern int
stat_r( const char *file_name, struct stat *buf );

extern int
fstat_r( int filedes, struct stat *buf );

extern int
lstat_r( const char *file_name, struct stat *buf );

#define THREAD_SUCCESS ((void *)SUCCESS)
#define THREAD_FAILURE ((void *)FAILURE)

#define CHECK(status,msg) \
        { \
           if( status == FAILURE ) \
           { \
               fprintf_r(stderr, "%s!\n", msg ); \
               pthread_exit( THREAD_FAILURE ); \
           } \
       }

#ifdef __cplusplus
}
#endif
#endif

