#ifndef _GS105_H
#define _GS105_H

/*
 *  Copyright (c) 1994 Willem Dantuma  (willemd@knoware.nl )
 *  Copyright (c) 1994 Thomas Faehnle  (Thomas.Faehnle@student.uni-ulm.de)
 *
 *  gs105.h,v 0.0.1 1994/08/13 
 */

#include "scanner.h"

struct bank_struct {
	int rg[9];
} gsiob[4] = {
{0x272,0x273,0x27a,0x27b,0x275,0x276,0x277,0x270,0x29c },
{0x2e1,0x2e2,0x2e3,0x2e4,0x2e5,0x2e6,0x2e7,0x2e0,0x2ec },
{0x371,0x372,0x373,0x374,0x375,0x376,0x377,0x370,0x37c },
{0x3e1,0x3e2,0x3e3,0x3e4,0x3e5,0x3e6,0x3e7,0x3e0,0x3ec }};

#define GS105_SCANNER_NAME	"GS105G"
#define GS105_SCANNER_MAJOR	26	/* our major number */
#define GS_IOBANK		0	/* IO bank 0,1,2 or 3 */
					/* 0 = 270-27B */
					/* 1 = 2E0-2E7 */
					/* 2 = 370-377 */
					/* 3 = 3E0-3E7 */
#define GS_IRQ			5	/* used IRQ  (2, or 5 ) */
#define GS_DMA			3	/* used DMA channel  (1 or 3) */

#define COPY_BUFFER		5120

#define DEFAULT_BUFLINES	50	/* default # of scanlines in buffer */

/****************************************************************************
 *
 * It may be wise not to touch anything below this line...
 *
 ****************************************************************************/

#define MAX_BUFSIZ		(1<<19) /* max. buffer size (bytes), prevents one
					   from locking up all mem as scan buffer 8-) */

#define MAX_BLK			(4072 - HEADERSIZ) /* <--- don't touch this */
					/* max. chunk of mem we can get with kmalloc()
					   note: this is likely to change in the future */

#if GS_IRQ == 2
#  define GS_IRQ_MSK	0x00
#elif GS_IRQ == 5
#  define GS_IRQ_MSK	0x10
#else
#error "I can't use an IRQ line other than 2 or 5!"
#endif

#if GS_DMA == 1
#  define GS_DMA_MSK	0x00
#elif GS_DMA == 3
#  define GS_DMA_MSK	0x40
#else
#error "DMA lines other than 1 or 3 can't be used!"
#endif

#if DEFAULT_BUFLINES >= 500
#error "Well, I think a buffer with >= 500 lines is a bit excessive, isn't it?"
#endif

#define GS_DMA_IRQ	7
#define GS_CONTROL	2
#define GS_STATUS	1
#define GS_MODE		6
#define GS_CLEAR	3

#define GS_ON		0x01
#define GS_OFF		0x00

#define GS_READY_MSK	0x80

#define GS_BPL_100G	413
#define GS_BPL_200G	827
#define GS_BPL_300G	1240
#define GS_BPL_400G	1654
#define GS_BPL_100	52
#define GS_BPL_200	104
#define GS_BPL_300	155
#define GS_BPL_400	207
#define GS_100		100
#define GS_200		200
#define GS_300		300
#define GS_400		400

#define HEADERSIZ		12	/* size of buffer header (take alignment into account) */

struct buffer_block_struct {
  struct buffer_block_struct *next;
  unsigned int blksiz;
  unsigned int blkoff;
  unsigned char data[MAX_BLK];
};

struct device_status_struct {
  char device_open:	1;
  char irq_enabled:	1;
  char process_sleeps:	1;
  char buffer_empty:	1;
};

struct buffer_pointer {
  struct buffer_block_struct *blkptr;
  unsigned int index;
};
#endif /* _GS105_H */
