#ifndef _LOGI32_H
#define _LOGI32_H

/*
 *  Copyright (c) 1994 Andreas Beck (becka@hp.rz.uni-duesseldorf.de)
 *  Many thanks to Thomas Faehnle for the inspiration donated by m105.h
 *  logi32.h,v 0.1 1994/04/26 20:11:42
 */

#define LOGI32_SCANNER_NAME	"logiscan"
#define LOGI32_SCANNER_MAJOR	26	/* our major number */
#define LOGI32_IOBASE		0x280	/* base address of scanner interface
					   (0x280, 0x2A0, 0x330, 0x340) 
					   this MUST match the DIP-settings
					   on the board !*/
#define LOGI32_IRQ		11	/* used IRQ  (may be any,soft select */
#define LOGI32_DMA		1	/* used DMA channel  (1 or 3,
					   soft select) */

#define DEFAULT_BUFLINES	50	/* default # of scanlines in buffer */
#define COPY_BUFFER		5120	/* Copy_Buffer_Size must be big enough
					   for any ONE line in any MODE */

/****************************************************************************
 *
 * It may be wise not to touch anything below this line...
 *
 ****************************************************************************/

#define MAX_BUFSIZ		(1<<19) /* max. buffer size (bytes), prevents one
					   from locking up all mem as scan buffer 8-) */

#define MAX_BLK			(4072 - HEADERSIZ) /* <--- don't touch this */
					/* max. chunk of mem we can get with kmalloc()
					   note: this is likely to change in the future */

#if DEFAULT_BUFLINES >= 500
#error "Well, I think a buffer with >= 500 lines is a bit excessive, isn't it?"
#endif

#define HEADERSIZ		12	/* size of buffer header (take alignment into account) */

struct buffer_block_struct {
  struct buffer_block_struct *next;
  unsigned int blksiz;
  unsigned int blkoff;
  unsigned char data[MAX_BLK];
};

struct device_status_struct {
  char device_open:	1;
  char irq_enabled:	1;
  char process_sleeps:	1;
  char buffer_empty:	1;
};

struct buffer_pointer {
  struct buffer_block_struct *blkptr;
  unsigned int index;
};
#endif /* _LOGI32_H */
