/*
 * scanio.h: ioctl header file for PINT scanner device driver
 */

/*
 *  PINT Pint Is Not TWAIN - common scanner driver interface for UN*X
 *  Copyright (C) 1994 Kenneth Stailey ken@spacenet.com
 *  Slight modifications by Andreas Beck becka@hp.rz.uni-duesseldorf.de
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _SYS_SCANIO
# define _SYS_SCANIO
#include <linux/types.h>

struct scan_io {
  ulong   scan_window_width;	/* width in 1/1200ths of an inch */
  ulong   scan_window_length;	/* length in 1/1200ths of an inch */
  ushort  scan_x_resolution;	/* horizontal resolution in dots-per-inch */
  ushort  scan_y_resolution;	/* vertical resolution in dots-per-inch */
  ulong   scan_x_origin;	/* horizontal coordinate of upper left corner */
  ulong   scan_y_origin;	/* vertical coordinate of upper left corner */
  uchar   scan_image_mode;	/* type of image data sent by scanner */
  uchar   scan_brightness;	/* brightness control for those to can do it */
  uchar   scan_contrast;	/* contrast control for those to can do it */
  uchar   scan_scanner_type;	/* type of scanner (read only variable) */
  uchar   scan_use_adf;		/* whether to use Automatic Document Feeder */
};

struct scan_pixel_sizes {
  uint pix_width;
  uint pix_height;
};

/*
 * defines for different commands
 */
#define SCAN_PAPER_PUSH 33	/* unload the ADF then load it */
#define SCAN_GET 45
#define SCAN_SET 78
#define SCAN_GET_PIXEL_SIZE 99	/* return the size in pixels of the
				   scanner's active area */

/*
 * defines for scan_image_mode field (SIM stands for Scan Image Mode)
 */
#define SIM_BINARY_MONOCHROME   0
#define SIM_DITHERED_MONOCHROME 1
#define SIM_GRAYSCALE 2
#define SIM_COLOR 5
#define SIM_RED   103
#define SIM_GREEN 104
#define SIM_BLUE  105

/*
 * defines for different types of scanners & odm names as comments
 */

#define RICOH_IS410	1	/* ricoh_is410 */
#define FUJITSU		2	/* fujitsu */
#define FUJITSU_M3096G  2	/* fujitsu_m3096g */
#define HP_SCANJET_IIC  3	/* hp_scanjet_IIc */
#define RICOH_FS1	4	/* ricoh_fs1 */
#define SHARP_JX600	5	/* sharp_jx600 */
#define RICOH_IS50	6	/* ricoh_is50 */
#define IBM_2456	7	/* ibm_2456 */
#define UMAX_UC630	8	/* umax_uc630 */
#define UMAX_UG630	9	/* umax_ug630 */
#define LOGI_HANDSCAN	10	/* several logitech handscanners */

#endif	/* _SYS_SCANIO */
