/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *     Copyright (C) 1995 Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dipl.-Ing. Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 */

#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <sys/time.h>

#include "libfb.h"

#define DEBUG(_statement)

unsigned long mode;
fb_mode_t modeinfo;

unsigned char *base;

void do_main(void)
{
    int i, j;
    unsigned long *base1, *base2;
    size_t size;
    int inc;

    struct timeval tv1, tv2;
    struct timezone tz1, tz2;
    long timediff;

#if 0
    gettimeofday(&tv1,&tz1);
    gettimeofday(&tv2,&tz2);
    timediff = 1000*(tv2.tv_sec - tv1.tv_sec)
		+ (tv2.tv_usec - tv1.tv_usec)/1000;
    printf("timediff: %li\n",timediff);
#endif

sleep(2);

    size = modeinfo.vidmem;

    fprintf(stderr, "Drawing.\n");

    fb_beep(400,50);

#if 0
    fb_test_test();
#endif

#if 1
    gettimeofday(&tv1,&tz1);

    /* for (i=0; i<8; i++) */ {

	/* Test time to fill screen */
/*
	if (!((i+1)%50))
		fprintf(stderr, "%i\n", i+1);
*/
	memset(base, 7, (size_t)(size));
	inc = modeinfo.scanlinelength*modeinfo.ysize*8/modeinfo.bpp_used/32;
	for (j=0; j<32; j++) {
		fb_beep(500,50);
		memset(base+j*inc, j, inc);
		sleep(1);
	}
	/* memset(base, i, (size_t)(size)); */
/*
	memset(base, 0x00, (size_t)(size));
*/
    }
    gettimeofday(&tv2,&tz2);
    timediff = 1000*(tv2.tv_sec - tv1.tv_sec)
	+ (tv2.tv_usec - tv1.tv_usec)/1000;
    printf("Zeit: %li ms.\n",timediff);
#endif

#if 0
	memset(base, 0xFF, (size_t)(size));
	memset(base, 0x00, (size_t)(size));
	/* fill screen with one banking for each long */
	base1 = (unsigned long*)base;
	base2 = (unsigned long*)(base + size/2);
	gettimeofday(&tv1,&tz1);
	for (i=0; i<size/2/4; i++) {
/*
		*base1++ = 0xFFFFFFFF;
		*base2++ = 0xFFFFFFFF;
*/
		*base1++ = 0x05050505;
		*base2++ = 0x05050505;
	}
	gettimeofday(&tv2,&tz2);
	timediff = 1000*(tv2.tv_sec - tv1.tv_sec)
		+ (tv2.tv_usec - tv1.tv_usec)/1000;
	printf("Zeit: %li ms.\n",timediff);
#if 0
	gettimeofday(&tv1,&tz1);
	fb_test_test();
	gettimeofday(&tv2,&tz2);
	timediff = 1000*(tv2.tv_sec - tv1.tv_sec)
		+ (tv2.tv_usec - tv1.tv_usec)/1000;
	printf("Zeit: %li ms.\n",timediff);
#endif
#endif
    fprintf(stderr, "Done with drawing.\n");
    sleep(2);
}

int main(int argc, char *argv[])
{
  extern int fb_debug;
  fb_debug = 3;
  if (!fb_init()) {
     if (!fb_vt_open()) {
        if (!fb_dev_open()) {
           if (!fb_get_default_mode(&mode)) {
              fb_get_mode_info(mode, &modeinfo);
              if (!fb_set_mode(mode))
                 if (!fb_shm_init()) {
                    if (!fb_mmap()) {
                       if (!fb_get_base(&base))
                          if (!fb_video_on()) {
                             do_main();
                             fb_video_off();
                          }
                       fb_munmap();
                    }
                    fb_shm_close();
                 }
           }
           fb_dev_close();
        }
        fb_vt_close();
     }
     fb_leave();
  }
  return 0;
}
