/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *     Copyright (C) 1995 Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dipl.-Ing. Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 */

/* visa.h */

#ifndef SVGAFB_VISA_H
#define SVGAFB_VISA_H

#include <asm/page.h>		/* PAGE_SIZE */

#define VISA_32K		/* Only use B0000-B7FFF, not B0000-BFFFF */

/* VISA memory layout */

#ifdef VISA_32K
#define CHIP_BANK_SHIFT		15	/* 32k */
#else
#define CHIP_BANK_SHIFT		16	/* 64k */
#endif
#define CHIP_BANK_SIZE		(1 << CHIP_BANK_SHIFT)

#define CHIP_MAX_MEM		(256*1024)
#define CHIP_MIN_BANK_SIZE	(CHIP_BANK_SIZE)
#define CHIP_MAX_BANK_SIZE	(CHIP_BANK_SIZE)
#define CHIP_MAX_PAGES_PER_BANK	(CHIP_MAX_BANK_SIZE/PAGE_SIZE)
#define CHIP_MAX_NUMBER_BANKS	(CHIP_MAX_MEM / CHIP_MIN_BANK_SIZE)
#define CHIP_MAX_NUMBER_PAGES	(CHIP_MAX_NUMBER_BANKS * CHIP_MAX_PAGES_PER_BANK)

struct chip_regs_s {
	unsigned char R1, R12, R13, R14, R15;
	unsigned char mode;
	unsigned char conf;
};

#endif
