/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *      Copyright (C) 1995 Michael Weller (eowmob@exp-math.uni-essen.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Michael Weller (eowmob@exp-math.uni-essen.de or
 * mat42b@aixrs1.hrz.uni-essen.de) Heiderhoefen 116b,
 * D 46049 Oberhausen, Germany.
 */

#include "fb.h"

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/vt.h>
#include <linux/kd.h>
#include <sys/mman.h>
#include <signal.h>
#include <asm/signal.h>


#define SYS_ERROR(str) { perror(str); exit(2); }

int tty_fd;
void beep(unsigned short freq, unsigned short ms)
{
	static err = 0;

	if(err) return;
		
	if (ioctl(tty_fd, KDMKTONE, ((unsigned long)ms<<16) + freq)) {
		perror("KDMKTONE on tty failed");
		err++;
	}
}

void pr_context(struct sigcontext_struct *context) {
	int i;
	char *ptr;

	printf("cs  =     %04x\t", context->cs);
	printf("ds  =     %04x\t", context->ds);
	printf("es  =     %04x\n", context->es);
	printf("fs  =     %04x\t", context->fs);
	printf("gs  =     %04x\t", context->gs);
	printf("ss  =     %04x\n", context->ss);

	printf("edi = %08lx\t", context->edi);
	printf("esi = %08lx\t", context->esi);
	printf("ebp = %08lx\t", context->ebp);
	printf("esp = %08lx\n", context->esp);
	printf("ebx = %08lx\t", context->ebx);
	printf("edx = %08lx\t", context->edx);
	printf("ecx = %08lx\t", context->ecx);
	printf("eax = %08lx\n", context->eax);
	printf("err = %08lx\t", context->err);
	printf("eip = %08lx\n", context->eip);

	printf("eflags = %08lx\t", context->eflags);
	printf("trapno = %08lx\t", context->trapno);
	printf("esp_at_signal = %08lx\n", context->esp_at_signal);

	printf("i387 = %08lx\t", context->i387);
	printf("oldmask = %08lx\t", context->oldmask);
	printf("cr2 = %08lx\n", context->cr2);

	puts("code sequence:");
	for(ptr = (char *)context->eip, i = 0; i < 26; i++)
		printf("%02x ", (*ptr++) & 0xff);
	puts("");
}

void sigsegv(int i, struct sigcontext_struct context) {
	printf("SIGSEGV:\n");
	pr_context(&context);
}

void sigbus(int i, struct sigcontext_struct context) {
	printf("SIGBUS:\n");
	pr_context(&context);
}

int main(int argc, char *argv[]) {
	int fd;
	int i;
	int pixval;
#if 0
	unsigned long *lptr;
#endif
	unsigned char *bba, *base;


	struct sigaction action;

	action.sa_handler = (void *)sigsegv;
	sigemptyset(&action.sa_mask);
	action.sa_flags = SA_ONESHOT;

	sigaction(SIGSEGV, &action, NULL);

	action.sa_handler = (void *)sigbus;
	sigemptyset(&action.sa_mask);
	action.sa_flags = SA_ONESHOT;

	sigaction(SIGBUS, &action, NULL);

	if ((tty_fd = open("/dev/tty", O_RDWR)) < 0)
		SYS_ERROR("Opening: /dev/tty");

	if ((fd = open("/dev/fb", O_RDWR)) < 0)
		SYS_ERROR("Opening: /dev/fb");

	beep(400,50);

	base = mmap(NULL, 1024*1024, PROT_READ|PROT_WRITE, MAP_SHARED, fd, (off_t)0);
	if (base == (void *)-1)
		SYS_ERROR("mmap");

	printf("base = %8lx\n", (unsigned long)base);
	fflush(stdout);

	bba = mmap((void *)(base + 64*1024), 64*1024, PROT_READ|PROT_WRITE, MAP_FIXED|MAP_SHARED,
			 fd, (off_t)128*1024);
	if (bba == (void *)-1)
		SYS_ERROR("mmap2");

	printf("bba = %8lx\n", (unsigned long)bba);

	sleep(1);
	beep(500,50);

	pixval = 0;

	for (i = 0; i < 50; i+= 1) {
		memset(base, pixval, 1024*1024);
		pixval += 0x01010101;
	}

	beep(500,50);

#if 0
	memcpy(base, base+4, 1024*512);
	for (i = 0, lptr = (void *)(base + 1); i < 1024*1024; i++)
		*lptr++ = 0xaaaaaaaa;
#endif

	printf("Did memaccess!\n");

	for (i = 0; i < 30; i++) {
		sleep(1);
		beep(1000,80);
	}

	return 0;
}
