#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <linux/vt.h>
#include <string.h>
#include "graphlib.h"

int timeout=1;

struct ggi_Palentry pal[256];


int getic(void)
{ FILE *hand;
  int num,cnt;
  if ((hand=fopen("/proc/interrupts","r"))==NULL) 
    { perror("open /proc/interrupts"); 
      ggi_panic("Do you have /proc mounted ?\n"); }
  while(!feof(hand))
  { fscanf(hand,"%d:%d%*[^\n]",&num,&cnt);
    if (num==1) break;
  }
  fclose(hand);
  return(cnt);
}

volatile int switchaway,switchto;

void MyEvHand(struct ggi_event ev)
{ if (ev.evdata.vt.subtype==VT_SWITCH_AWAY) switchaway++;
  if (ev.evdata.vt.subtype==VT_SWITCH_TO) switchto++; }

void blank_screen(void)
{ int c,lx,ly;
  double x,y,dx,dy;
  int xx[256],yy[256];

  srand(time(NULL));
  while(!switchaway&&!ggi_kbhit())
  { lx=x=160;ly=y=10;
    dx=(rand()%0x1ff)/255.0-1;
    dy=(rand()%0xff)/255.0-0.5;
    for(c=0;c<256;c++) xx[c]=yy[c]=5;
    ggi_setcolor(c=0);
    ggi_fillscreen();
    while(!switchaway&&!ggi_kbhit())
    { x+=dx;y+=dy;
      if (x<10||x>309) {dx=-dx;x+=dx;}
      if (y<10||y>189) {dy=-dy;y+=dy;}
      if (y<180) dy+=0.001;
      dx*=.9999;dy*=.9999;
      if (fabs(dx)<1e-6) break;
      if (lx==(int)x&&ly==(int)y) continue;
      c++;c&=0xff;if (!c) c++;
      ggi_setcolor(0);
      ggi_drawcircle(xx[c],yy[c],5);
      lx=xx[c]=x;ly=yy[c]=y;
      ggi_setcolor(c);
      ggi_drawcircle(xx[c],yy[c],5);
      if (!(c&7)) usleep(1);
    }
  }
}

void go_crazy(void)
{ int x,y;

  for(x=-199;;)
  { if (switchaway||ggi_kbhit()) break;

    y=x;if (y<0) y=-y;

    ggi_setcolor(1);
    ggi_drawhline(0,y,160);

    ggi_setcolor(128);
    ggi_drawhline(160,199-y,160);

    if ((x&3)==0) usleep(1);
    ggi_setcolor(0);
    ggi_drawhline(0,y,160);
    ggi_drawhline(160,199-y,160);

    if (++x>199) x=-199;
  }
}

void vesa_blank(void)
{ ggi_mon_power(PWR_SUSPEND);
  while(!switchaway&&!ggi_kbhit()); }

void vesa_blank2(void)
{ ggi_mon_power(PWR_OFF);
  while(!switchaway&&!ggi_kbhit()); }

struct scrsaver { void (*func)(void);
		  char *name; } SaverList[]=
		{ { blank_screen, "Jumping blob" },
		  { go_crazy,     "Crazy Lines"},
		  { vesa_blank,   "Power Suspend"},
		  { vesa_blank2,  "Power Off"},
		  { NULL       ,  NULL}		/* Terminator */
		   };

struct scrsaver *SaverActive=SaverList;

void do_saver(void)
{ int oldvt;
  switchaway=0;
  if ((oldvt=ggi_get_active_vt())<=0) return;
  ggi_vt_activate(0);
  ggi_setcolor(0);ggi_fillscreen();
  SaverActive->func();
  while(ggi_kbhit()) ggi_getch();
  if (!switchaway) ggi_vt_activate(oldvt);
}

void blank_screen2(void)
{ int c;
  switchaway=0;
  for(c=0;c<200;c++)
  { ggi_setcolor(c+1);ggi_drawhline(0,c,320); }
  while(!switchaway)
  { ggi_setcolor(128);
    ggi_printf(10,10, "*** Screen - Saver ***");
    ggi_printf(10,30, "Configuration Screen :");
    ggi_printf(10,50, "n/p Type: %15s",SaverActive->name);
    ggi_printf(10,70, "+/- Time: %4d minutes",timeout);
    ggi_printf(10,100,"Switch away to activate",timeout);
    switch(ggi_getch())
    { case '+': if (timeout<1440) timeout++;break;
      case '-': if (timeout>   1) timeout--;break;
      case 'p': if (SaverActive-SaverList>0) SaverActive--;break;
      case 'n': if ((SaverActive+1)->func) SaverActive++;break;
      case 't': do_saver();
    }
  }
}

int main(int argc,char *argv[])
{ int ic,ic2,cnt,x;

  ggi_init();
  ggi_register_evh(EV_ALL,MyEvHand);
  ggi_graphmode(320,200,1024,1024,GT_8BIT);

  for(ic=1;ic<256;ic++)
  { pal[ic].r=abs(ic-128);pal[ic].b=128-abs(ic-128);pal[ic].g=0; }
  pal[0].r=pal[0].g=pal[0].b=0;
  ggi_setpalvec(0,256,pal);

  ic=cnt=0;
  switchto=1;
  
  if (argc>=2)
  { x=atoi(argv[1]);switchto=0;
    if (x>0&&x<1440 /* 1 Day ... */) timeout=x;
  }

  if (argc>=3)
  { x=atoi(argv[2]);
    if (x>=0&&x<sizeof(SaverList)/sizeof(SaverList[0]))
      SaverActive=SaverList+x;
  }
         
  while(1)
  { 
    if ((ic2=getic())==ic) 
    { if (++cnt>=timeout) 
      { do_saver();
        switchto=0;
      } 
    }
    else {cnt=0;ic=ic2;}
    
    if (!switchto) sleep(60);
    if (switchto) {blank_screen2();switchto=0;}
  }

  ggi_exit();
  return(0);
}
