#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <linux/vt.h>
#include <linux/soundcard.h>
#include <string.h>
#include "graphlib.h"

#define samplen 512*2

unsigned char buffer[samplen],old[samplen];

struct minmax { int min,max; };

void draw_vu(int xp,int width,struct minmax mm)
{   
    ggi_setcolor(2);
		 ggi_drawbox(xp,mm.min+1,width,mm.max-mm.min);
    ggi_setcolor(6);
    if (mm.min< 30) ggi_drawbox(xp,mm.min+1,width,30-mm.min);
    if (mm.max>225) ggi_drawbox(xp,225   +1,width,mm.max-225);
    ggi_setcolor(4);
    if (mm.min< 10) ggi_drawbox(xp,mm.min+1,width,10-mm.min);
    if (mm.max>245) ggi_drawbox(xp,245   +1,width,mm.max-245);
}

int main(void)
{ int handle,x,y,p;
  int subdivval=4;
  int speed=44000;
  char on=2,off=0;
  
  struct minmax akt,chain[7];
  
  akt.min=0;akt.max=255;

  if ((handle=open("/dev/dsp",O_RDONLY|O_NDELAY))==-1) exit(1);

  ioctl(handle,SNDCTL_DSP_RESET   ,NULL);
  ioctl(handle,SOUND_PCM_SUBDIVIDE,&subdivval);
  ioctl(handle,SOUND_PCM_WRITE_RATE,&speed);
    
  ggi_init();
         
  ggi_graphmode(640,480,640,480,GT_8BIT);
  ggi_setcolor(0);p=0;
  ggi_fillscreen();
  ggi_setcolor(4);
  ggi_drawhline(0,  0,540);
  ggi_drawhline(0,257,540);  
  ggi_drawvline(0,  0,258);
  ggi_drawvline(513,0,258);
  ggi_drawvline(540,0,258);

  for(x=0;x<7;x++)
  { chain[x].min=chain[x].max=128; }

  while(1)
  { memcpy(old,buffer,sizeof(old));
    memcpy(buffer,buffer+samplen,sizeof(buffer)-samplen);
    read(handle,buffer+sizeof(buffer)-samplen,samplen);
    ggi_setcolor(2);
    akt.min=255;akt.max=0;
    for(x=y=0;x<512;x++,y+=samplen/512) 
    { if (buffer[y]<akt.min) akt.min=buffer[y]; 
      if (buffer[y]>akt.max) akt.max=buffer[y];
      ggi_putpixel(x+1,1+old[y]   ,&off);
      ggi_putpixel(x+1,1+buffer[y],&on); }
    ggi_setcolor(0);
    ggi_drawbox(515,1,23,256);
    draw_vu(515,6,akt);
    for(x=0;x<7;x++)
    { if (akt.min<chain[x].min) chain[x].min=akt.min;
      if (akt.max>chain[x].max) chain[x].max=akt.max;
      draw_vu(524+x+x,2,chain[x]);
      chain[x].min=(chain[x].min-128)*(59-x)/60+128;
      chain[x].max=(chain[x].max-128)*(59-x)/60+128;
    }
  }

  ggi_exit();
  
  close(handle);
  
  return(0);
}
