#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <linux/vt.h>
#include <string.h>
#include "graphlib.h"

int col,row,chx,chy;

int find_values(char *label)
{ FILE *fd;
  char buffer[1024];
  char buff2 [1024];
  if ((fd=fopen("/etc/TEXTmode","r"))==NULL) 
  { fprintf(stderr,"Could not open /etc/TEXTmode !\n");return(-1); }
  while(!feof(fd))
  { fgets(buffer,1000,fd);
    switch(*buffer)
    {case '#':
     case '\n':
     case '\0': continue;}
   sscanf(buffer,"%s %d %d %d %d",buff2,&col,&row,&chx,&chy);
   if (!strcmp(buff2,label)) {fclose(fd);return(0);}
  }
  fclose(fd);
  fprintf(stderr,"Requested mode %s not found in /etc/TEXTmode !\n",label);
  return(-1);
}

void resizetty(char *devname)
{ struct winsize my_winsize;
  int fd;

  if ((fd = open(devname, O_WRONLY | O_NOCTTY))==-1)
    { perror("open");return; }
  if (ioctl(fd, TIOCGWINSZ, &my_winsize))
    { close(fd);perror("TIOCGWINSZ");return; }
  my_winsize.ws_col=col;
  my_winsize.ws_row=row;
  if (ioctl(fd, TIOCSWINSZ, &my_winsize)) perror("TIOCSWINSZ");
  close(fd);
}

void setfont(void)
{ char cmd[1024];
  sprintf(cmd,"setfont default%dx%d",chx,chy);
  system(cmd);
}
            
void set_text(char *label)
{ if (find_values(label)) return;
  if (col*row>16380)
    fprintf(stderr,"Total number of characters cannot exceed 16K !\n");
  else if (col<50||col>200)
    fprintf(stderr,"Number of coloumns should be within 50-200.\n");
  else if (row<10||row>100)
    fprintf(stderr,"Number of rows should be within 10-100.\n");
  else if (chx!=8&&chx!=9)
    fprintf(stderr,"Fontsize must be 8 or 9 in X-direction.\n");
  else if (chy<4||chy>32)
    fprintf(stderr,"Fontsize must be between 4 and 32 in Y-direction.\n");
  else if (col*8/row/chy!=1)
    fprintf(stderr,"Requested screen geometry is highly nonstandard.\n"
    		   "Please hack the program if you really want this !");
  else 
  { ggi_textmode(col,row,chx,chy);
    resizetty("/dev/tty0");
    setfont();
  }
}

int main(int argc,char *argv[])
{ ggi_init();

  switch(argc)
  { default:fprintf(stderr,"usage : %s ModeName [shell]\n",argv[0]);break;
    case 2:set_text(argv[1]);ggi_keepmode();break;
/*    case 3:set_text(argv[1]);system(argv[2]);break; Doesn't work right now ... */
  }    

  ggi_exit();

  return(0);
}
