/*\
|*| ---------------------------------------------------------------------------
|*|	pseudo code clock setter
|*| ---------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995, The SCRDRV Project
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/

/*\
|*|	system includes
\*/
#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <asm/io.h>

/*\
|*|	GGI includes
\*/
#include "graphdev.h"
#include "kgi-module.h"


/*\
|*| Clock driver dependend #define's shall go here
\*/

#define CLK_VERSION "0.00 ALPHA"

static struct GGI_Range ClockPar[2]={ {10000000,75000000}, {0,0} };
/* you may need this, as you will have to tell them on demand */

/*\
|*|     GGI clock driver interface
\*/

int
kgi_ClockInit(void)
{
  /*\
  |*|	Chip detection (if possible) and initialisation (if necessary) should
  |*|	go here. This code is executed once during module initialisation and
  |*|	can be used to printk copyright messages.
  |*|
  |*|	side effects:	You should save the initial state to be able to restore
  |*|			in ggi_ClockDone().
  |*|	return values:	TRUE	if detection/initialisation was successful
  |*|			FALSE	if detection/initialisation failed
  \*/
}

void
kgi_ClockDone(void)
{
  /*\
  |*|	This is called once during module shutdown thus you might do
  |*|	deinitialisation/restauration or simply print 'goodbye'.
  |*|
  |*|	side effects:	Restore the saved initial state here.
  |*|			NOTE: STATE RESTAURATION DEPENDS ON THE CHIPSET
  |*|			AND RAMDAC AND IS NOT IMPLEMENTED YET.
  \*/
}

void
kgi_ClockGetParameters(struct GGI_Range *params)
{
  /*\
  |*|	returns the possible clock ranges in *params.
  \*/
}

int
kgi_ClockCheckTiming(struct GGI_Timing *TM)
{
  /*\
  |*|	Checks if the desired DCLK rate (TM->clock) could be done.
  |*|	This is called once.
  |*|
  |*|	return values:	TRUE	The requested clock can be done (at least a DCLK
  |*|				rate lower than the requested).
  |*|				TM->clock is modified to the supplied DCLK rate.
  |*|			FALSE	The requested DCLK rate can not be supplied.
  |*|
  |*|	side effects:	may have some, e.g. store frequency and register values
  |*|			to programm during hardware setup (but need not)
  |*|
  |*|	NOTE:	DO NOT MODIFY TM->clock IF NOT RETURNING TRUE !
  |*|           DCLK MUST NOT INCREASE !
  \*/
}

int
kgi_ClockSetTiming(struct GGI_Timing *TM)
{
  /*\
  |*|	Setup hardware to supply the (checked) DCLK rate given by TM->clock.
  |*|	Any register unlocking shall be done by the chipset driver if possible.
  |*|
  |*|	return values:	TRUE	The hardware as been programmed successfully.
  |*|			FALSE	The hardware could not be set. (PRESERVE STATE!)
  |*|
  |*|	side effects:	hardware setup
  \*/
}

int
kgi_ClockIoctl(struct inode *inode, struct file *file, unsigned int cmd,
	       unsigned long arg)
{
  /*\
  |*|	Not used yet, but chipselection for generic drivers, parameter setup
  |*|	or chip specific functions may go here (one day ;-).
  |*|
  |*|	return values:	according to usual ioctl() functions.
  \*/
}

