/* 
   S3 Generic clock generator (16 Clocks) driver.
   
   Functionality Copyright (C) 1995 Koen Gadeyne - kmg@barco.be
   Recoded by Andreas Beck - becka@hp.rz.uni-duesseldorf.de

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*
	Generic S3 clock generator (16 clocks) 
*/

#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/fcntl.h>
#include <linux/vt.h>
#include <sys/ioctl.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include "../include/graphdev.h"
#include "../include/kgi-module.h"
#include "../include/vga_prg.h"

#define SET_CLOCKBITS_0_1(no)   ( outb(( inb(VGA_MISC_R) & 0xf3) | (((no) << 2) & 0x0C) , VGA_MISC_W) ) /* bits 0 and 1 of clock no */

struct ggi_Range ClockPar[]= {
   { 25175000, 25175000},
   { 28322000, 28322000},
   { 31500000, 31500000},
   { 36000000, 36000000},
   { 40000000, 40000000},
   { 44900000, 44900000},
   { 50000000, 50000000},
   { 65000000, 65000000},
   { 75000000, 75000000},
   { 77000000, 77000000},
   { 80000000, 80000000},
   {110000000,110000000},
   {120000000,120000000},
   {130000000,130000000},
   {0,0} };

int clock_order[]=	{ 0,	/* 25.175*/
			  1,	/* 28.322*/
			 11,	/* 31.5  */
			  6,	/* 36    */
			  2,	/* 40    */
			  7,	/* 44.9  */
			  4,	/* 50    */
			 13,	/* 65    */ 
			 14,	/* 75    */
			  5,	/* 77    */
			 10,	/* 80    */
			 12,	/*110    */
			  9,	/*120    */
			  8,	/*130    */
			};


/* Specs say 86MHz, but I get really strange things in textmode then ... */

struct ggi_Range *kgi_GetClockParameters(void)
{ return ClockPar; }

/* This routine is generic for all fixed clock generators */

int kgi_CheckClockTiming(struct ggi_Timing *TM,int olderr)
{ int index;

  if (ClockPar[0].min > TM->clock)
    { TM->clock=ClockPar[0].min;return TC_LOWEST_CLOCK; }
            
  index = 0;
  while (ClockPar[index].max != 0)     /* if max = 0, then {min,max} will be {0,0} ==> end */
  {
    if (ClockPar[index].min == TM->clock) return TC_OK;
    if (ClockPar[index].min >  TM->clock) break;
    index++;    
  }

  TM->clock=ClockPar[index-1].min;return(TC_LOWERED_CLOCK);
}  

int kgi_SetClockTiming(struct ggi_Timing *TM)
{   int index = -1;
    unlock_s3();	 /* set access to S3-Registers - AB */

    /* standard VGA clocks */
    if (TM->clock==0UL||TM->clock==25175000)
      { SET_CLOCKBITS_0_1(0);return(0);}
    if (TM->clock==28322000)
      { SET_CLOCKBITS_0_1(1);return(0);}

    index=0;
    while (ClockPar[index++].max != 0)     /* if max = 0, then {min,max} will be {0,0} ==> end */
    { if (TM->clock == ClockPar[index].min) 
        { SET_CLOCKBITS_0_1(3);    /* select clock #3 to allow extra clocks to be used */
          Outb_CRTC(0x42, (unsigned char)clock_order[index] & 0x0f);
          return(0); }
      index++;
    }
    return(-1);
}

int kgi_ClockIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg)
{ switch(cmd)
  { default : return -ENODRVSUP_ALWAYS_CANT; }
}        

void kgi_ClockInit(void)
{ printk("S3 Generic Clock driver V"VERSION" loading ...\n"); }


void kgi_ClockCleanup(void) {}
