/* 
   ICS 2061 Clock setter - done for SPEA Mercury PCI 2MB VRAM on 7 Apr 95

   Copyright (C) 1995 Andreas Beck - becka@hp.rz.uni-duesseldorf.de

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/fcntl.h>
#include <linux/vt.h>
#include <sys/ioctl.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include "../include/graphdev.h"
#include "../include/kgi-module.h"

void setdotclock(void *ptr) 
  { register unsigned char a;
    register unsigned i;
    unsigned long m;

#define S(x)	outb((x|a),0x3D5)

    outb(0x42,0x3d4);    /* Select Programmable Clock Register */
    a=inb_p(0x3d5)&0xfc;   /* Get old values */

    S(2);S(0);S(2);

    for (i=0; i<6; i++) {S(3);S(2);}

    for (i=0; i<2; i++) {S(0);S(1);}
    
    for (i=0, m=1; i<24; i++, m+=m)
      if (*(unsigned long *)ptr & m)
	S(1), S(0), S(2), S(3);
      else
	S(3), S(2), S(0), S(1);

    S(3);S(2);S(3);S(2);

#undef S

  }

static unsigned _bin, _mul, _div, _gen;
static unsigned long _value;

static unsigned long calcfreq(unsigned long freq)
  { register unsigned i;
    unsigned _err=32767;

#define MUL		1000
#define QUARZ		(2*14318lu)
#define QUARZMUL	(MUL*QUARZ)
    if (freq==0UL||freq==25175000) return(25175000);

    freq/=1000;		/* round to kHz */

    /* Determines binary divider _bin */
    _bin=0;
    while (freq<40000lu && _bin<7)
      freq <<= 1, _bin++;

    /* Determines _mul and _div */
    for (i=0; i<128; i++)
      { register unsigned long t1=QUARZMUL*(i+3)/freq;
	register unsigned long t2=(t1+MUL/2)/MUL;
	register unsigned long t3=t1-t2*MUL;
	t2 -= 2;
	t3=(long)t3 > 0 ? t3 : -t3;
	t3=t3*127/(i+3);
	if (t2 > 127)
	  continue;
	if (t3 < _err)
	  _err=(unsigned)t3, _mul=i, _div=(unsigned)t2;
      }

    /* Determines the range variable _gen */
	 if (freq<40000l) _gen=0;
    else if (freq<50000l) _gen=1;
    else if (freq<72000l) _gen=3;
    else		  _gen=7;

    /* Calculates the value to set */
    _value=((unsigned long)2<<21) |	/* Always program generator 2 */
	   ((unsigned long)_gen <<17) |
	   ((unsigned long)_mul <<10) | (_bin<<7) | _div;

    /* returns the real frequency set */
    return ((((2*QUARZ*(_mul+3)/(_div+2))>>_bin)+1)>>1)*1000;

#undef MUL
#undef QUARZ
#undef QUARZMUL

  }

/* End of SETFREQ.C */

struct ggi_Range ClockPar[2]={{10000000,86000000},{0,0}};

struct ggi_Range *kgi_GetClockParameters(void)
{ return ClockPar; }

static int clock_ok(int old,int new)
{ old/=new/100; return(old>=99&&old<=101); }

int kgi_CheckClockTiming(struct ggi_Timing *TM,int cmd)
{ int oldfreq,o2;

  o2=oldfreq=TM->clock;

  if (oldfreq>ClockPar[0].max) TM->clock=ClockPar[0].max;
  if (oldfreq<ClockPar[0].min) TM->clock=ClockPar[0].min;

  do 
  { TM->clock=calcfreq(o2);
    switch (cmd)
    { case CMD_CLK_HIGHER: o2+=100;break;
      case CMD_CLK_LOWER :
      default            : o2-=100;break; }

    if (TM->clock<=ClockPar[0].min) 
    { TM->clock=ClockPar[0].min;
      return MR_LOWEST_CLOCK; }

    if (TM->clock>=ClockPar[0].max) 
    { TM->clock=ClockPar[0].max;
      return MR_HIGHEST_CLOCK; }

  }while(0/*TM->clock>oldfreq*/);

  if (clock_ok(oldfreq,TM->clock)) return(MR_OK);

  if (oldfreq>TM->clock) return(MR_LOWER_CLOCK);
  else                   return(MR_HIGHER_CLOCK);
}  

int kgi_SetClockTiming(struct ggi_Timing *TM)
{   
    if (TM->clock==0UL||TM->clock==25175000)
      { outb((inb(0x3CC) & 0xF3),0x3C2);return(0);}

    if (TM->clock>ClockPar[0].max||
        TM->clock<ClockPar[0].min) return(-1);

    if (TM->clock>ClockPar[0].max) TM->clock=ClockPar[0].max;
    if (TM->clock<ClockPar[0].min) TM->clock=ClockPar[0].min;
    calcfreq(TM->clock);
    /* Enable the programmable clock */
    outb((inb(0x3CC) & 0xF3) | 0x0C,0x3C2);
    /* And set it */
    setdotclock(&_value);

    return 0;
}

int kgi_ClockIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg)
{ switch(cmd)
  { default : return -ENODRVSUP_ALWAYS_CANT; }
}        

int kgi_ClockInit(void)
{ printk("ICS 2061 Clockchip driver V"VERSION" loading ...\n");
  return(0); }

void kgi_ClockCleanup(void) {}
